<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListTable StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ListTable extends AbstractStructBase
{
    /**
     * The lst_mdt_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $lst_mdt_name = null;
    /**
     * The lst_select_distinct
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $lst_select_distinct = null;
    /**
     * The mdt_description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $mdt_description = null;
    /**
     * The ListFromTables
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfListFromTable|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfListFromTable $ListFromTables = null;
    /**
     * Constructor method for ListTable
     * @uses ListTable::setLst_mdt_name()
     * @uses ListTable::setLst_select_distinct()
     * @uses ListTable::setMdt_description()
     * @uses ListTable::setListFromTables()
     * @param string $lst_mdt_name
     * @param string $lst_select_distinct
     * @param string $mdt_description
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfListFromTable $listFromTables
     */
    public function __construct(?string $lst_mdt_name = null, ?string $lst_select_distinct = null, ?string $mdt_description = null, ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfListFromTable $listFromTables = null)
    {
        $this
            ->setLst_mdt_name($lst_mdt_name)
            ->setLst_select_distinct($lst_select_distinct)
            ->setMdt_description($mdt_description)
            ->setListFromTables($listFromTables);
    }
    /**
     * Get lst_mdt_name value
     * @return string|null
     */
    public function getLst_mdt_name(): ?string
    {
        return $this->lst_mdt_name;
    }
    /**
     * Set lst_mdt_name value
     * @param string $lst_mdt_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\ListTable
     */
    public function setLst_mdt_name(?string $lst_mdt_name = null): self
    {
        // validation for constraint: string
        if (!is_null($lst_mdt_name) && !is_string($lst_mdt_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lst_mdt_name, true), gettype($lst_mdt_name)), __LINE__);
        }
        $this->lst_mdt_name = $lst_mdt_name;
        
        return $this;
    }
    /**
     * Get lst_select_distinct value
     * @return string|null
     */
    public function getLst_select_distinct(): ?string
    {
        return $this->lst_select_distinct;
    }
    /**
     * Set lst_select_distinct value
     * @param string $lst_select_distinct
     * @return \Drupal\netforum\xWeb\Generated\StructType\ListTable
     */
    public function setLst_select_distinct(?string $lst_select_distinct = null): self
    {
        // validation for constraint: string
        if (!is_null($lst_select_distinct) && !is_string($lst_select_distinct)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lst_select_distinct, true), gettype($lst_select_distinct)), __LINE__);
        }
        $this->lst_select_distinct = $lst_select_distinct;
        
        return $this;
    }
    /**
     * Get mdt_description value
     * @return string|null
     */
    public function getMdt_description(): ?string
    {
        return $this->mdt_description;
    }
    /**
     * Set mdt_description value
     * @param string $mdt_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\ListTable
     */
    public function setMdt_description(?string $mdt_description = null): self
    {
        // validation for constraint: string
        if (!is_null($mdt_description) && !is_string($mdt_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdt_description, true), gettype($mdt_description)), __LINE__);
        }
        $this->mdt_description = $mdt_description;
        
        return $this;
    }
    /**
     * Get ListFromTables value
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfListFromTable|null
     */
    public function getListFromTables(): ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfListFromTable
    {
        return $this->ListFromTables;
    }
    /**
     * Set ListFromTables value
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfListFromTable $listFromTables
     * @return \Drupal\netforum\xWeb\Generated\StructType\ListTable
     */
    public function setListFromTables(?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfListFromTable $listFromTables = null): self
    {
        $this->ListFromTables = $listFromTables;
        
        return $this;
    }
}
