<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mb_membershipType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Mb_membershipType extends AbstractStructBase
{
    /**
     * The Membership
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType $Membership = null;
    /**
     * The Chapter_Membership
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Membership_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Membership_DataObjectType $Chapter_Membership = null;
    /**
     * The Change_Membership
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType $Change_Membership = null;
    /**
     * The Invoice
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Invoice_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Invoice_DataObjectType $Invoice = null;
    /**
     * The Batch
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType $Batch = null;
    /**
     * The Inovice_Terms
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType $Inovice_Terms = null;
    /**
     * The Individual
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Individual_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Individual_DataObjectType $Individual = null;
    /**
     * The Customer
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Customer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Customer_DataObjectType $Customer = null;
    /**
     * The Customer_Lookup
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Customer_Lookup_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Customer_Lookup_DataObjectType $Customer_Lookup = null;
    /**
     * The Referring_Customer
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Referring_Customer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Referring_Customer_DataObjectType $Referring_Customer = null;
    /**
     * The Organization
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType $Organization = null;
    /**
     * The Membership_Invoices
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType $Membership_Invoices = null;
    /**
     * The Chapter
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_DataObjectType $Chapter = null;
    /**
     * The Member_Type
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType $Member_Type = null;
    /**
     * The Membership_Audit_Trail
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType $Membership_Audit_Trail = null;
    /**
     * The Member_Dues_History
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Dues_History_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Dues_History_DataObjectType $Member_Dues_History = null;
    /**
     * The Dues_Variables
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Dues_Variables_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Dues_Variables_DataObjectType $Dues_Variables = null;
    /**
     * The Payment
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_DataObjectType $Payment = null;
    /**
     * The Payment_Info
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_Info_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_Info_DataObjectType $Payment_Info = null;
    /**
     * The Payment_Method
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_Method_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_Method_DataObjectType $Payment_Method = null;
    /**
     * The Association_Package
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType $Association_Package = null;
    /**
     * The Association
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType $Association = null;
    /**
     * The Bundle
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Bundle_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Bundle_DataObjectType $Bundle = null;
    /**
     * The Installment_Billing
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType $Installment_Billing = null;
    /**
     * The Package_Component
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType $Package_Component = null;
    /**
     * The Package
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType $Package = null;
    /**
     * The Package_Renewal
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType $Package_Renewal = null;
    /**
     * The Product
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType $Product = null;
    /**
     * The Chapter_Product
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType $Chapter_Product = null;
    /**
     * The CustomerAddress
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_CustomerAddress_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_CustomerAddress_DataObjectType $CustomerAddress = null;
    /**
     * The source_code
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_source_code_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_source_code_DataObjectType $source_code = null;
    /**
     * The Invoice_DetailCollection
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $Invoice_DetailCollection = null;
    /**
     * The CurrentKey
     * Meta information extracted from the WSDL
     * - documentation: Primary Key.The current key is the record key for the object. This field must be set whenever updating an existing database record. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $CurrentKey = null;
    /**
     * Constructor method for mb_membershipType
     * @uses Mb_membershipType::setMembership()
     * @uses Mb_membershipType::setChapter_Membership()
     * @uses Mb_membershipType::setChange_Membership()
     * @uses Mb_membershipType::setInvoice()
     * @uses Mb_membershipType::setBatch()
     * @uses Mb_membershipType::setInovice_Terms()
     * @uses Mb_membershipType::setIndividual()
     * @uses Mb_membershipType::setCustomer()
     * @uses Mb_membershipType::setCustomer_Lookup()
     * @uses Mb_membershipType::setReferring_Customer()
     * @uses Mb_membershipType::setOrganization()
     * @uses Mb_membershipType::setMembership_Invoices()
     * @uses Mb_membershipType::setChapter()
     * @uses Mb_membershipType::setMember_Type()
     * @uses Mb_membershipType::setMembership_Audit_Trail()
     * @uses Mb_membershipType::setMember_Dues_History()
     * @uses Mb_membershipType::setDues_Variables()
     * @uses Mb_membershipType::setPayment()
     * @uses Mb_membershipType::setPayment_Info()
     * @uses Mb_membershipType::setPayment_Method()
     * @uses Mb_membershipType::setAssociation_Package()
     * @uses Mb_membershipType::setAssociation()
     * @uses Mb_membershipType::setBundle()
     * @uses Mb_membershipType::setInstallment_Billing()
     * @uses Mb_membershipType::setPackage_Component()
     * @uses Mb_membershipType::setPackage()
     * @uses Mb_membershipType::setPackage_Renewal()
     * @uses Mb_membershipType::setProduct()
     * @uses Mb_membershipType::setChapter_Product()
     * @uses Mb_membershipType::setCustomerAddress()
     * @uses Mb_membershipType::setSource_code()
     * @uses Mb_membershipType::setInvoice_DetailCollection()
     * @uses Mb_membershipType::setCurrentKey()
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType $membership
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Membership_DataObjectType $chapter_Membership
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType $change_Membership
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Invoice_DataObjectType $invoice
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType $batch
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType $inovice_Terms
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Individual_DataObjectType $individual
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Customer_DataObjectType $customer
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Customer_Lookup_DataObjectType $customer_Lookup
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Referring_Customer_DataObjectType $referring_Customer
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType $organization
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType $membership_Invoices
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_DataObjectType $chapter
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType $member_Type
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType $membership_Audit_Trail
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Dues_History_DataObjectType $member_Dues_History
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Dues_Variables_DataObjectType $dues_Variables
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_DataObjectType $payment
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_Info_DataObjectType $payment_Info
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_Method_DataObjectType $payment_Method
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType $association_Package
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType $association
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Bundle_DataObjectType $bundle
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType $installment_Billing
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType $package_Component
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType $package
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType $package_Renewal
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType $product
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType $chapter_Product
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_CustomerAddress_DataObjectType $customerAddress
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_source_code_DataObjectType $source_code
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $invoice_DetailCollection
     * @param string $currentKey
     */
    public function __construct(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType $membership = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Membership_DataObjectType $chapter_Membership = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType $change_Membership = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Invoice_DataObjectType $invoice = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType $batch = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType $inovice_Terms = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Individual_DataObjectType $individual = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Customer_DataObjectType $customer = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Customer_Lookup_DataObjectType $customer_Lookup = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Referring_Customer_DataObjectType $referring_Customer = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType $organization = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType $membership_Invoices = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_DataObjectType $chapter = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType $member_Type = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType $membership_Audit_Trail = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Dues_History_DataObjectType $member_Dues_History = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Dues_Variables_DataObjectType $dues_Variables = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_DataObjectType $payment = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_Info_DataObjectType $payment_Info = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_Method_DataObjectType $payment_Method = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType $association_Package = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType $association = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Bundle_DataObjectType $bundle = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType $installment_Billing = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType $package_Component = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType $package = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType $package_Renewal = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType $product = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType $chapter_Product = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_CustomerAddress_DataObjectType $customerAddress = null, ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_source_code_DataObjectType $source_code = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $invoice_DetailCollection = null, ?string $currentKey = null)
    {
        $this
            ->setMembership($membership)
            ->setChapter_Membership($chapter_Membership)
            ->setChange_Membership($change_Membership)
            ->setInvoice($invoice)
            ->setBatch($batch)
            ->setInovice_Terms($inovice_Terms)
            ->setIndividual($individual)
            ->setCustomer($customer)
            ->setCustomer_Lookup($customer_Lookup)
            ->setReferring_Customer($referring_Customer)
            ->setOrganization($organization)
            ->setMembership_Invoices($membership_Invoices)
            ->setChapter($chapter)
            ->setMember_Type($member_Type)
            ->setMembership_Audit_Trail($membership_Audit_Trail)
            ->setMember_Dues_History($member_Dues_History)
            ->setDues_Variables($dues_Variables)
            ->setPayment($payment)
            ->setPayment_Info($payment_Info)
            ->setPayment_Method($payment_Method)
            ->setAssociation_Package($association_Package)
            ->setAssociation($association)
            ->setBundle($bundle)
            ->setInstallment_Billing($installment_Billing)
            ->setPackage_Component($package_Component)
            ->setPackage($package)
            ->setPackage_Renewal($package_Renewal)
            ->setProduct($product)
            ->setChapter_Product($chapter_Product)
            ->setCustomerAddress($customerAddress)
            ->setSource_code($source_code)
            ->setInvoice_DetailCollection($invoice_DetailCollection)
            ->setCurrentKey($currentKey);
    }
    /**
     * Get Membership value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType|null
     */
    public function getMembership(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
    {
        return $this->Membership;
    }
    /**
     * Set Membership value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType $membership
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setMembership(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType $membership = null): self
    {
        $this->Membership = $membership;
        
        return $this;
    }
    /**
     * Get Chapter_Membership value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Membership_DataObjectType|null
     */
    public function getChapter_Membership(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Membership_DataObjectType
    {
        return $this->Chapter_Membership;
    }
    /**
     * Set Chapter_Membership value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Membership_DataObjectType $chapter_Membership
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setChapter_Membership(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Membership_DataObjectType $chapter_Membership = null): self
    {
        $this->Chapter_Membership = $chapter_Membership;
        
        return $this;
    }
    /**
     * Get Change_Membership value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType|null
     */
    public function getChange_Membership(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
    {
        return $this->Change_Membership;
    }
    /**
     * Set Change_Membership value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType $change_Membership
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setChange_Membership(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType $change_Membership = null): self
    {
        $this->Change_Membership = $change_Membership;
        
        return $this;
    }
    /**
     * Get Invoice value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Invoice_DataObjectType|null
     */
    public function getInvoice(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Invoice_DataObjectType
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Invoice_DataObjectType $invoice
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setInvoice(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Invoice_DataObjectType $invoice = null): self
    {
        $this->Invoice = $invoice;
        
        return $this;
    }
    /**
     * Get Batch value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType|null
     */
    public function getBatch(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
    {
        return $this->Batch;
    }
    /**
     * Set Batch value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType $batch
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setBatch(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType $batch = null): self
    {
        $this->Batch = $batch;
        
        return $this;
    }
    /**
     * Get Inovice_Terms value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType|null
     */
    public function getInovice_Terms(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType
    {
        return $this->Inovice_Terms;
    }
    /**
     * Set Inovice_Terms value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType $inovice_Terms
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setInovice_Terms(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType $inovice_Terms = null): self
    {
        $this->Inovice_Terms = $inovice_Terms;
        
        return $this;
    }
    /**
     * Get Individual value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Individual_DataObjectType|null
     */
    public function getIndividual(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Individual_DataObjectType
    {
        return $this->Individual;
    }
    /**
     * Set Individual value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Individual_DataObjectType $individual
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setIndividual(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Individual_DataObjectType $individual = null): self
    {
        $this->Individual = $individual;
        
        return $this;
    }
    /**
     * Get Customer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Customer_DataObjectType|null
     */
    public function getCustomer(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Customer_DataObjectType
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Customer_DataObjectType $customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setCustomer(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Customer_DataObjectType $customer = null): self
    {
        $this->Customer = $customer;
        
        return $this;
    }
    /**
     * Get Customer_Lookup value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Customer_Lookup_DataObjectType|null
     */
    public function getCustomer_Lookup(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Customer_Lookup_DataObjectType
    {
        return $this->Customer_Lookup;
    }
    /**
     * Set Customer_Lookup value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Customer_Lookup_DataObjectType $customer_Lookup
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setCustomer_Lookup(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Customer_Lookup_DataObjectType $customer_Lookup = null): self
    {
        $this->Customer_Lookup = $customer_Lookup;
        
        return $this;
    }
    /**
     * Get Referring_Customer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Referring_Customer_DataObjectType|null
     */
    public function getReferring_Customer(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Referring_Customer_DataObjectType
    {
        return $this->Referring_Customer;
    }
    /**
     * Set Referring_Customer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Referring_Customer_DataObjectType $referring_Customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setReferring_Customer(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Referring_Customer_DataObjectType $referring_Customer = null): self
    {
        $this->Referring_Customer = $referring_Customer;
        
        return $this;
    }
    /**
     * Get Organization value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType|null
     */
    public function getOrganization(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
    {
        return $this->Organization;
    }
    /**
     * Set Organization value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType $organization
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setOrganization(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType $organization = null): self
    {
        $this->Organization = $organization;
        
        return $this;
    }
    /**
     * Get Membership_Invoices value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType|null
     */
    public function getMembership_Invoices(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
    {
        return $this->Membership_Invoices;
    }
    /**
     * Set Membership_Invoices value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType $membership_Invoices
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setMembership_Invoices(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType $membership_Invoices = null): self
    {
        $this->Membership_Invoices = $membership_Invoices;
        
        return $this;
    }
    /**
     * Get Chapter value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_DataObjectType|null
     */
    public function getChapter(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_DataObjectType
    {
        return $this->Chapter;
    }
    /**
     * Set Chapter value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_DataObjectType $chapter
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setChapter(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_DataObjectType $chapter = null): self
    {
        $this->Chapter = $chapter;
        
        return $this;
    }
    /**
     * Get Member_Type value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType|null
     */
    public function getMember_Type(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
    {
        return $this->Member_Type;
    }
    /**
     * Set Member_Type value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType $member_Type
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setMember_Type(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType $member_Type = null): self
    {
        $this->Member_Type = $member_Type;
        
        return $this;
    }
    /**
     * Get Membership_Audit_Trail value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType|null
     */
    public function getMembership_Audit_Trail(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
    {
        return $this->Membership_Audit_Trail;
    }
    /**
     * Set Membership_Audit_Trail value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType $membership_Audit_Trail
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setMembership_Audit_Trail(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType $membership_Audit_Trail = null): self
    {
        $this->Membership_Audit_Trail = $membership_Audit_Trail;
        
        return $this;
    }
    /**
     * Get Member_Dues_History value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Dues_History_DataObjectType|null
     */
    public function getMember_Dues_History(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Dues_History_DataObjectType
    {
        return $this->Member_Dues_History;
    }
    /**
     * Set Member_Dues_History value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Dues_History_DataObjectType $member_Dues_History
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setMember_Dues_History(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Dues_History_DataObjectType $member_Dues_History = null): self
    {
        $this->Member_Dues_History = $member_Dues_History;
        
        return $this;
    }
    /**
     * Get Dues_Variables value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Dues_Variables_DataObjectType|null
     */
    public function getDues_Variables(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Dues_Variables_DataObjectType
    {
        return $this->Dues_Variables;
    }
    /**
     * Set Dues_Variables value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Dues_Variables_DataObjectType $dues_Variables
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setDues_Variables(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Dues_Variables_DataObjectType $dues_Variables = null): self
    {
        $this->Dues_Variables = $dues_Variables;
        
        return $this;
    }
    /**
     * Get Payment value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_DataObjectType|null
     */
    public function getPayment(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_DataObjectType
    {
        return $this->Payment;
    }
    /**
     * Set Payment value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_DataObjectType $payment
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setPayment(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_DataObjectType $payment = null): self
    {
        $this->Payment = $payment;
        
        return $this;
    }
    /**
     * Get Payment_Info value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_Info_DataObjectType|null
     */
    public function getPayment_Info(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_Info_DataObjectType
    {
        return $this->Payment_Info;
    }
    /**
     * Set Payment_Info value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_Info_DataObjectType $payment_Info
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setPayment_Info(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_Info_DataObjectType $payment_Info = null): self
    {
        $this->Payment_Info = $payment_Info;
        
        return $this;
    }
    /**
     * Get Payment_Method value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_Method_DataObjectType|null
     */
    public function getPayment_Method(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_Method_DataObjectType
    {
        return $this->Payment_Method;
    }
    /**
     * Set Payment_Method value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_Method_DataObjectType $payment_Method
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setPayment_Method(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Payment_Method_DataObjectType $payment_Method = null): self
    {
        $this->Payment_Method = $payment_Method;
        
        return $this;
    }
    /**
     * Get Association_Package value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType|null
     */
    public function getAssociation_Package(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType
    {
        return $this->Association_Package;
    }
    /**
     * Set Association_Package value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType $association_Package
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setAssociation_Package(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType $association_Package = null): self
    {
        $this->Association_Package = $association_Package;
        
        return $this;
    }
    /**
     * Get Association value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType|null
     */
    public function getAssociation(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
    {
        return $this->Association;
    }
    /**
     * Set Association value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType $association
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setAssociation(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType $association = null): self
    {
        $this->Association = $association;
        
        return $this;
    }
    /**
     * Get Bundle value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Bundle_DataObjectType|null
     */
    public function getBundle(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Bundle_DataObjectType
    {
        return $this->Bundle;
    }
    /**
     * Set Bundle value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Bundle_DataObjectType $bundle
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setBundle(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Bundle_DataObjectType $bundle = null): self
    {
        $this->Bundle = $bundle;
        
        return $this;
    }
    /**
     * Get Installment_Billing value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType|null
     */
    public function getInstallment_Billing(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
    {
        return $this->Installment_Billing;
    }
    /**
     * Set Installment_Billing value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType $installment_Billing
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setInstallment_Billing(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType $installment_Billing = null): self
    {
        $this->Installment_Billing = $installment_Billing;
        
        return $this;
    }
    /**
     * Get Package_Component value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType|null
     */
    public function getPackage_Component(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType
    {
        return $this->Package_Component;
    }
    /**
     * Set Package_Component value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType $package_Component
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setPackage_Component(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType $package_Component = null): self
    {
        $this->Package_Component = $package_Component;
        
        return $this;
    }
    /**
     * Get Package value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType|null
     */
    public function getPackage(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType
    {
        return $this->Package;
    }
    /**
     * Set Package value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType $package
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setPackage(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType $package = null): self
    {
        $this->Package = $package;
        
        return $this;
    }
    /**
     * Get Package_Renewal value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType|null
     */
    public function getPackage_Renewal(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType
    {
        return $this->Package_Renewal;
    }
    /**
     * Set Package_Renewal value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType $package_Renewal
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setPackage_Renewal(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType $package_Renewal = null): self
    {
        $this->Package_Renewal = $package_Renewal;
        
        return $this;
    }
    /**
     * Get Product value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType|null
     */
    public function getProduct(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType $product
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setProduct(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType $product = null): self
    {
        $this->Product = $product;
        
        return $this;
    }
    /**
     * Get Chapter_Product value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType|null
     */
    public function getChapter_Product(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
    {
        return $this->Chapter_Product;
    }
    /**
     * Set Chapter_Product value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType $chapter_Product
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setChapter_Product(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType $chapter_Product = null): self
    {
        $this->Chapter_Product = $chapter_Product;
        
        return $this;
    }
    /**
     * Get CustomerAddress value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_CustomerAddress_DataObjectType|null
     */
    public function getCustomerAddress(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_CustomerAddress_DataObjectType
    {
        return $this->CustomerAddress;
    }
    /**
     * Set CustomerAddress value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_CustomerAddress_DataObjectType $customerAddress
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setCustomerAddress(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_CustomerAddress_DataObjectType $customerAddress = null): self
    {
        $this->CustomerAddress = $customerAddress;
        
        return $this;
    }
    /**
     * Get source_code value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_source_code_DataObjectType|null
     */
    public function getSource_code(): ?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_source_code_DataObjectType
    {
        return $this->source_code;
    }
    /**
     * Set source_code value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_source_code_DataObjectType $source_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setSource_code(?\Drupal\netforum\xWeb\Generated\StructType\Mb_membership_source_code_DataObjectType $source_code = null): self
    {
        $this->source_code = $source_code;
        
        return $this;
    }
    /**
     * Get Invoice_DetailCollection value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType|null
     */
    public function getInvoice_DetailCollection(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType
    {
        return $this->Invoice_DetailCollection;
    }
    /**
     * Set Invoice_DetailCollection value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $invoice_DetailCollection
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setInvoice_DetailCollection(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $invoice_DetailCollection = null): self
    {
        $this->Invoice_DetailCollection = $invoice_DetailCollection;
        
        return $this;
    }
    /**
     * Get CurrentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentKey(): ?string
    {
        return $this->CurrentKey ?? null;
    }
    /**
     * Set CurrentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType
     */
    public function setCurrentKey(?string $currentKey = null): self
    {
        // validation for constraint: string
        if (!is_null($currentKey) && !is_string($currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentKey, true), gettype($currentKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($currentKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($currentKey, true)), __LINE__);
        }
        if (is_null($currentKey) || (is_array($currentKey) && empty($currentKey))) {
            unset($this->CurrentKey);
        } else {
            $this->CurrentKey = $currentKey;
        }
        
        return $this;
    }
}
