<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mb_membership_Batch_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Mb_membership_Batch_DataObjectType extends AbstractStructBase
{
    /**
     * The bat_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bat_key = null;
    /**
     * The bat_code
     * Meta information extracted from the WSDL
     * - documentation: Batch Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_code = null;
    /**
     * The bat_date
     * Meta information extracted from the WSDL
     * - documentation: Batch Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_date = null;
    /**
     * The bat_control_total
     * Meta information extracted from the WSDL
     * - documentation: Control Total Amount.This element has a default value of '$0.00'. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $bat_control_total = null;
    /**
     * The bat_control_trx_count
     * Meta information extracted from the WSDL
     * - documentation: Control Total Count.This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $bat_control_trx_count = null;
    /**
     * The bat_post_date
     * Meta information extracted from the WSDL
     * - documentation: Posted Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_post_date = null;
    /**
     * The bat_post_user
     * Meta information extracted from the WSDL
     * - documentation: Posted By. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_post_user = null;
    /**
     * The bat_post_flag
     * Meta information extracted from the WSDL
     * - documentation: Posted?.This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_post_flag = null;
    /**
     * The bat_export_date
     * Meta information extracted from the WSDL
     * - documentation: Export Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_export_date = null;
    /**
     * The bat_export_user
     * Meta information extracted from the WSDL
     * - documentation: Export User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_export_user = null;
    /**
     * The bat_export_flag
     * Meta information extracted from the WSDL
     * - documentation: Exported?.This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_export_flag = null;
    /**
     * The bat_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_add_user = null;
    /**
     * The bat_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_add_date = null;
    /**
     * The bat_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_change_user = null;
    /**
     * The bat_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_change_date = null;
    /**
     * The bat_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_delete_flag = null;
    /**
     * The bat_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bat_key_ext = null;
    /**
     * The bat_apm_key
     * Meta information extracted from the WSDL
     * - documentation: Default Payment Method. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bat_apm_key = null;
    /**
     * The bat_atc_key
     * Meta information extracted from the WSDL
     * - documentation: Company.This element has a default value of 'aad02d37-912e-47b0-88fe-ee3b6caf35da'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bat_atc_key = null;
    /**
     * The bat_arp_key
     * Meta information extracted from the WSDL
     * - documentation: Period. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bat_arp_key = null;
    /**
     * The bat_close_user
     * Meta information extracted from the WSDL
     * - documentation: Close User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_close_user = null;
    /**
     * The bat_close_date
     * Meta information extracted from the WSDL
     * - documentation: Close Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_close_date = null;
    /**
     * The bat_close_flag
     * Meta information extracted from the WSDL
     * - documentation: Close Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_close_flag = null;
    /**
     * The bat_notes
     * Meta information extracted from the WSDL
     * - documentation: Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 400
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_notes = null;
    /**
     * The bat_file
     * Meta information extracted from the WSDL
     * - documentation: Batch File. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 1000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_file = null;
    /**
     * The bat_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bat_entity_key = null;
    /**
     * The bat_intercompany_flag
     * Meta information extracted from the WSDL
     * - documentation: Contains Intercompany Transact. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_intercompany_flag = null;
    /**
     * The bat_file2
     * Meta information extracted from the WSDL
     * - documentation: Batch File 2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 1000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_file2 = null;
    /**
     * The bat_file3
     * Meta information extracted from the WSDL
     * - documentation: Batch File 3. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 1000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_file3 = null;
    /**
     * The bat_lock_flag
     * Meta information extracted from the WSDL
     * - documentation: Lock Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_lock_flag = null;
    /**
     * The bat_lock_date
     * Meta information extracted from the WSDL
     * - documentation: Lock Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_lock_date = null;
    /**
     * The bat_orig_trans_type
     * Meta information extracted from the WSDL
     * - documentation: Transaction Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bat_orig_trans_type = null;
    /**
     * Constructor method for mb_membership_Batch_DataObjectType
     * @uses Mb_membership_Batch_DataObjectType::setBat_key()
     * @uses Mb_membership_Batch_DataObjectType::setBat_code()
     * @uses Mb_membership_Batch_DataObjectType::setBat_date()
     * @uses Mb_membership_Batch_DataObjectType::setBat_control_total()
     * @uses Mb_membership_Batch_DataObjectType::setBat_control_trx_count()
     * @uses Mb_membership_Batch_DataObjectType::setBat_post_date()
     * @uses Mb_membership_Batch_DataObjectType::setBat_post_user()
     * @uses Mb_membership_Batch_DataObjectType::setBat_post_flag()
     * @uses Mb_membership_Batch_DataObjectType::setBat_export_date()
     * @uses Mb_membership_Batch_DataObjectType::setBat_export_user()
     * @uses Mb_membership_Batch_DataObjectType::setBat_export_flag()
     * @uses Mb_membership_Batch_DataObjectType::setBat_add_user()
     * @uses Mb_membership_Batch_DataObjectType::setBat_add_date()
     * @uses Mb_membership_Batch_DataObjectType::setBat_change_user()
     * @uses Mb_membership_Batch_DataObjectType::setBat_change_date()
     * @uses Mb_membership_Batch_DataObjectType::setBat_delete_flag()
     * @uses Mb_membership_Batch_DataObjectType::setBat_key_ext()
     * @uses Mb_membership_Batch_DataObjectType::setBat_apm_key()
     * @uses Mb_membership_Batch_DataObjectType::setBat_atc_key()
     * @uses Mb_membership_Batch_DataObjectType::setBat_arp_key()
     * @uses Mb_membership_Batch_DataObjectType::setBat_close_user()
     * @uses Mb_membership_Batch_DataObjectType::setBat_close_date()
     * @uses Mb_membership_Batch_DataObjectType::setBat_close_flag()
     * @uses Mb_membership_Batch_DataObjectType::setBat_notes()
     * @uses Mb_membership_Batch_DataObjectType::setBat_file()
     * @uses Mb_membership_Batch_DataObjectType::setBat_entity_key()
     * @uses Mb_membership_Batch_DataObjectType::setBat_intercompany_flag()
     * @uses Mb_membership_Batch_DataObjectType::setBat_file2()
     * @uses Mb_membership_Batch_DataObjectType::setBat_file3()
     * @uses Mb_membership_Batch_DataObjectType::setBat_lock_flag()
     * @uses Mb_membership_Batch_DataObjectType::setBat_lock_date()
     * @uses Mb_membership_Batch_DataObjectType::setBat_orig_trans_type()
     * @param string $bat_key
     * @param string $bat_code
     * @param string $bat_date
     * @param float $bat_control_total
     * @param int $bat_control_trx_count
     * @param string $bat_post_date
     * @param string $bat_post_user
     * @param string $bat_post_flag
     * @param string $bat_export_date
     * @param string $bat_export_user
     * @param string $bat_export_flag
     * @param string $bat_add_user
     * @param string $bat_add_date
     * @param string $bat_change_user
     * @param string $bat_change_date
     * @param string $bat_delete_flag
     * @param string $bat_key_ext
     * @param string $bat_apm_key
     * @param string $bat_atc_key
     * @param string $bat_arp_key
     * @param string $bat_close_user
     * @param string $bat_close_date
     * @param string $bat_close_flag
     * @param string $bat_notes
     * @param string $bat_file
     * @param string $bat_entity_key
     * @param string $bat_intercompany_flag
     * @param string $bat_file2
     * @param string $bat_file3
     * @param string $bat_lock_flag
     * @param string $bat_lock_date
     * @param string $bat_orig_trans_type
     */
    public function __construct(?string $bat_key = null, ?string $bat_code = null, ?string $bat_date = null, ?float $bat_control_total = null, ?int $bat_control_trx_count = null, ?string $bat_post_date = null, ?string $bat_post_user = null, ?string $bat_post_flag = null, ?string $bat_export_date = null, ?string $bat_export_user = null, ?string $bat_export_flag = null, ?string $bat_add_user = null, ?string $bat_add_date = null, ?string $bat_change_user = null, ?string $bat_change_date = null, ?string $bat_delete_flag = null, ?string $bat_key_ext = null, ?string $bat_apm_key = null, ?string $bat_atc_key = null, ?string $bat_arp_key = null, ?string $bat_close_user = null, ?string $bat_close_date = null, ?string $bat_close_flag = null, ?string $bat_notes = null, ?string $bat_file = null, ?string $bat_entity_key = null, ?string $bat_intercompany_flag = null, ?string $bat_file2 = null, ?string $bat_file3 = null, ?string $bat_lock_flag = null, ?string $bat_lock_date = null, ?string $bat_orig_trans_type = null)
    {
        $this
            ->setBat_key($bat_key)
            ->setBat_code($bat_code)
            ->setBat_date($bat_date)
            ->setBat_control_total($bat_control_total)
            ->setBat_control_trx_count($bat_control_trx_count)
            ->setBat_post_date($bat_post_date)
            ->setBat_post_user($bat_post_user)
            ->setBat_post_flag($bat_post_flag)
            ->setBat_export_date($bat_export_date)
            ->setBat_export_user($bat_export_user)
            ->setBat_export_flag($bat_export_flag)
            ->setBat_add_user($bat_add_user)
            ->setBat_add_date($bat_add_date)
            ->setBat_change_user($bat_change_user)
            ->setBat_change_date($bat_change_date)
            ->setBat_delete_flag($bat_delete_flag)
            ->setBat_key_ext($bat_key_ext)
            ->setBat_apm_key($bat_apm_key)
            ->setBat_atc_key($bat_atc_key)
            ->setBat_arp_key($bat_arp_key)
            ->setBat_close_user($bat_close_user)
            ->setBat_close_date($bat_close_date)
            ->setBat_close_flag($bat_close_flag)
            ->setBat_notes($bat_notes)
            ->setBat_file($bat_file)
            ->setBat_entity_key($bat_entity_key)
            ->setBat_intercompany_flag($bat_intercompany_flag)
            ->setBat_file2($bat_file2)
            ->setBat_file3($bat_file3)
            ->setBat_lock_flag($bat_lock_flag)
            ->setBat_lock_date($bat_lock_date)
            ->setBat_orig_trans_type($bat_orig_trans_type);
    }
    /**
     * Get bat_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_key(): ?string
    {
        return $this->bat_key ?? null;
    }
    /**
     * Set bat_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_key(?string $bat_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_key) && !is_string($bat_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_key, true), gettype($bat_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bat_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bat_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bat_key, true)), __LINE__);
        }
        if (is_null($bat_key) || (is_array($bat_key) && empty($bat_key))) {
            unset($this->bat_key);
        } else {
            $this->bat_key = $bat_key;
        }
        
        return $this;
    }
    /**
     * Get bat_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_code(): ?string
    {
        return $this->bat_code ?? null;
    }
    /**
     * Set bat_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_code(?string $bat_code = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_code) && !is_string($bat_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_code, true), gettype($bat_code)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($bat_code) && mb_strlen((string) $bat_code) > 60) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen((string) $bat_code)), __LINE__);
        }
        if (is_null($bat_code) || (is_array($bat_code) && empty($bat_code))) {
            unset($this->bat_code);
        } else {
            $this->bat_code = $bat_code;
        }
        
        return $this;
    }
    /**
     * Get bat_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_date(): ?string
    {
        return $this->bat_date ?? null;
    }
    /**
     * Set bat_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_date(?string $bat_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_date) && !is_string($bat_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_date, true), gettype($bat_date)), __LINE__);
        }
        if (is_null($bat_date) || (is_array($bat_date) && empty($bat_date))) {
            unset($this->bat_date);
        } else {
            $this->bat_date = $bat_date;
        }
        
        return $this;
    }
    /**
     * Get bat_control_total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBat_control_total(): ?float
    {
        return $this->bat_control_total ?? null;
    }
    /**
     * Set bat_control_total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $bat_control_total
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_control_total(?float $bat_control_total = null): self
    {
        // validation for constraint: float
        if (!is_null($bat_control_total) && !(is_float($bat_control_total) || is_numeric($bat_control_total))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bat_control_total, true), gettype($bat_control_total)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($bat_control_total) && mb_strlen(mb_substr((string) $bat_control_total, false !== mb_strpos((string) $bat_control_total, '.') ? mb_strpos((string) $bat_control_total, '.') + 1 : mb_strlen((string) $bat_control_total))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($bat_control_total, true), mb_strlen(mb_substr((string) $bat_control_total, mb_strpos((string) $bat_control_total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($bat_control_total) && mb_strlen(preg_replace('/(\D)/', '', (string) $bat_control_total)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($bat_control_total, true), mb_strlen(preg_replace('/(\D)/', '', (string) $bat_control_total))), __LINE__);
        }
        if (is_null($bat_control_total) || (is_array($bat_control_total) && empty($bat_control_total))) {
            unset($this->bat_control_total);
        } else {
            $this->bat_control_total = $bat_control_total;
        }
        
        return $this;
    }
    /**
     * Get bat_control_trx_count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBat_control_trx_count(): ?int
    {
        return $this->bat_control_trx_count ?? null;
    }
    /**
     * Set bat_control_trx_count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bat_control_trx_count
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_control_trx_count(?int $bat_control_trx_count = null): self
    {
        // validation for constraint: int
        if (!is_null($bat_control_trx_count) && !(is_int($bat_control_trx_count) || ctype_digit($bat_control_trx_count))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bat_control_trx_count, true), gettype($bat_control_trx_count)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($bat_control_trx_count) && $bat_control_trx_count > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($bat_control_trx_count, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($bat_control_trx_count) && $bat_control_trx_count < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($bat_control_trx_count, true)), __LINE__);
        }
        if (is_null($bat_control_trx_count) || (is_array($bat_control_trx_count) && empty($bat_control_trx_count))) {
            unset($this->bat_control_trx_count);
        } else {
            $this->bat_control_trx_count = $bat_control_trx_count;
        }
        
        return $this;
    }
    /**
     * Get bat_post_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_post_date(): ?string
    {
        return $this->bat_post_date ?? null;
    }
    /**
     * Set bat_post_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_post_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_post_date(?string $bat_post_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_post_date) && !is_string($bat_post_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_post_date, true), gettype($bat_post_date)), __LINE__);
        }
        if (is_null($bat_post_date) || (is_array($bat_post_date) && empty($bat_post_date))) {
            unset($this->bat_post_date);
        } else {
            $this->bat_post_date = $bat_post_date;
        }
        
        return $this;
    }
    /**
     * Get bat_post_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_post_user(): ?string
    {
        return $this->bat_post_user ?? null;
    }
    /**
     * Set bat_post_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_post_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_post_user(?string $bat_post_user = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_post_user) && !is_string($bat_post_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_post_user, true), gettype($bat_post_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bat_post_user) && mb_strlen((string) $bat_post_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $bat_post_user)), __LINE__);
        }
        if (is_null($bat_post_user) || (is_array($bat_post_user) && empty($bat_post_user))) {
            unset($this->bat_post_user);
        } else {
            $this->bat_post_user = $bat_post_user;
        }
        
        return $this;
    }
    /**
     * Get bat_post_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_post_flag(): ?string
    {
        return $this->bat_post_flag ?? null;
    }
    /**
     * Set bat_post_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_post_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_post_flag(?string $bat_post_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_post_flag) && !is_string($bat_post_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_post_flag, true), gettype($bat_post_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bat_post_flag) && $bat_post_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bat_post_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bat_post_flag) && $bat_post_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bat_post_flag, true)), __LINE__);
        }
        if (is_null($bat_post_flag) || (is_array($bat_post_flag) && empty($bat_post_flag))) {
            unset($this->bat_post_flag);
        } else {
            $this->bat_post_flag = $bat_post_flag;
        }
        
        return $this;
    }
    /**
     * Get bat_export_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_export_date(): ?string
    {
        return $this->bat_export_date ?? null;
    }
    /**
     * Set bat_export_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_export_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_export_date(?string $bat_export_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_export_date) && !is_string($bat_export_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_export_date, true), gettype($bat_export_date)), __LINE__);
        }
        if (is_null($bat_export_date) || (is_array($bat_export_date) && empty($bat_export_date))) {
            unset($this->bat_export_date);
        } else {
            $this->bat_export_date = $bat_export_date;
        }
        
        return $this;
    }
    /**
     * Get bat_export_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_export_user(): ?string
    {
        return $this->bat_export_user ?? null;
    }
    /**
     * Set bat_export_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_export_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_export_user(?string $bat_export_user = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_export_user) && !is_string($bat_export_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_export_user, true), gettype($bat_export_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bat_export_user) && mb_strlen((string) $bat_export_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $bat_export_user)), __LINE__);
        }
        if (is_null($bat_export_user) || (is_array($bat_export_user) && empty($bat_export_user))) {
            unset($this->bat_export_user);
        } else {
            $this->bat_export_user = $bat_export_user;
        }
        
        return $this;
    }
    /**
     * Get bat_export_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_export_flag(): ?string
    {
        return $this->bat_export_flag ?? null;
    }
    /**
     * Set bat_export_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_export_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_export_flag(?string $bat_export_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_export_flag) && !is_string($bat_export_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_export_flag, true), gettype($bat_export_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bat_export_flag) && $bat_export_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bat_export_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bat_export_flag) && $bat_export_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bat_export_flag, true)), __LINE__);
        }
        if (is_null($bat_export_flag) || (is_array($bat_export_flag) && empty($bat_export_flag))) {
            unset($this->bat_export_flag);
        } else {
            $this->bat_export_flag = $bat_export_flag;
        }
        
        return $this;
    }
    /**
     * Get bat_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_add_user(): ?string
    {
        return $this->bat_add_user ?? null;
    }
    /**
     * Set bat_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_add_user(?string $bat_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_add_user) && !is_string($bat_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_add_user, true), gettype($bat_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bat_add_user) && mb_strlen((string) $bat_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $bat_add_user)), __LINE__);
        }
        if (is_null($bat_add_user) || (is_array($bat_add_user) && empty($bat_add_user))) {
            unset($this->bat_add_user);
        } else {
            $this->bat_add_user = $bat_add_user;
        }
        
        return $this;
    }
    /**
     * Get bat_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_add_date(): ?string
    {
        return $this->bat_add_date ?? null;
    }
    /**
     * Set bat_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_add_date(?string $bat_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_add_date) && !is_string($bat_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_add_date, true), gettype($bat_add_date)), __LINE__);
        }
        if (is_null($bat_add_date) || (is_array($bat_add_date) && empty($bat_add_date))) {
            unset($this->bat_add_date);
        } else {
            $this->bat_add_date = $bat_add_date;
        }
        
        return $this;
    }
    /**
     * Get bat_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_change_user(): ?string
    {
        return $this->bat_change_user ?? null;
    }
    /**
     * Set bat_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_change_user(?string $bat_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_change_user) && !is_string($bat_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_change_user, true), gettype($bat_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bat_change_user) && mb_strlen((string) $bat_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $bat_change_user)), __LINE__);
        }
        if (is_null($bat_change_user) || (is_array($bat_change_user) && empty($bat_change_user))) {
            unset($this->bat_change_user);
        } else {
            $this->bat_change_user = $bat_change_user;
        }
        
        return $this;
    }
    /**
     * Get bat_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_change_date(): ?string
    {
        return $this->bat_change_date ?? null;
    }
    /**
     * Set bat_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_change_date(?string $bat_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_change_date) && !is_string($bat_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_change_date, true), gettype($bat_change_date)), __LINE__);
        }
        if (is_null($bat_change_date) || (is_array($bat_change_date) && empty($bat_change_date))) {
            unset($this->bat_change_date);
        } else {
            $this->bat_change_date = $bat_change_date;
        }
        
        return $this;
    }
    /**
     * Get bat_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_delete_flag(): ?string
    {
        return $this->bat_delete_flag ?? null;
    }
    /**
     * Set bat_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_delete_flag(?string $bat_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_delete_flag) && !is_string($bat_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_delete_flag, true), gettype($bat_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bat_delete_flag) && $bat_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bat_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bat_delete_flag) && $bat_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bat_delete_flag, true)), __LINE__);
        }
        if (is_null($bat_delete_flag) || (is_array($bat_delete_flag) && empty($bat_delete_flag))) {
            unset($this->bat_delete_flag);
        } else {
            $this->bat_delete_flag = $bat_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get bat_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_key_ext(): ?string
    {
        return $this->bat_key_ext ?? null;
    }
    /**
     * Set bat_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_key_ext(?string $bat_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_key_ext) && !is_string($bat_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_key_ext, true), gettype($bat_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bat_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bat_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bat_key_ext, true)), __LINE__);
        }
        if (is_null($bat_key_ext) || (is_array($bat_key_ext) && empty($bat_key_ext))) {
            unset($this->bat_key_ext);
        } else {
            $this->bat_key_ext = $bat_key_ext;
        }
        
        return $this;
    }
    /**
     * Get bat_apm_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_apm_key(): ?string
    {
        return $this->bat_apm_key ?? null;
    }
    /**
     * Set bat_apm_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_apm_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_apm_key(?string $bat_apm_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_apm_key) && !is_string($bat_apm_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_apm_key, true), gettype($bat_apm_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bat_apm_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bat_apm_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bat_apm_key, true)), __LINE__);
        }
        if (is_null($bat_apm_key) || (is_array($bat_apm_key) && empty($bat_apm_key))) {
            unset($this->bat_apm_key);
        } else {
            $this->bat_apm_key = $bat_apm_key;
        }
        
        return $this;
    }
    /**
     * Get bat_atc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_atc_key(): ?string
    {
        return $this->bat_atc_key ?? null;
    }
    /**
     * Set bat_atc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_atc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_atc_key(?string $bat_atc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_atc_key) && !is_string($bat_atc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_atc_key, true), gettype($bat_atc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bat_atc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bat_atc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bat_atc_key, true)), __LINE__);
        }
        if (is_null($bat_atc_key) || (is_array($bat_atc_key) && empty($bat_atc_key))) {
            unset($this->bat_atc_key);
        } else {
            $this->bat_atc_key = $bat_atc_key;
        }
        
        return $this;
    }
    /**
     * Get bat_arp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_arp_key(): ?string
    {
        return $this->bat_arp_key ?? null;
    }
    /**
     * Set bat_arp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_arp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_arp_key(?string $bat_arp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_arp_key) && !is_string($bat_arp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_arp_key, true), gettype($bat_arp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bat_arp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bat_arp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bat_arp_key, true)), __LINE__);
        }
        if (is_null($bat_arp_key) || (is_array($bat_arp_key) && empty($bat_arp_key))) {
            unset($this->bat_arp_key);
        } else {
            $this->bat_arp_key = $bat_arp_key;
        }
        
        return $this;
    }
    /**
     * Get bat_close_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_close_user(): ?string
    {
        return $this->bat_close_user ?? null;
    }
    /**
     * Set bat_close_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_close_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_close_user(?string $bat_close_user = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_close_user) && !is_string($bat_close_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_close_user, true), gettype($bat_close_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bat_close_user) && mb_strlen((string) $bat_close_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $bat_close_user)), __LINE__);
        }
        if (is_null($bat_close_user) || (is_array($bat_close_user) && empty($bat_close_user))) {
            unset($this->bat_close_user);
        } else {
            $this->bat_close_user = $bat_close_user;
        }
        
        return $this;
    }
    /**
     * Get bat_close_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_close_date(): ?string
    {
        return $this->bat_close_date ?? null;
    }
    /**
     * Set bat_close_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_close_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_close_date(?string $bat_close_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_close_date) && !is_string($bat_close_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_close_date, true), gettype($bat_close_date)), __LINE__);
        }
        if (is_null($bat_close_date) || (is_array($bat_close_date) && empty($bat_close_date))) {
            unset($this->bat_close_date);
        } else {
            $this->bat_close_date = $bat_close_date;
        }
        
        return $this;
    }
    /**
     * Get bat_close_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_close_flag(): ?string
    {
        return $this->bat_close_flag ?? null;
    }
    /**
     * Set bat_close_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_close_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_close_flag(?string $bat_close_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_close_flag) && !is_string($bat_close_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_close_flag, true), gettype($bat_close_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bat_close_flag) && $bat_close_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bat_close_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bat_close_flag) && $bat_close_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bat_close_flag, true)), __LINE__);
        }
        if (is_null($bat_close_flag) || (is_array($bat_close_flag) && empty($bat_close_flag))) {
            unset($this->bat_close_flag);
        } else {
            $this->bat_close_flag = $bat_close_flag;
        }
        
        return $this;
    }
    /**
     * Get bat_notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_notes(): ?string
    {
        return $this->bat_notes ?? null;
    }
    /**
     * Set bat_notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_notes
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_notes(?string $bat_notes = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_notes) && !is_string($bat_notes)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_notes, true), gettype($bat_notes)), __LINE__);
        }
        // validation for constraint: maxLength(400)
        if (!is_null($bat_notes) && mb_strlen((string) $bat_notes) > 400) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 400', mb_strlen((string) $bat_notes)), __LINE__);
        }
        if (is_null($bat_notes) || (is_array($bat_notes) && empty($bat_notes))) {
            unset($this->bat_notes);
        } else {
            $this->bat_notes = $bat_notes;
        }
        
        return $this;
    }
    /**
     * Get bat_file value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_file(): ?string
    {
        return $this->bat_file ?? null;
    }
    /**
     * Set bat_file value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_file
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_file(?string $bat_file = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_file) && !is_string($bat_file)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_file, true), gettype($bat_file)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($bat_file) && mb_strlen((string) $bat_file) > 1000) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen((string) $bat_file)), __LINE__);
        }
        if (is_null($bat_file) || (is_array($bat_file) && empty($bat_file))) {
            unset($this->bat_file);
        } else {
            $this->bat_file = $bat_file;
        }
        
        return $this;
    }
    /**
     * Get bat_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_entity_key(): ?string
    {
        return $this->bat_entity_key ?? null;
    }
    /**
     * Set bat_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_entity_key(?string $bat_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_entity_key) && !is_string($bat_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_entity_key, true), gettype($bat_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bat_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bat_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bat_entity_key, true)), __LINE__);
        }
        if (is_null($bat_entity_key) || (is_array($bat_entity_key) && empty($bat_entity_key))) {
            unset($this->bat_entity_key);
        } else {
            $this->bat_entity_key = $bat_entity_key;
        }
        
        return $this;
    }
    /**
     * Get bat_intercompany_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_intercompany_flag(): ?string
    {
        return $this->bat_intercompany_flag ?? null;
    }
    /**
     * Set bat_intercompany_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_intercompany_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_intercompany_flag(?string $bat_intercompany_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_intercompany_flag) && !is_string($bat_intercompany_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_intercompany_flag, true), gettype($bat_intercompany_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bat_intercompany_flag) && $bat_intercompany_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bat_intercompany_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bat_intercompany_flag) && $bat_intercompany_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bat_intercompany_flag, true)), __LINE__);
        }
        if (is_null($bat_intercompany_flag) || (is_array($bat_intercompany_flag) && empty($bat_intercompany_flag))) {
            unset($this->bat_intercompany_flag);
        } else {
            $this->bat_intercompany_flag = $bat_intercompany_flag;
        }
        
        return $this;
    }
    /**
     * Get bat_file2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_file2(): ?string
    {
        return $this->bat_file2 ?? null;
    }
    /**
     * Set bat_file2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_file2
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_file2(?string $bat_file2 = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_file2) && !is_string($bat_file2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_file2, true), gettype($bat_file2)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($bat_file2) && mb_strlen((string) $bat_file2) > 1000) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen((string) $bat_file2)), __LINE__);
        }
        if (is_null($bat_file2) || (is_array($bat_file2) && empty($bat_file2))) {
            unset($this->bat_file2);
        } else {
            $this->bat_file2 = $bat_file2;
        }
        
        return $this;
    }
    /**
     * Get bat_file3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_file3(): ?string
    {
        return $this->bat_file3 ?? null;
    }
    /**
     * Set bat_file3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_file3
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_file3(?string $bat_file3 = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_file3) && !is_string($bat_file3)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_file3, true), gettype($bat_file3)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($bat_file3) && mb_strlen((string) $bat_file3) > 1000) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen((string) $bat_file3)), __LINE__);
        }
        if (is_null($bat_file3) || (is_array($bat_file3) && empty($bat_file3))) {
            unset($this->bat_file3);
        } else {
            $this->bat_file3 = $bat_file3;
        }
        
        return $this;
    }
    /**
     * Get bat_lock_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_lock_flag(): ?string
    {
        return $this->bat_lock_flag ?? null;
    }
    /**
     * Set bat_lock_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_lock_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_lock_flag(?string $bat_lock_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_lock_flag) && !is_string($bat_lock_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_lock_flag, true), gettype($bat_lock_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bat_lock_flag) && $bat_lock_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bat_lock_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bat_lock_flag) && $bat_lock_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bat_lock_flag, true)), __LINE__);
        }
        if (is_null($bat_lock_flag) || (is_array($bat_lock_flag) && empty($bat_lock_flag))) {
            unset($this->bat_lock_flag);
        } else {
            $this->bat_lock_flag = $bat_lock_flag;
        }
        
        return $this;
    }
    /**
     * Get bat_lock_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_lock_date(): ?string
    {
        return $this->bat_lock_date ?? null;
    }
    /**
     * Set bat_lock_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_lock_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_lock_date(?string $bat_lock_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_lock_date) && !is_string($bat_lock_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_lock_date, true), gettype($bat_lock_date)), __LINE__);
        }
        if (is_null($bat_lock_date) || (is_array($bat_lock_date) && empty($bat_lock_date))) {
            unset($this->bat_lock_date);
        } else {
            $this->bat_lock_date = $bat_lock_date;
        }
        
        return $this;
    }
    /**
     * Get bat_orig_trans_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBat_orig_trans_type(): ?string
    {
        return $this->bat_orig_trans_type ?? null;
    }
    /**
     * Set bat_orig_trans_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bat_orig_trans_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Batch_DataObjectType
     */
    public function setBat_orig_trans_type(?string $bat_orig_trans_type = null): self
    {
        // validation for constraint: string
        if (!is_null($bat_orig_trans_type) && !is_string($bat_orig_trans_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bat_orig_trans_type, true), gettype($bat_orig_trans_type)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($bat_orig_trans_type) && mb_strlen((string) $bat_orig_trans_type) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $bat_orig_trans_type)), __LINE__);
        }
        if (is_null($bat_orig_trans_type) || (is_array($bat_orig_trans_type) && empty($bat_orig_trans_type))) {
            unset($this->bat_orig_trans_type);
        } else {
            $this->bat_orig_trans_type = $bat_orig_trans_type;
        }
        
        return $this;
    }
}
