<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mb_membership_Membership_Audit_Trail_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Mb_membership_Membership_Audit_Trail_DataObjectType extends AbstractStructBase
{
    /**
     * The mat_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mat_key = null;
    /**
     * The mat_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mat_cst_key = null;
    /**
     * The mat_asn_code
     * Meta information extracted from the WSDL
     * - documentation: Association Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mat_asn_code = null;
    /**
     * The mat_mbt_key
     * Meta information extracted from the WSDL
     * - documentation: Member Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mat_mbt_key = null;
    /**
     * The mat_mbs_key
     * Meta information extracted from the WSDL
     * - documentation: Member Status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mat_mbs_key = null;
    /**
     * The mat_join_date
     * Meta information extracted from the WSDL
     * - documentation: Join Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mat_join_date = null;
    /**
     * The mat_renew_date
     * Meta information extracted from the WSDL
     * - documentation: Renew Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mat_renew_date = null;
    /**
     * The mat_expire_date
     * Meta information extracted from the WSDL
     * - documentation: Expire Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mat_expire_date = null;
    /**
     * The mat_terminate_date
     * Meta information extracted from the WSDL
     * - documentation: Termination Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mat_terminate_date = null;
    /**
     * The mat_src_key
     * Meta information extracted from the WSDL
     * - documentation: Source. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mat_src_key = null;
    /**
     * The mat_src_code
     * Meta information extracted from the WSDL
     * - documentation: Source Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mat_src_code = null;
    /**
     * The mat_opt_out
     * Meta information extracted from the WSDL
     * - documentation: Opt Out Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mat_opt_out = null;
    /**
     * The mat_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mat_add_user = null;
    /**
     * The mat_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mat_add_date = null;
    /**
     * The mat_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mat_change_user = null;
    /**
     * The mat_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mat_change_date = null;
    /**
     * The mat_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mat_delete_flag = null;
    /**
     * The mat_mbr_key
     * Meta information extracted from the WSDL
     * - documentation: Membership. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mat_mbr_key = null;
    /**
     * The mat_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mat_key_ext = null;
    /**
     * The mat_mbr_chp_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Chapter. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mat_mbr_chp_cst_key = null;
    /**
     * The mat_rejoin_date
     * Meta information extracted from the WSDL
     * - documentation: rejoin date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mat_rejoin_date = null;
    /**
     * The mat_invoice_date
     * Meta information extracted from the WSDL
     * - documentation: Invoice Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mat_invoice_date = null;
    /**
     * The mat_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mat_entity_key = null;
    /**
     * The mat_terminate_reason
     * Meta information extracted from the WSDL
     * - documentation: Termination Reason. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mat_terminate_reason = null;
    /**
     * The mat_mtr_key
     * Meta information extracted from the WSDL
     * - documentation: Terminate Reason Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mat_mtr_key = null;
    /**
     * Constructor method for mb_membership_Membership_Audit_Trail_DataObjectType
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_key()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_cst_key()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_asn_code()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_mbt_key()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_mbs_key()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_join_date()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_renew_date()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_expire_date()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_terminate_date()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_src_key()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_src_code()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_opt_out()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_add_user()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_add_date()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_change_user()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_change_date()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_delete_flag()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_mbr_key()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_key_ext()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_mbr_chp_cst_key()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_rejoin_date()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_invoice_date()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_entity_key()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_terminate_reason()
     * @uses Mb_membership_Membership_Audit_Trail_DataObjectType::setMat_mtr_key()
     * @param string $mat_key
     * @param string $mat_cst_key
     * @param string $mat_asn_code
     * @param string $mat_mbt_key
     * @param string $mat_mbs_key
     * @param string $mat_join_date
     * @param string $mat_renew_date
     * @param string $mat_expire_date
     * @param string $mat_terminate_date
     * @param string $mat_src_key
     * @param string $mat_src_code
     * @param string $mat_opt_out
     * @param string $mat_add_user
     * @param string $mat_add_date
     * @param string $mat_change_user
     * @param string $mat_change_date
     * @param string $mat_delete_flag
     * @param string $mat_mbr_key
     * @param string $mat_key_ext
     * @param string $mat_mbr_chp_cst_key
     * @param string $mat_rejoin_date
     * @param string $mat_invoice_date
     * @param string $mat_entity_key
     * @param string $mat_terminate_reason
     * @param string $mat_mtr_key
     */
    public function __construct(?string $mat_key = null, ?string $mat_cst_key = null, ?string $mat_asn_code = null, ?string $mat_mbt_key = null, ?string $mat_mbs_key = null, ?string $mat_join_date = null, ?string $mat_renew_date = null, ?string $mat_expire_date = null, ?string $mat_terminate_date = null, ?string $mat_src_key = null, ?string $mat_src_code = null, ?string $mat_opt_out = null, ?string $mat_add_user = null, ?string $mat_add_date = null, ?string $mat_change_user = null, ?string $mat_change_date = null, ?string $mat_delete_flag = null, ?string $mat_mbr_key = null, ?string $mat_key_ext = null, ?string $mat_mbr_chp_cst_key = null, ?string $mat_rejoin_date = null, ?string $mat_invoice_date = null, ?string $mat_entity_key = null, ?string $mat_terminate_reason = null, ?string $mat_mtr_key = null)
    {
        $this
            ->setMat_key($mat_key)
            ->setMat_cst_key($mat_cst_key)
            ->setMat_asn_code($mat_asn_code)
            ->setMat_mbt_key($mat_mbt_key)
            ->setMat_mbs_key($mat_mbs_key)
            ->setMat_join_date($mat_join_date)
            ->setMat_renew_date($mat_renew_date)
            ->setMat_expire_date($mat_expire_date)
            ->setMat_terminate_date($mat_terminate_date)
            ->setMat_src_key($mat_src_key)
            ->setMat_src_code($mat_src_code)
            ->setMat_opt_out($mat_opt_out)
            ->setMat_add_user($mat_add_user)
            ->setMat_add_date($mat_add_date)
            ->setMat_change_user($mat_change_user)
            ->setMat_change_date($mat_change_date)
            ->setMat_delete_flag($mat_delete_flag)
            ->setMat_mbr_key($mat_mbr_key)
            ->setMat_key_ext($mat_key_ext)
            ->setMat_mbr_chp_cst_key($mat_mbr_chp_cst_key)
            ->setMat_rejoin_date($mat_rejoin_date)
            ->setMat_invoice_date($mat_invoice_date)
            ->setMat_entity_key($mat_entity_key)
            ->setMat_terminate_reason($mat_terminate_reason)
            ->setMat_mtr_key($mat_mtr_key);
    }
    /**
     * Get mat_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_key(): ?string
    {
        return $this->mat_key ?? null;
    }
    /**
     * Set mat_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_key(?string $mat_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_key) && !is_string($mat_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_key, true), gettype($mat_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mat_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mat_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mat_key, true)), __LINE__);
        }
        if (is_null($mat_key) || (is_array($mat_key) && empty($mat_key))) {
            unset($this->mat_key);
        } else {
            $this->mat_key = $mat_key;
        }
        
        return $this;
    }
    /**
     * Get mat_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_cst_key(): ?string
    {
        return $this->mat_cst_key ?? null;
    }
    /**
     * Set mat_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_cst_key(?string $mat_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_cst_key) && !is_string($mat_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_cst_key, true), gettype($mat_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mat_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mat_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mat_cst_key, true)), __LINE__);
        }
        if (is_null($mat_cst_key) || (is_array($mat_cst_key) && empty($mat_cst_key))) {
            unset($this->mat_cst_key);
        } else {
            $this->mat_cst_key = $mat_cst_key;
        }
        
        return $this;
    }
    /**
     * Get mat_asn_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_asn_code(): ?string
    {
        return $this->mat_asn_code ?? null;
    }
    /**
     * Set mat_asn_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_asn_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_asn_code(?string $mat_asn_code = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_asn_code) && !is_string($mat_asn_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_asn_code, true), gettype($mat_asn_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($mat_asn_code) && mb_strlen((string) $mat_asn_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $mat_asn_code)), __LINE__);
        }
        if (is_null($mat_asn_code) || (is_array($mat_asn_code) && empty($mat_asn_code))) {
            unset($this->mat_asn_code);
        } else {
            $this->mat_asn_code = $mat_asn_code;
        }
        
        return $this;
    }
    /**
     * Get mat_mbt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_mbt_key(): ?string
    {
        return $this->mat_mbt_key ?? null;
    }
    /**
     * Set mat_mbt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_mbt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_mbt_key(?string $mat_mbt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_mbt_key) && !is_string($mat_mbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_mbt_key, true), gettype($mat_mbt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mat_mbt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mat_mbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mat_mbt_key, true)), __LINE__);
        }
        if (is_null($mat_mbt_key) || (is_array($mat_mbt_key) && empty($mat_mbt_key))) {
            unset($this->mat_mbt_key);
        } else {
            $this->mat_mbt_key = $mat_mbt_key;
        }
        
        return $this;
    }
    /**
     * Get mat_mbs_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_mbs_key(): ?string
    {
        return $this->mat_mbs_key ?? null;
    }
    /**
     * Set mat_mbs_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_mbs_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_mbs_key(?string $mat_mbs_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_mbs_key) && !is_string($mat_mbs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_mbs_key, true), gettype($mat_mbs_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mat_mbs_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mat_mbs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mat_mbs_key, true)), __LINE__);
        }
        if (is_null($mat_mbs_key) || (is_array($mat_mbs_key) && empty($mat_mbs_key))) {
            unset($this->mat_mbs_key);
        } else {
            $this->mat_mbs_key = $mat_mbs_key;
        }
        
        return $this;
    }
    /**
     * Get mat_join_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_join_date(): ?string
    {
        return $this->mat_join_date ?? null;
    }
    /**
     * Set mat_join_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_join_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_join_date(?string $mat_join_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_join_date) && !is_string($mat_join_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_join_date, true), gettype($mat_join_date)), __LINE__);
        }
        if (is_null($mat_join_date) || (is_array($mat_join_date) && empty($mat_join_date))) {
            unset($this->mat_join_date);
        } else {
            $this->mat_join_date = $mat_join_date;
        }
        
        return $this;
    }
    /**
     * Get mat_renew_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_renew_date(): ?string
    {
        return $this->mat_renew_date ?? null;
    }
    /**
     * Set mat_renew_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_renew_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_renew_date(?string $mat_renew_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_renew_date) && !is_string($mat_renew_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_renew_date, true), gettype($mat_renew_date)), __LINE__);
        }
        if (is_null($mat_renew_date) || (is_array($mat_renew_date) && empty($mat_renew_date))) {
            unset($this->mat_renew_date);
        } else {
            $this->mat_renew_date = $mat_renew_date;
        }
        
        return $this;
    }
    /**
     * Get mat_expire_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_expire_date(): ?string
    {
        return $this->mat_expire_date ?? null;
    }
    /**
     * Set mat_expire_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_expire_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_expire_date(?string $mat_expire_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_expire_date) && !is_string($mat_expire_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_expire_date, true), gettype($mat_expire_date)), __LINE__);
        }
        if (is_null($mat_expire_date) || (is_array($mat_expire_date) && empty($mat_expire_date))) {
            unset($this->mat_expire_date);
        } else {
            $this->mat_expire_date = $mat_expire_date;
        }
        
        return $this;
    }
    /**
     * Get mat_terminate_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_terminate_date(): ?string
    {
        return $this->mat_terminate_date ?? null;
    }
    /**
     * Set mat_terminate_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_terminate_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_terminate_date(?string $mat_terminate_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_terminate_date) && !is_string($mat_terminate_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_terminate_date, true), gettype($mat_terminate_date)), __LINE__);
        }
        if (is_null($mat_terminate_date) || (is_array($mat_terminate_date) && empty($mat_terminate_date))) {
            unset($this->mat_terminate_date);
        } else {
            $this->mat_terminate_date = $mat_terminate_date;
        }
        
        return $this;
    }
    /**
     * Get mat_src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_src_key(): ?string
    {
        return $this->mat_src_key ?? null;
    }
    /**
     * Set mat_src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_src_key(?string $mat_src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_src_key) && !is_string($mat_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_src_key, true), gettype($mat_src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mat_src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mat_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mat_src_key, true)), __LINE__);
        }
        if (is_null($mat_src_key) || (is_array($mat_src_key) && empty($mat_src_key))) {
            unset($this->mat_src_key);
        } else {
            $this->mat_src_key = $mat_src_key;
        }
        
        return $this;
    }
    /**
     * Get mat_src_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_src_code(): ?string
    {
        return $this->mat_src_code ?? null;
    }
    /**
     * Set mat_src_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_src_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_src_code(?string $mat_src_code = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_src_code) && !is_string($mat_src_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_src_code, true), gettype($mat_src_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($mat_src_code) && mb_strlen((string) $mat_src_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $mat_src_code)), __LINE__);
        }
        if (is_null($mat_src_code) || (is_array($mat_src_code) && empty($mat_src_code))) {
            unset($this->mat_src_code);
        } else {
            $this->mat_src_code = $mat_src_code;
        }
        
        return $this;
    }
    /**
     * Get mat_opt_out value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_opt_out(): ?string
    {
        return $this->mat_opt_out ?? null;
    }
    /**
     * Set mat_opt_out value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_opt_out
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_opt_out(?string $mat_opt_out = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_opt_out) && !is_string($mat_opt_out)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_opt_out, true), gettype($mat_opt_out)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mat_opt_out) && $mat_opt_out > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mat_opt_out, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mat_opt_out) && $mat_opt_out < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mat_opt_out, true)), __LINE__);
        }
        if (is_null($mat_opt_out) || (is_array($mat_opt_out) && empty($mat_opt_out))) {
            unset($this->mat_opt_out);
        } else {
            $this->mat_opt_out = $mat_opt_out;
        }
        
        return $this;
    }
    /**
     * Get mat_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_add_user(): ?string
    {
        return $this->mat_add_user ?? null;
    }
    /**
     * Set mat_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_add_user(?string $mat_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_add_user) && !is_string($mat_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_add_user, true), gettype($mat_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($mat_add_user) && mb_strlen((string) $mat_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $mat_add_user)), __LINE__);
        }
        if (is_null($mat_add_user) || (is_array($mat_add_user) && empty($mat_add_user))) {
            unset($this->mat_add_user);
        } else {
            $this->mat_add_user = $mat_add_user;
        }
        
        return $this;
    }
    /**
     * Get mat_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_add_date(): ?string
    {
        return $this->mat_add_date ?? null;
    }
    /**
     * Set mat_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_add_date(?string $mat_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_add_date) && !is_string($mat_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_add_date, true), gettype($mat_add_date)), __LINE__);
        }
        if (is_null($mat_add_date) || (is_array($mat_add_date) && empty($mat_add_date))) {
            unset($this->mat_add_date);
        } else {
            $this->mat_add_date = $mat_add_date;
        }
        
        return $this;
    }
    /**
     * Get mat_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_change_user(): ?string
    {
        return $this->mat_change_user ?? null;
    }
    /**
     * Set mat_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_change_user(?string $mat_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_change_user) && !is_string($mat_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_change_user, true), gettype($mat_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($mat_change_user) && mb_strlen((string) $mat_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $mat_change_user)), __LINE__);
        }
        if (is_null($mat_change_user) || (is_array($mat_change_user) && empty($mat_change_user))) {
            unset($this->mat_change_user);
        } else {
            $this->mat_change_user = $mat_change_user;
        }
        
        return $this;
    }
    /**
     * Get mat_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_change_date(): ?string
    {
        return $this->mat_change_date ?? null;
    }
    /**
     * Set mat_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_change_date(?string $mat_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_change_date) && !is_string($mat_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_change_date, true), gettype($mat_change_date)), __LINE__);
        }
        if (is_null($mat_change_date) || (is_array($mat_change_date) && empty($mat_change_date))) {
            unset($this->mat_change_date);
        } else {
            $this->mat_change_date = $mat_change_date;
        }
        
        return $this;
    }
    /**
     * Get mat_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_delete_flag(): ?string
    {
        return $this->mat_delete_flag ?? null;
    }
    /**
     * Set mat_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_delete_flag(?string $mat_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_delete_flag) && !is_string($mat_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_delete_flag, true), gettype($mat_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mat_delete_flag) && $mat_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mat_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mat_delete_flag) && $mat_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mat_delete_flag, true)), __LINE__);
        }
        if (is_null($mat_delete_flag) || (is_array($mat_delete_flag) && empty($mat_delete_flag))) {
            unset($this->mat_delete_flag);
        } else {
            $this->mat_delete_flag = $mat_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get mat_mbr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_mbr_key(): ?string
    {
        return $this->mat_mbr_key ?? null;
    }
    /**
     * Set mat_mbr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_mbr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_mbr_key(?string $mat_mbr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_mbr_key) && !is_string($mat_mbr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_mbr_key, true), gettype($mat_mbr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mat_mbr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mat_mbr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mat_mbr_key, true)), __LINE__);
        }
        if (is_null($mat_mbr_key) || (is_array($mat_mbr_key) && empty($mat_mbr_key))) {
            unset($this->mat_mbr_key);
        } else {
            $this->mat_mbr_key = $mat_mbr_key;
        }
        
        return $this;
    }
    /**
     * Get mat_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_key_ext(): ?string
    {
        return $this->mat_key_ext ?? null;
    }
    /**
     * Set mat_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_key_ext(?string $mat_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_key_ext) && !is_string($mat_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_key_ext, true), gettype($mat_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mat_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mat_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mat_key_ext, true)), __LINE__);
        }
        if (is_null($mat_key_ext) || (is_array($mat_key_ext) && empty($mat_key_ext))) {
            unset($this->mat_key_ext);
        } else {
            $this->mat_key_ext = $mat_key_ext;
        }
        
        return $this;
    }
    /**
     * Get mat_mbr_chp_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_mbr_chp_cst_key(): ?string
    {
        return $this->mat_mbr_chp_cst_key ?? null;
    }
    /**
     * Set mat_mbr_chp_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_mbr_chp_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_mbr_chp_cst_key(?string $mat_mbr_chp_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_mbr_chp_cst_key) && !is_string($mat_mbr_chp_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_mbr_chp_cst_key, true), gettype($mat_mbr_chp_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mat_mbr_chp_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mat_mbr_chp_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mat_mbr_chp_cst_key, true)), __LINE__);
        }
        if (is_null($mat_mbr_chp_cst_key) || (is_array($mat_mbr_chp_cst_key) && empty($mat_mbr_chp_cst_key))) {
            unset($this->mat_mbr_chp_cst_key);
        } else {
            $this->mat_mbr_chp_cst_key = $mat_mbr_chp_cst_key;
        }
        
        return $this;
    }
    /**
     * Get mat_rejoin_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_rejoin_date(): ?string
    {
        return $this->mat_rejoin_date ?? null;
    }
    /**
     * Set mat_rejoin_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_rejoin_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_rejoin_date(?string $mat_rejoin_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_rejoin_date) && !is_string($mat_rejoin_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_rejoin_date, true), gettype($mat_rejoin_date)), __LINE__);
        }
        if (is_null($mat_rejoin_date) || (is_array($mat_rejoin_date) && empty($mat_rejoin_date))) {
            unset($this->mat_rejoin_date);
        } else {
            $this->mat_rejoin_date = $mat_rejoin_date;
        }
        
        return $this;
    }
    /**
     * Get mat_invoice_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_invoice_date(): ?string
    {
        return $this->mat_invoice_date ?? null;
    }
    /**
     * Set mat_invoice_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_invoice_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_invoice_date(?string $mat_invoice_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_invoice_date) && !is_string($mat_invoice_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_invoice_date, true), gettype($mat_invoice_date)), __LINE__);
        }
        if (is_null($mat_invoice_date) || (is_array($mat_invoice_date) && empty($mat_invoice_date))) {
            unset($this->mat_invoice_date);
        } else {
            $this->mat_invoice_date = $mat_invoice_date;
        }
        
        return $this;
    }
    /**
     * Get mat_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_entity_key(): ?string
    {
        return $this->mat_entity_key ?? null;
    }
    /**
     * Set mat_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_entity_key(?string $mat_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_entity_key) && !is_string($mat_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_entity_key, true), gettype($mat_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mat_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mat_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mat_entity_key, true)), __LINE__);
        }
        if (is_null($mat_entity_key) || (is_array($mat_entity_key) && empty($mat_entity_key))) {
            unset($this->mat_entity_key);
        } else {
            $this->mat_entity_key = $mat_entity_key;
        }
        
        return $this;
    }
    /**
     * Get mat_terminate_reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_terminate_reason(): ?string
    {
        return $this->mat_terminate_reason ?? null;
    }
    /**
     * Set mat_terminate_reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_terminate_reason
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_terminate_reason(?string $mat_terminate_reason = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_terminate_reason) && !is_string($mat_terminate_reason)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_terminate_reason, true), gettype($mat_terminate_reason)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($mat_terminate_reason) && mb_strlen((string) $mat_terminate_reason) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $mat_terminate_reason)), __LINE__);
        }
        if (is_null($mat_terminate_reason) || (is_array($mat_terminate_reason) && empty($mat_terminate_reason))) {
            unset($this->mat_terminate_reason);
        } else {
            $this->mat_terminate_reason = $mat_terminate_reason;
        }
        
        return $this;
    }
    /**
     * Get mat_mtr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMat_mtr_key(): ?string
    {
        return $this->mat_mtr_key ?? null;
    }
    /**
     * Set mat_mtr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mat_mtr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Audit_Trail_DataObjectType
     */
    public function setMat_mtr_key(?string $mat_mtr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mat_mtr_key) && !is_string($mat_mtr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mat_mtr_key, true), gettype($mat_mtr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mat_mtr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mat_mtr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mat_mtr_key, true)), __LINE__);
        }
        if (is_null($mat_mtr_key) || (is_array($mat_mtr_key) && empty($mat_mtr_key))) {
            unset($this->mat_mtr_key);
        } else {
            $this->mat_mtr_key = $mat_mtr_key;
        }
        
        return $this;
    }
}
