<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mb_membership_Membership_Invoices_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Mb_membership_Membership_Invoices_DataObjectType extends AbstractStructBase
{
    /**
     * The mxi_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mxi_key = null;
    /**
     * The mxi_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mxi_add_user = null;
    /**
     * The mxi_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mxi_add_date = null;
    /**
     * The mxi_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mxi_change_user = null;
    /**
     * The mxi_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mxi_change_date = null;
    /**
     * The mxi_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mxi_delete_flag = null;
    /**
     * The mxi_mbr_key
     * Meta information extracted from the WSDL
     * - documentation: Membership Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mxi_mbr_key = null;
    /**
     * The mxi_inv_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mxi_inv_key = null;
    /**
     * The mxi_pak_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Package Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mxi_pak_prd_key = null;
    /**
     * The mxi_renew_year
     * Meta information extracted from the WSDL
     * - documentation: renew year. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 5
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mxi_renew_year = null;
    /**
     * The mxi_membership_updated
     * Meta information extracted from the WSDL
     * - documentation: membership updated. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mxi_membership_updated = null;
    /**
     * The mxi_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Key for Dues Pr. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mxi_ivd_key = null;
    /**
     * The mxi_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mxi_entity_key = null;
    /**
     * The mxi_ivd_key_previous
     * Meta information extracted from the WSDL
     * - documentation: Previous Invoice Detail Key fo. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mxi_ivd_key_previous = null;
    /**
     * The mxi_rejoin_flag
     * Meta information extracted from the WSDL
     * - documentation: Rejoin Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mxi_rejoin_flag = null;
    /**
     * The mxi_term_start_date
     * Meta information extracted from the WSDL
     * - documentation: Term Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mxi_term_start_date = null;
    /**
     * The mxi_term_end_date
     * Meta information extracted from the WSDL
     * - documentation: Term End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mxi_term_end_date = null;
    /**
     * The mxi_previous_term_start_date
     * Meta information extracted from the WSDL
     * - documentation: Previous Term Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mxi_previous_term_start_date = null;
    /**
     * The mxi_previous_term_end_date
     * Meta information extracted from the WSDL
     * - documentation: Previous Term End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mxi_previous_term_end_date = null;
    /**
     * The mxi_ord_key
     * Meta information extracted from the WSDL
     * - documentation: order key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mxi_ord_key = null;
    /**
     * The mxi_odd_key
     * Meta information extracted from the WSDL
     * - documentation: Order Detail Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mxi_odd_key = null;
    /**
     * The mxi_bun_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Bundle Product. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mxi_bun_prd_key = null;
    /**
     * The mxi_prc_key
     * Meta information extracted from the WSDL
     * - documentation: Dues Rate. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mxi_prc_key = null;
    /**
     * The mxi_mxi_key
     * Meta information extracted from the WSDL
     * - documentation: National Membership MXI. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mxi_mxi_key = null;
    /**
     * The mxi_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mxi_key_ext = null;
    /**
     * The mxi_current_price
     * Meta information extracted from the WSDL
     * - documentation: Current Product Price.This element has a default value of '0'. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined
     * simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $mxi_current_price = null;
    /**
     * The mxi_current_product_key
     * Meta information extracted from the WSDL
     * - documentation: Current Product Key. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mxi_current_product_key = null;
    /**
     * Constructor method for mb_membership_Membership_Invoices_DataObjectType
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_key()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_add_user()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_add_date()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_change_user()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_change_date()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_delete_flag()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_mbr_key()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_inv_key()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_pak_prd_key()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_renew_year()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_membership_updated()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_ivd_key()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_entity_key()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_ivd_key_previous()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_rejoin_flag()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_term_start_date()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_term_end_date()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_previous_term_start_date()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_previous_term_end_date()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_ord_key()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_odd_key()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_bun_prd_key()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_prc_key()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_mxi_key()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_key_ext()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_current_price()
     * @uses Mb_membership_Membership_Invoices_DataObjectType::setMxi_current_product_key()
     * @param string $mxi_key
     * @param string $mxi_add_user
     * @param string $mxi_add_date
     * @param string $mxi_change_user
     * @param string $mxi_change_date
     * @param string $mxi_delete_flag
     * @param string $mxi_mbr_key
     * @param string $mxi_inv_key
     * @param string $mxi_pak_prd_key
     * @param string $mxi_renew_year
     * @param string $mxi_membership_updated
     * @param string $mxi_ivd_key
     * @param string $mxi_entity_key
     * @param string $mxi_ivd_key_previous
     * @param string $mxi_rejoin_flag
     * @param string $mxi_term_start_date
     * @param string $mxi_term_end_date
     * @param string $mxi_previous_term_start_date
     * @param string $mxi_previous_term_end_date
     * @param string $mxi_ord_key
     * @param string $mxi_odd_key
     * @param string $mxi_bun_prd_key
     * @param string $mxi_prc_key
     * @param string $mxi_mxi_key
     * @param string $mxi_key_ext
     * @param float $mxi_current_price
     * @param string $mxi_current_product_key
     */
    public function __construct(?string $mxi_key = null, ?string $mxi_add_user = null, ?string $mxi_add_date = null, ?string $mxi_change_user = null, ?string $mxi_change_date = null, ?string $mxi_delete_flag = null, ?string $mxi_mbr_key = null, ?string $mxi_inv_key = null, ?string $mxi_pak_prd_key = null, ?string $mxi_renew_year = null, ?string $mxi_membership_updated = null, ?string $mxi_ivd_key = null, ?string $mxi_entity_key = null, ?string $mxi_ivd_key_previous = null, ?string $mxi_rejoin_flag = null, ?string $mxi_term_start_date = null, ?string $mxi_term_end_date = null, ?string $mxi_previous_term_start_date = null, ?string $mxi_previous_term_end_date = null, ?string $mxi_ord_key = null, ?string $mxi_odd_key = null, ?string $mxi_bun_prd_key = null, ?string $mxi_prc_key = null, ?string $mxi_mxi_key = null, ?string $mxi_key_ext = null, ?float $mxi_current_price = null, ?string $mxi_current_product_key = null)
    {
        $this
            ->setMxi_key($mxi_key)
            ->setMxi_add_user($mxi_add_user)
            ->setMxi_add_date($mxi_add_date)
            ->setMxi_change_user($mxi_change_user)
            ->setMxi_change_date($mxi_change_date)
            ->setMxi_delete_flag($mxi_delete_flag)
            ->setMxi_mbr_key($mxi_mbr_key)
            ->setMxi_inv_key($mxi_inv_key)
            ->setMxi_pak_prd_key($mxi_pak_prd_key)
            ->setMxi_renew_year($mxi_renew_year)
            ->setMxi_membership_updated($mxi_membership_updated)
            ->setMxi_ivd_key($mxi_ivd_key)
            ->setMxi_entity_key($mxi_entity_key)
            ->setMxi_ivd_key_previous($mxi_ivd_key_previous)
            ->setMxi_rejoin_flag($mxi_rejoin_flag)
            ->setMxi_term_start_date($mxi_term_start_date)
            ->setMxi_term_end_date($mxi_term_end_date)
            ->setMxi_previous_term_start_date($mxi_previous_term_start_date)
            ->setMxi_previous_term_end_date($mxi_previous_term_end_date)
            ->setMxi_ord_key($mxi_ord_key)
            ->setMxi_odd_key($mxi_odd_key)
            ->setMxi_bun_prd_key($mxi_bun_prd_key)
            ->setMxi_prc_key($mxi_prc_key)
            ->setMxi_mxi_key($mxi_mxi_key)
            ->setMxi_key_ext($mxi_key_ext)
            ->setMxi_current_price($mxi_current_price)
            ->setMxi_current_product_key($mxi_current_product_key);
    }
    /**
     * Get mxi_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_key(): ?string
    {
        return $this->mxi_key ?? null;
    }
    /**
     * Set mxi_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_key(?string $mxi_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_key) && !is_string($mxi_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_key, true), gettype($mxi_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mxi_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mxi_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mxi_key, true)), __LINE__);
        }
        if (is_null($mxi_key) || (is_array($mxi_key) && empty($mxi_key))) {
            unset($this->mxi_key);
        } else {
            $this->mxi_key = $mxi_key;
        }
        
        return $this;
    }
    /**
     * Get mxi_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_add_user(): ?string
    {
        return $this->mxi_add_user ?? null;
    }
    /**
     * Set mxi_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_add_user(?string $mxi_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_add_user) && !is_string($mxi_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_add_user, true), gettype($mxi_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($mxi_add_user) && mb_strlen((string) $mxi_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $mxi_add_user)), __LINE__);
        }
        if (is_null($mxi_add_user) || (is_array($mxi_add_user) && empty($mxi_add_user))) {
            unset($this->mxi_add_user);
        } else {
            $this->mxi_add_user = $mxi_add_user;
        }
        
        return $this;
    }
    /**
     * Get mxi_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_add_date(): ?string
    {
        return $this->mxi_add_date ?? null;
    }
    /**
     * Set mxi_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_add_date(?string $mxi_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_add_date) && !is_string($mxi_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_add_date, true), gettype($mxi_add_date)), __LINE__);
        }
        if (is_null($mxi_add_date) || (is_array($mxi_add_date) && empty($mxi_add_date))) {
            unset($this->mxi_add_date);
        } else {
            $this->mxi_add_date = $mxi_add_date;
        }
        
        return $this;
    }
    /**
     * Get mxi_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_change_user(): ?string
    {
        return $this->mxi_change_user ?? null;
    }
    /**
     * Set mxi_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_change_user(?string $mxi_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_change_user) && !is_string($mxi_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_change_user, true), gettype($mxi_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($mxi_change_user) && mb_strlen((string) $mxi_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $mxi_change_user)), __LINE__);
        }
        if (is_null($mxi_change_user) || (is_array($mxi_change_user) && empty($mxi_change_user))) {
            unset($this->mxi_change_user);
        } else {
            $this->mxi_change_user = $mxi_change_user;
        }
        
        return $this;
    }
    /**
     * Get mxi_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_change_date(): ?string
    {
        return $this->mxi_change_date ?? null;
    }
    /**
     * Set mxi_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_change_date(?string $mxi_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_change_date) && !is_string($mxi_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_change_date, true), gettype($mxi_change_date)), __LINE__);
        }
        if (is_null($mxi_change_date) || (is_array($mxi_change_date) && empty($mxi_change_date))) {
            unset($this->mxi_change_date);
        } else {
            $this->mxi_change_date = $mxi_change_date;
        }
        
        return $this;
    }
    /**
     * Get mxi_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_delete_flag(): ?string
    {
        return $this->mxi_delete_flag ?? null;
    }
    /**
     * Set mxi_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_delete_flag(?string $mxi_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_delete_flag) && !is_string($mxi_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_delete_flag, true), gettype($mxi_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mxi_delete_flag) && $mxi_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mxi_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mxi_delete_flag) && $mxi_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mxi_delete_flag, true)), __LINE__);
        }
        if (is_null($mxi_delete_flag) || (is_array($mxi_delete_flag) && empty($mxi_delete_flag))) {
            unset($this->mxi_delete_flag);
        } else {
            $this->mxi_delete_flag = $mxi_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get mxi_mbr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_mbr_key(): ?string
    {
        return $this->mxi_mbr_key ?? null;
    }
    /**
     * Set mxi_mbr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_mbr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_mbr_key(?string $mxi_mbr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_mbr_key) && !is_string($mxi_mbr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_mbr_key, true), gettype($mxi_mbr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mxi_mbr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mxi_mbr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mxi_mbr_key, true)), __LINE__);
        }
        if (is_null($mxi_mbr_key) || (is_array($mxi_mbr_key) && empty($mxi_mbr_key))) {
            unset($this->mxi_mbr_key);
        } else {
            $this->mxi_mbr_key = $mxi_mbr_key;
        }
        
        return $this;
    }
    /**
     * Get mxi_inv_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_inv_key(): ?string
    {
        return $this->mxi_inv_key ?? null;
    }
    /**
     * Set mxi_inv_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_inv_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_inv_key(?string $mxi_inv_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_inv_key) && !is_string($mxi_inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_inv_key, true), gettype($mxi_inv_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mxi_inv_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mxi_inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mxi_inv_key, true)), __LINE__);
        }
        if (is_null($mxi_inv_key) || (is_array($mxi_inv_key) && empty($mxi_inv_key))) {
            unset($this->mxi_inv_key);
        } else {
            $this->mxi_inv_key = $mxi_inv_key;
        }
        
        return $this;
    }
    /**
     * Get mxi_pak_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_pak_prd_key(): ?string
    {
        return $this->mxi_pak_prd_key ?? null;
    }
    /**
     * Set mxi_pak_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_pak_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_pak_prd_key(?string $mxi_pak_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_pak_prd_key) && !is_string($mxi_pak_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_pak_prd_key, true), gettype($mxi_pak_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mxi_pak_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mxi_pak_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mxi_pak_prd_key, true)), __LINE__);
        }
        if (is_null($mxi_pak_prd_key) || (is_array($mxi_pak_prd_key) && empty($mxi_pak_prd_key))) {
            unset($this->mxi_pak_prd_key);
        } else {
            $this->mxi_pak_prd_key = $mxi_pak_prd_key;
        }
        
        return $this;
    }
    /**
     * Get mxi_renew_year value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_renew_year(): ?string
    {
        return $this->mxi_renew_year ?? null;
    }
    /**
     * Set mxi_renew_year value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_renew_year
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_renew_year(?string $mxi_renew_year = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_renew_year) && !is_string($mxi_renew_year)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_renew_year, true), gettype($mxi_renew_year)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($mxi_renew_year) && mb_strlen((string) $mxi_renew_year) > 5) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen((string) $mxi_renew_year)), __LINE__);
        }
        if (is_null($mxi_renew_year) || (is_array($mxi_renew_year) && empty($mxi_renew_year))) {
            unset($this->mxi_renew_year);
        } else {
            $this->mxi_renew_year = $mxi_renew_year;
        }
        
        return $this;
    }
    /**
     * Get mxi_membership_updated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_membership_updated(): ?string
    {
        return $this->mxi_membership_updated ?? null;
    }
    /**
     * Set mxi_membership_updated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_membership_updated
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_membership_updated(?string $mxi_membership_updated = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_membership_updated) && !is_string($mxi_membership_updated)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_membership_updated, true), gettype($mxi_membership_updated)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mxi_membership_updated) && $mxi_membership_updated > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mxi_membership_updated, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mxi_membership_updated) && $mxi_membership_updated < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mxi_membership_updated, true)), __LINE__);
        }
        if (is_null($mxi_membership_updated) || (is_array($mxi_membership_updated) && empty($mxi_membership_updated))) {
            unset($this->mxi_membership_updated);
        } else {
            $this->mxi_membership_updated = $mxi_membership_updated;
        }
        
        return $this;
    }
    /**
     * Get mxi_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_ivd_key(): ?string
    {
        return $this->mxi_ivd_key ?? null;
    }
    /**
     * Set mxi_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_ivd_key(?string $mxi_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_ivd_key) && !is_string($mxi_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_ivd_key, true), gettype($mxi_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mxi_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mxi_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mxi_ivd_key, true)), __LINE__);
        }
        if (is_null($mxi_ivd_key) || (is_array($mxi_ivd_key) && empty($mxi_ivd_key))) {
            unset($this->mxi_ivd_key);
        } else {
            $this->mxi_ivd_key = $mxi_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get mxi_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_entity_key(): ?string
    {
        return $this->mxi_entity_key ?? null;
    }
    /**
     * Set mxi_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_entity_key(?string $mxi_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_entity_key) && !is_string($mxi_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_entity_key, true), gettype($mxi_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mxi_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mxi_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mxi_entity_key, true)), __LINE__);
        }
        if (is_null($mxi_entity_key) || (is_array($mxi_entity_key) && empty($mxi_entity_key))) {
            unset($this->mxi_entity_key);
        } else {
            $this->mxi_entity_key = $mxi_entity_key;
        }
        
        return $this;
    }
    /**
     * Get mxi_ivd_key_previous value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_ivd_key_previous(): ?string
    {
        return $this->mxi_ivd_key_previous ?? null;
    }
    /**
     * Set mxi_ivd_key_previous value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_ivd_key_previous
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_ivd_key_previous(?string $mxi_ivd_key_previous = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_ivd_key_previous) && !is_string($mxi_ivd_key_previous)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_ivd_key_previous, true), gettype($mxi_ivd_key_previous)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mxi_ivd_key_previous) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mxi_ivd_key_previous)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mxi_ivd_key_previous, true)), __LINE__);
        }
        if (is_null($mxi_ivd_key_previous) || (is_array($mxi_ivd_key_previous) && empty($mxi_ivd_key_previous))) {
            unset($this->mxi_ivd_key_previous);
        } else {
            $this->mxi_ivd_key_previous = $mxi_ivd_key_previous;
        }
        
        return $this;
    }
    /**
     * Get mxi_rejoin_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_rejoin_flag(): ?string
    {
        return $this->mxi_rejoin_flag ?? null;
    }
    /**
     * Set mxi_rejoin_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_rejoin_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_rejoin_flag(?string $mxi_rejoin_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_rejoin_flag) && !is_string($mxi_rejoin_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_rejoin_flag, true), gettype($mxi_rejoin_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mxi_rejoin_flag) && $mxi_rejoin_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mxi_rejoin_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mxi_rejoin_flag) && $mxi_rejoin_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mxi_rejoin_flag, true)), __LINE__);
        }
        if (is_null($mxi_rejoin_flag) || (is_array($mxi_rejoin_flag) && empty($mxi_rejoin_flag))) {
            unset($this->mxi_rejoin_flag);
        } else {
            $this->mxi_rejoin_flag = $mxi_rejoin_flag;
        }
        
        return $this;
    }
    /**
     * Get mxi_term_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_term_start_date(): ?string
    {
        return $this->mxi_term_start_date ?? null;
    }
    /**
     * Set mxi_term_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_term_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_term_start_date(?string $mxi_term_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_term_start_date) && !is_string($mxi_term_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_term_start_date, true), gettype($mxi_term_start_date)), __LINE__);
        }
        if (is_null($mxi_term_start_date) || (is_array($mxi_term_start_date) && empty($mxi_term_start_date))) {
            unset($this->mxi_term_start_date);
        } else {
            $this->mxi_term_start_date = $mxi_term_start_date;
        }
        
        return $this;
    }
    /**
     * Get mxi_term_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_term_end_date(): ?string
    {
        return $this->mxi_term_end_date ?? null;
    }
    /**
     * Set mxi_term_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_term_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_term_end_date(?string $mxi_term_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_term_end_date) && !is_string($mxi_term_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_term_end_date, true), gettype($mxi_term_end_date)), __LINE__);
        }
        if (is_null($mxi_term_end_date) || (is_array($mxi_term_end_date) && empty($mxi_term_end_date))) {
            unset($this->mxi_term_end_date);
        } else {
            $this->mxi_term_end_date = $mxi_term_end_date;
        }
        
        return $this;
    }
    /**
     * Get mxi_previous_term_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_previous_term_start_date(): ?string
    {
        return $this->mxi_previous_term_start_date ?? null;
    }
    /**
     * Set mxi_previous_term_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_previous_term_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_previous_term_start_date(?string $mxi_previous_term_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_previous_term_start_date) && !is_string($mxi_previous_term_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_previous_term_start_date, true), gettype($mxi_previous_term_start_date)), __LINE__);
        }
        if (is_null($mxi_previous_term_start_date) || (is_array($mxi_previous_term_start_date) && empty($mxi_previous_term_start_date))) {
            unset($this->mxi_previous_term_start_date);
        } else {
            $this->mxi_previous_term_start_date = $mxi_previous_term_start_date;
        }
        
        return $this;
    }
    /**
     * Get mxi_previous_term_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_previous_term_end_date(): ?string
    {
        return $this->mxi_previous_term_end_date ?? null;
    }
    /**
     * Set mxi_previous_term_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_previous_term_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_previous_term_end_date(?string $mxi_previous_term_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_previous_term_end_date) && !is_string($mxi_previous_term_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_previous_term_end_date, true), gettype($mxi_previous_term_end_date)), __LINE__);
        }
        if (is_null($mxi_previous_term_end_date) || (is_array($mxi_previous_term_end_date) && empty($mxi_previous_term_end_date))) {
            unset($this->mxi_previous_term_end_date);
        } else {
            $this->mxi_previous_term_end_date = $mxi_previous_term_end_date;
        }
        
        return $this;
    }
    /**
     * Get mxi_ord_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_ord_key(): ?string
    {
        return $this->mxi_ord_key ?? null;
    }
    /**
     * Set mxi_ord_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_ord_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_ord_key(?string $mxi_ord_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_ord_key) && !is_string($mxi_ord_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_ord_key, true), gettype($mxi_ord_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mxi_ord_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mxi_ord_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mxi_ord_key, true)), __LINE__);
        }
        if (is_null($mxi_ord_key) || (is_array($mxi_ord_key) && empty($mxi_ord_key))) {
            unset($this->mxi_ord_key);
        } else {
            $this->mxi_ord_key = $mxi_ord_key;
        }
        
        return $this;
    }
    /**
     * Get mxi_odd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_odd_key(): ?string
    {
        return $this->mxi_odd_key ?? null;
    }
    /**
     * Set mxi_odd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_odd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_odd_key(?string $mxi_odd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_odd_key) && !is_string($mxi_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_odd_key, true), gettype($mxi_odd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mxi_odd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mxi_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mxi_odd_key, true)), __LINE__);
        }
        if (is_null($mxi_odd_key) || (is_array($mxi_odd_key) && empty($mxi_odd_key))) {
            unset($this->mxi_odd_key);
        } else {
            $this->mxi_odd_key = $mxi_odd_key;
        }
        
        return $this;
    }
    /**
     * Get mxi_bun_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_bun_prd_key(): ?string
    {
        return $this->mxi_bun_prd_key ?? null;
    }
    /**
     * Set mxi_bun_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_bun_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_bun_prd_key(?string $mxi_bun_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_bun_prd_key) && !is_string($mxi_bun_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_bun_prd_key, true), gettype($mxi_bun_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mxi_bun_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mxi_bun_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mxi_bun_prd_key, true)), __LINE__);
        }
        if (is_null($mxi_bun_prd_key) || (is_array($mxi_bun_prd_key) && empty($mxi_bun_prd_key))) {
            unset($this->mxi_bun_prd_key);
        } else {
            $this->mxi_bun_prd_key = $mxi_bun_prd_key;
        }
        
        return $this;
    }
    /**
     * Get mxi_prc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_prc_key(): ?string
    {
        return $this->mxi_prc_key ?? null;
    }
    /**
     * Set mxi_prc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_prc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_prc_key(?string $mxi_prc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_prc_key) && !is_string($mxi_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_prc_key, true), gettype($mxi_prc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mxi_prc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mxi_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mxi_prc_key, true)), __LINE__);
        }
        if (is_null($mxi_prc_key) || (is_array($mxi_prc_key) && empty($mxi_prc_key))) {
            unset($this->mxi_prc_key);
        } else {
            $this->mxi_prc_key = $mxi_prc_key;
        }
        
        return $this;
    }
    /**
     * Get mxi_mxi_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_mxi_key(): ?string
    {
        return $this->mxi_mxi_key ?? null;
    }
    /**
     * Set mxi_mxi_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_mxi_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_mxi_key(?string $mxi_mxi_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_mxi_key) && !is_string($mxi_mxi_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_mxi_key, true), gettype($mxi_mxi_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mxi_mxi_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mxi_mxi_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mxi_mxi_key, true)), __LINE__);
        }
        if (is_null($mxi_mxi_key) || (is_array($mxi_mxi_key) && empty($mxi_mxi_key))) {
            unset($this->mxi_mxi_key);
        } else {
            $this->mxi_mxi_key = $mxi_mxi_key;
        }
        
        return $this;
    }
    /**
     * Get mxi_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_key_ext(): ?string
    {
        return $this->mxi_key_ext ?? null;
    }
    /**
     * Set mxi_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_key_ext(?string $mxi_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_key_ext) && !is_string($mxi_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_key_ext, true), gettype($mxi_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mxi_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mxi_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mxi_key_ext, true)), __LINE__);
        }
        if (is_null($mxi_key_ext) || (is_array($mxi_key_ext) && empty($mxi_key_ext))) {
            unset($this->mxi_key_ext);
        } else {
            $this->mxi_key_ext = $mxi_key_ext;
        }
        
        return $this;
    }
    /**
     * Get mxi_current_price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMxi_current_price(): ?float
    {
        return $this->mxi_current_price ?? null;
    }
    /**
     * Set mxi_current_price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $mxi_current_price
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_current_price(?float $mxi_current_price = null): self
    {
        // validation for constraint: float
        if (!is_null($mxi_current_price) && !(is_float($mxi_current_price) || is_numeric($mxi_current_price))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($mxi_current_price, true), gettype($mxi_current_price)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($mxi_current_price) && mb_strlen(mb_substr((string) $mxi_current_price, false !== mb_strpos((string) $mxi_current_price, '.') ? mb_strpos((string) $mxi_current_price, '.') + 1 : mb_strlen((string) $mxi_current_price))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($mxi_current_price, true), mb_strlen(mb_substr((string) $mxi_current_price, mb_strpos((string) $mxi_current_price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($mxi_current_price) && mb_strlen(preg_replace('/(\D)/', '', (string) $mxi_current_price)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($mxi_current_price, true), mb_strlen(preg_replace('/(\D)/', '', (string) $mxi_current_price))), __LINE__);
        }
        if (is_null($mxi_current_price) || (is_array($mxi_current_price) && empty($mxi_current_price))) {
            unset($this->mxi_current_price);
        } else {
            $this->mxi_current_price = $mxi_current_price;
        }
        
        return $this;
    }
    /**
     * Get mxi_current_product_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMxi_current_product_key(): ?string
    {
        return $this->mxi_current_product_key ?? null;
    }
    /**
     * Set mxi_current_product_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mxi_current_product_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_Invoices_DataObjectType
     */
    public function setMxi_current_product_key(?string $mxi_current_product_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mxi_current_product_key) && !is_string($mxi_current_product_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxi_current_product_key, true), gettype($mxi_current_product_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mxi_current_product_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mxi_current_product_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mxi_current_product_key, true)), __LINE__);
        }
        if (is_null($mxi_current_product_key) || (is_array($mxi_current_product_key) && empty($mxi_current_product_key))) {
            unset($this->mxi_current_product_key);
        } else {
            $this->mxi_current_product_key = $mxi_current_product_key;
        }
        
        return $this;
    }
}
