<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mb_membership_Organization_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Mb_membership_Organization_DataObjectType extends AbstractStructBase
{
    /**
     * The org_consortia_flag
     * Meta information extracted from the WSDL
     * - documentation: Consortia Flag.This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $org_consortia_flag = null;
    /**
     * The org_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Organization Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $org_cst_key = null;
    /**
     * The org_name
     * Meta information extracted from the WSDL
     * - documentation: Organization Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $org_name = null;
    /**
     * The org_ogt_code
     * Meta information extracted from the WSDL
     * - documentation: Organization Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $org_ogt_code = null;
    /**
     * The org_cst_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $org_cst_key_ext = null;
    /**
     * The org_acronym
     * Meta information extracted from the WSDL
     * - documentation: Acronym. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $org_acronym = null;
    /**
     * The org_ind_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Contact. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $org_ind_cst_key = null;
    /**
     * The org_num_employee
     * Meta information extracted from the WSDL
     * - documentation: number of employees. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $org_num_employee = null;
    /**
     * The org_annual_sales
     * Meta information extracted from the WSDL
     * - documentation: annual sales volume. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $org_annual_sales = null;
    /**
     * The org_annual_revenue
     * Meta information extracted from the WSDL
     * - documentation: annual revenue. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $org_annual_revenue = null;
    /**
     * The org_dnb_number
     * Meta information extracted from the WSDL
     * - documentation: d&amp;b number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $org_dnb_number = null;
    /**
     * The org_date_founded
     * Meta information extracted from the WSDL
     * - documentation: date founded. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 24
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $org_date_founded = null;
    /**
     * The org_num_years_in_business_cp
     * Meta information extracted from the WSDL
     * - documentation: Years in Business. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $org_num_years_in_business_cp = null;
    /**
     * The org_state_incorporated
     * Meta information extracted from the WSDL
     * - documentation: state incorporated. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $org_state_incorporated = null;
    /**
     * The org_num_location
     * Meta information extracted from the WSDL
     * - documentation: number of locations. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $org_num_location = null;
    /**
     * The org_annual_budget
     * Meta information extracted from the WSDL
     * - documentation: annual budget. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $org_annual_budget = null;
    /**
     * The org_ownership_type
     * Meta information extracted from the WSDL
     * - documentation: type of ownership. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $org_ownership_type = null;
    /**
     * The org_popup
     * Meta information extracted from the WSDL
     * - documentation: Popup. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $org_popup = null;
    /**
     * The org_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $org_add_date = null;
    /**
     * The org_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $org_entity_key = null;
    /**
     * The org_nonprofit_flag
     * Meta information extracted from the WSDL
     * - documentation: Non-profit Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $org_nonprofit_flag = null;
    /**
     * The org_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $org_add_user = null;
    /**
     * The org_org_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Org Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $org_org_cst_key = null;
    /**
     * The org_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $org_change_date = null;
    /**
     * The org_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $org_change_user = null;
    /**
     * The org_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $org_delete_flag = null;
    /**
     * Constructor method for mb_membership_Organization_DataObjectType
     * @uses Mb_membership_Organization_DataObjectType::setOrg_consortia_flag()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_cst_key()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_name()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_ogt_code()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_cst_key_ext()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_acronym()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_ind_cst_key()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_num_employee()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_annual_sales()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_annual_revenue()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_dnb_number()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_date_founded()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_num_years_in_business_cp()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_state_incorporated()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_num_location()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_annual_budget()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_ownership_type()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_popup()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_add_date()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_entity_key()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_nonprofit_flag()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_add_user()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_org_cst_key()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_change_date()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_change_user()
     * @uses Mb_membership_Organization_DataObjectType::setOrg_delete_flag()
     * @param string $org_consortia_flag
     * @param string $org_cst_key
     * @param string $org_name
     * @param string $org_ogt_code
     * @param string $org_cst_key_ext
     * @param string $org_acronym
     * @param string $org_ind_cst_key
     * @param int $org_num_employee
     * @param float $org_annual_sales
     * @param float $org_annual_revenue
     * @param string $org_dnb_number
     * @param string $org_date_founded
     * @param int $org_num_years_in_business_cp
     * @param string $org_state_incorporated
     * @param int $org_num_location
     * @param float $org_annual_budget
     * @param string $org_ownership_type
     * @param string $org_popup
     * @param string $org_add_date
     * @param string $org_entity_key
     * @param string $org_nonprofit_flag
     * @param string $org_add_user
     * @param string $org_org_cst_key
     * @param string $org_change_date
     * @param string $org_change_user
     * @param string $org_delete_flag
     */
    public function __construct(?string $org_consortia_flag = null, ?string $org_cst_key = null, ?string $org_name = null, ?string $org_ogt_code = null, ?string $org_cst_key_ext = null, ?string $org_acronym = null, ?string $org_ind_cst_key = null, ?int $org_num_employee = null, ?float $org_annual_sales = null, ?float $org_annual_revenue = null, ?string $org_dnb_number = null, ?string $org_date_founded = null, ?int $org_num_years_in_business_cp = null, ?string $org_state_incorporated = null, ?int $org_num_location = null, ?float $org_annual_budget = null, ?string $org_ownership_type = null, ?string $org_popup = null, ?string $org_add_date = null, ?string $org_entity_key = null, ?string $org_nonprofit_flag = null, ?string $org_add_user = null, ?string $org_org_cst_key = null, ?string $org_change_date = null, ?string $org_change_user = null, ?string $org_delete_flag = null)
    {
        $this
            ->setOrg_consortia_flag($org_consortia_flag)
            ->setOrg_cst_key($org_cst_key)
            ->setOrg_name($org_name)
            ->setOrg_ogt_code($org_ogt_code)
            ->setOrg_cst_key_ext($org_cst_key_ext)
            ->setOrg_acronym($org_acronym)
            ->setOrg_ind_cst_key($org_ind_cst_key)
            ->setOrg_num_employee($org_num_employee)
            ->setOrg_annual_sales($org_annual_sales)
            ->setOrg_annual_revenue($org_annual_revenue)
            ->setOrg_dnb_number($org_dnb_number)
            ->setOrg_date_founded($org_date_founded)
            ->setOrg_num_years_in_business_cp($org_num_years_in_business_cp)
            ->setOrg_state_incorporated($org_state_incorporated)
            ->setOrg_num_location($org_num_location)
            ->setOrg_annual_budget($org_annual_budget)
            ->setOrg_ownership_type($org_ownership_type)
            ->setOrg_popup($org_popup)
            ->setOrg_add_date($org_add_date)
            ->setOrg_entity_key($org_entity_key)
            ->setOrg_nonprofit_flag($org_nonprofit_flag)
            ->setOrg_add_user($org_add_user)
            ->setOrg_org_cst_key($org_org_cst_key)
            ->setOrg_change_date($org_change_date)
            ->setOrg_change_user($org_change_user)
            ->setOrg_delete_flag($org_delete_flag);
    }
    /**
     * Get org_consortia_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrg_consortia_flag(): ?string
    {
        return $this->org_consortia_flag ?? null;
    }
    /**
     * Set org_consortia_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $org_consortia_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_consortia_flag(?string $org_consortia_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($org_consortia_flag) && !is_string($org_consortia_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($org_consortia_flag, true), gettype($org_consortia_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($org_consortia_flag) && $org_consortia_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($org_consortia_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($org_consortia_flag) && $org_consortia_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($org_consortia_flag, true)), __LINE__);
        }
        if (is_null($org_consortia_flag) || (is_array($org_consortia_flag) && empty($org_consortia_flag))) {
            unset($this->org_consortia_flag);
        } else {
            $this->org_consortia_flag = $org_consortia_flag;
        }
        
        return $this;
    }
    /**
     * Get org_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrg_cst_key(): ?string
    {
        return $this->org_cst_key ?? null;
    }
    /**
     * Set org_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $org_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_cst_key(?string $org_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($org_cst_key) && !is_string($org_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($org_cst_key, true), gettype($org_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($org_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $org_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($org_cst_key, true)), __LINE__);
        }
        if (is_null($org_cst_key) || (is_array($org_cst_key) && empty($org_cst_key))) {
            unset($this->org_cst_key);
        } else {
            $this->org_cst_key = $org_cst_key;
        }
        
        return $this;
    }
    /**
     * Get org_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrg_name(): ?string
    {
        return $this->org_name ?? null;
    }
    /**
     * Set org_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $org_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_name(?string $org_name = null): self
    {
        // validation for constraint: string
        if (!is_null($org_name) && !is_string($org_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($org_name, true), gettype($org_name)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($org_name) && mb_strlen((string) $org_name) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $org_name)), __LINE__);
        }
        if (is_null($org_name) || (is_array($org_name) && empty($org_name))) {
            unset($this->org_name);
        } else {
            $this->org_name = $org_name;
        }
        
        return $this;
    }
    /**
     * Get org_ogt_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrg_ogt_code(): ?string
    {
        return $this->org_ogt_code ?? null;
    }
    /**
     * Set org_ogt_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $org_ogt_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_ogt_code(?string $org_ogt_code = null): self
    {
        // validation for constraint: string
        if (!is_null($org_ogt_code) && !is_string($org_ogt_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($org_ogt_code, true), gettype($org_ogt_code)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($org_ogt_code) && mb_strlen((string) $org_ogt_code) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $org_ogt_code)), __LINE__);
        }
        if (is_null($org_ogt_code) || (is_array($org_ogt_code) && empty($org_ogt_code))) {
            unset($this->org_ogt_code);
        } else {
            $this->org_ogt_code = $org_ogt_code;
        }
        
        return $this;
    }
    /**
     * Get org_cst_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrg_cst_key_ext(): ?string
    {
        return $this->org_cst_key_ext ?? null;
    }
    /**
     * Set org_cst_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $org_cst_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_cst_key_ext(?string $org_cst_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($org_cst_key_ext) && !is_string($org_cst_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($org_cst_key_ext, true), gettype($org_cst_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($org_cst_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $org_cst_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($org_cst_key_ext, true)), __LINE__);
        }
        if (is_null($org_cst_key_ext) || (is_array($org_cst_key_ext) && empty($org_cst_key_ext))) {
            unset($this->org_cst_key_ext);
        } else {
            $this->org_cst_key_ext = $org_cst_key_ext;
        }
        
        return $this;
    }
    /**
     * Get org_acronym value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrg_acronym(): ?string
    {
        return $this->org_acronym ?? null;
    }
    /**
     * Set org_acronym value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $org_acronym
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_acronym(?string $org_acronym = null): self
    {
        // validation for constraint: string
        if (!is_null($org_acronym) && !is_string($org_acronym)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($org_acronym, true), gettype($org_acronym)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($org_acronym) && mb_strlen((string) $org_acronym) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $org_acronym)), __LINE__);
        }
        if (is_null($org_acronym) || (is_array($org_acronym) && empty($org_acronym))) {
            unset($this->org_acronym);
        } else {
            $this->org_acronym = $org_acronym;
        }
        
        return $this;
    }
    /**
     * Get org_ind_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrg_ind_cst_key(): ?string
    {
        return $this->org_ind_cst_key ?? null;
    }
    /**
     * Set org_ind_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $org_ind_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_ind_cst_key(?string $org_ind_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($org_ind_cst_key) && !is_string($org_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($org_ind_cst_key, true), gettype($org_ind_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($org_ind_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $org_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($org_ind_cst_key, true)), __LINE__);
        }
        if (is_null($org_ind_cst_key) || (is_array($org_ind_cst_key) && empty($org_ind_cst_key))) {
            unset($this->org_ind_cst_key);
        } else {
            $this->org_ind_cst_key = $org_ind_cst_key;
        }
        
        return $this;
    }
    /**
     * Get org_num_employee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrg_num_employee(): ?int
    {
        return $this->org_num_employee ?? null;
    }
    /**
     * Set org_num_employee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $org_num_employee
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_num_employee(?int $org_num_employee = null): self
    {
        // validation for constraint: int
        if (!is_null($org_num_employee) && !(is_int($org_num_employee) || ctype_digit($org_num_employee))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($org_num_employee, true), gettype($org_num_employee)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($org_num_employee) && $org_num_employee > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($org_num_employee, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($org_num_employee) && $org_num_employee < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($org_num_employee, true)), __LINE__);
        }
        if (is_null($org_num_employee) || (is_array($org_num_employee) && empty($org_num_employee))) {
            unset($this->org_num_employee);
        } else {
            $this->org_num_employee = $org_num_employee;
        }
        
        return $this;
    }
    /**
     * Get org_annual_sales value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOrg_annual_sales(): ?float
    {
        return $this->org_annual_sales ?? null;
    }
    /**
     * Set org_annual_sales value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $org_annual_sales
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_annual_sales(?float $org_annual_sales = null): self
    {
        // validation for constraint: float
        if (!is_null($org_annual_sales) && !(is_float($org_annual_sales) || is_numeric($org_annual_sales))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($org_annual_sales, true), gettype($org_annual_sales)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($org_annual_sales) && mb_strlen(mb_substr((string) $org_annual_sales, false !== mb_strpos((string) $org_annual_sales, '.') ? mb_strpos((string) $org_annual_sales, '.') + 1 : mb_strlen((string) $org_annual_sales))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($org_annual_sales, true), mb_strlen(mb_substr((string) $org_annual_sales, mb_strpos((string) $org_annual_sales, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($org_annual_sales) && mb_strlen(preg_replace('/(\D)/', '', (string) $org_annual_sales)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($org_annual_sales, true), mb_strlen(preg_replace('/(\D)/', '', (string) $org_annual_sales))), __LINE__);
        }
        if (is_null($org_annual_sales) || (is_array($org_annual_sales) && empty($org_annual_sales))) {
            unset($this->org_annual_sales);
        } else {
            $this->org_annual_sales = $org_annual_sales;
        }
        
        return $this;
    }
    /**
     * Get org_annual_revenue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOrg_annual_revenue(): ?float
    {
        return $this->org_annual_revenue ?? null;
    }
    /**
     * Set org_annual_revenue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $org_annual_revenue
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_annual_revenue(?float $org_annual_revenue = null): self
    {
        // validation for constraint: float
        if (!is_null($org_annual_revenue) && !(is_float($org_annual_revenue) || is_numeric($org_annual_revenue))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($org_annual_revenue, true), gettype($org_annual_revenue)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($org_annual_revenue) && mb_strlen(mb_substr((string) $org_annual_revenue, false !== mb_strpos((string) $org_annual_revenue, '.') ? mb_strpos((string) $org_annual_revenue, '.') + 1 : mb_strlen((string) $org_annual_revenue))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($org_annual_revenue, true), mb_strlen(mb_substr((string) $org_annual_revenue, mb_strpos((string) $org_annual_revenue, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($org_annual_revenue) && mb_strlen(preg_replace('/(\D)/', '', (string) $org_annual_revenue)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($org_annual_revenue, true), mb_strlen(preg_replace('/(\D)/', '', (string) $org_annual_revenue))), __LINE__);
        }
        if (is_null($org_annual_revenue) || (is_array($org_annual_revenue) && empty($org_annual_revenue))) {
            unset($this->org_annual_revenue);
        } else {
            $this->org_annual_revenue = $org_annual_revenue;
        }
        
        return $this;
    }
    /**
     * Get org_dnb_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrg_dnb_number(): ?string
    {
        return $this->org_dnb_number ?? null;
    }
    /**
     * Set org_dnb_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $org_dnb_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_dnb_number(?string $org_dnb_number = null): self
    {
        // validation for constraint: string
        if (!is_null($org_dnb_number) && !is_string($org_dnb_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($org_dnb_number, true), gettype($org_dnb_number)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($org_dnb_number) && mb_strlen((string) $org_dnb_number) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $org_dnb_number)), __LINE__);
        }
        if (is_null($org_dnb_number) || (is_array($org_dnb_number) && empty($org_dnb_number))) {
            unset($this->org_dnb_number);
        } else {
            $this->org_dnb_number = $org_dnb_number;
        }
        
        return $this;
    }
    /**
     * Get org_date_founded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrg_date_founded(): ?string
    {
        return $this->org_date_founded ?? null;
    }
    /**
     * Set org_date_founded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $org_date_founded
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_date_founded(?string $org_date_founded = null): self
    {
        // validation for constraint: string
        if (!is_null($org_date_founded) && !is_string($org_date_founded)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($org_date_founded, true), gettype($org_date_founded)), __LINE__);
        }
        // validation for constraint: maxLength(24)
        if (!is_null($org_date_founded) && mb_strlen((string) $org_date_founded) > 24) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 24', mb_strlen((string) $org_date_founded)), __LINE__);
        }
        if (is_null($org_date_founded) || (is_array($org_date_founded) && empty($org_date_founded))) {
            unset($this->org_date_founded);
        } else {
            $this->org_date_founded = $org_date_founded;
        }
        
        return $this;
    }
    /**
     * Get org_num_years_in_business_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrg_num_years_in_business_cp(): ?int
    {
        return $this->org_num_years_in_business_cp ?? null;
    }
    /**
     * Set org_num_years_in_business_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $org_num_years_in_business_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_num_years_in_business_cp(?int $org_num_years_in_business_cp = null): self
    {
        // validation for constraint: int
        if (!is_null($org_num_years_in_business_cp) && !(is_int($org_num_years_in_business_cp) || ctype_digit($org_num_years_in_business_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($org_num_years_in_business_cp, true), gettype($org_num_years_in_business_cp)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($org_num_years_in_business_cp) && $org_num_years_in_business_cp > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($org_num_years_in_business_cp, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($org_num_years_in_business_cp) && $org_num_years_in_business_cp < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($org_num_years_in_business_cp, true)), __LINE__);
        }
        if (is_null($org_num_years_in_business_cp) || (is_array($org_num_years_in_business_cp) && empty($org_num_years_in_business_cp))) {
            unset($this->org_num_years_in_business_cp);
        } else {
            $this->org_num_years_in_business_cp = $org_num_years_in_business_cp;
        }
        
        return $this;
    }
    /**
     * Get org_state_incorporated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrg_state_incorporated(): ?string
    {
        return $this->org_state_incorporated ?? null;
    }
    /**
     * Set org_state_incorporated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $org_state_incorporated
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_state_incorporated(?string $org_state_incorporated = null): self
    {
        // validation for constraint: string
        if (!is_null($org_state_incorporated) && !is_string($org_state_incorporated)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($org_state_incorporated, true), gettype($org_state_incorporated)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($org_state_incorporated) && mb_strlen((string) $org_state_incorporated) > 2) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen((string) $org_state_incorporated)), __LINE__);
        }
        if (is_null($org_state_incorporated) || (is_array($org_state_incorporated) && empty($org_state_incorporated))) {
            unset($this->org_state_incorporated);
        } else {
            $this->org_state_incorporated = $org_state_incorporated;
        }
        
        return $this;
    }
    /**
     * Get org_num_location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrg_num_location(): ?int
    {
        return $this->org_num_location ?? null;
    }
    /**
     * Set org_num_location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $org_num_location
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_num_location(?int $org_num_location = null): self
    {
        // validation for constraint: int
        if (!is_null($org_num_location) && !(is_int($org_num_location) || ctype_digit($org_num_location))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($org_num_location, true), gettype($org_num_location)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($org_num_location) && $org_num_location > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($org_num_location, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($org_num_location) && $org_num_location < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($org_num_location, true)), __LINE__);
        }
        if (is_null($org_num_location) || (is_array($org_num_location) && empty($org_num_location))) {
            unset($this->org_num_location);
        } else {
            $this->org_num_location = $org_num_location;
        }
        
        return $this;
    }
    /**
     * Get org_annual_budget value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOrg_annual_budget(): ?float
    {
        return $this->org_annual_budget ?? null;
    }
    /**
     * Set org_annual_budget value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $org_annual_budget
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_annual_budget(?float $org_annual_budget = null): self
    {
        // validation for constraint: float
        if (!is_null($org_annual_budget) && !(is_float($org_annual_budget) || is_numeric($org_annual_budget))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($org_annual_budget, true), gettype($org_annual_budget)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($org_annual_budget) && mb_strlen(mb_substr((string) $org_annual_budget, false !== mb_strpos((string) $org_annual_budget, '.') ? mb_strpos((string) $org_annual_budget, '.') + 1 : mb_strlen((string) $org_annual_budget))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($org_annual_budget, true), mb_strlen(mb_substr((string) $org_annual_budget, mb_strpos((string) $org_annual_budget, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($org_annual_budget) && mb_strlen(preg_replace('/(\D)/', '', (string) $org_annual_budget)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($org_annual_budget, true), mb_strlen(preg_replace('/(\D)/', '', (string) $org_annual_budget))), __LINE__);
        }
        if (is_null($org_annual_budget) || (is_array($org_annual_budget) && empty($org_annual_budget))) {
            unset($this->org_annual_budget);
        } else {
            $this->org_annual_budget = $org_annual_budget;
        }
        
        return $this;
    }
    /**
     * Get org_ownership_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrg_ownership_type(): ?string
    {
        return $this->org_ownership_type ?? null;
    }
    /**
     * Set org_ownership_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $org_ownership_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_ownership_type(?string $org_ownership_type = null): self
    {
        // validation for constraint: string
        if (!is_null($org_ownership_type) && !is_string($org_ownership_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($org_ownership_type, true), gettype($org_ownership_type)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($org_ownership_type) && mb_strlen((string) $org_ownership_type) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen((string) $org_ownership_type)), __LINE__);
        }
        if (is_null($org_ownership_type) || (is_array($org_ownership_type) && empty($org_ownership_type))) {
            unset($this->org_ownership_type);
        } else {
            $this->org_ownership_type = $org_ownership_type;
        }
        
        return $this;
    }
    /**
     * Get org_popup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrg_popup(): ?string
    {
        return $this->org_popup ?? null;
    }
    /**
     * Set org_popup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $org_popup
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_popup(?string $org_popup = null): self
    {
        // validation for constraint: string
        if (!is_null($org_popup) && !is_string($org_popup)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($org_popup, true), gettype($org_popup)), __LINE__);
        }
        if (is_null($org_popup) || (is_array($org_popup) && empty($org_popup))) {
            unset($this->org_popup);
        } else {
            $this->org_popup = $org_popup;
        }
        
        return $this;
    }
    /**
     * Get org_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrg_add_date(): ?string
    {
        return $this->org_add_date ?? null;
    }
    /**
     * Set org_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $org_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_add_date(?string $org_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($org_add_date) && !is_string($org_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($org_add_date, true), gettype($org_add_date)), __LINE__);
        }
        if (is_null($org_add_date) || (is_array($org_add_date) && empty($org_add_date))) {
            unset($this->org_add_date);
        } else {
            $this->org_add_date = $org_add_date;
        }
        
        return $this;
    }
    /**
     * Get org_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrg_entity_key(): ?string
    {
        return $this->org_entity_key ?? null;
    }
    /**
     * Set org_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $org_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_entity_key(?string $org_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($org_entity_key) && !is_string($org_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($org_entity_key, true), gettype($org_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($org_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $org_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($org_entity_key, true)), __LINE__);
        }
        if (is_null($org_entity_key) || (is_array($org_entity_key) && empty($org_entity_key))) {
            unset($this->org_entity_key);
        } else {
            $this->org_entity_key = $org_entity_key;
        }
        
        return $this;
    }
    /**
     * Get org_nonprofit_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrg_nonprofit_flag(): ?string
    {
        return $this->org_nonprofit_flag ?? null;
    }
    /**
     * Set org_nonprofit_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $org_nonprofit_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_nonprofit_flag(?string $org_nonprofit_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($org_nonprofit_flag) && !is_string($org_nonprofit_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($org_nonprofit_flag, true), gettype($org_nonprofit_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($org_nonprofit_flag) && $org_nonprofit_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($org_nonprofit_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($org_nonprofit_flag) && $org_nonprofit_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($org_nonprofit_flag, true)), __LINE__);
        }
        if (is_null($org_nonprofit_flag) || (is_array($org_nonprofit_flag) && empty($org_nonprofit_flag))) {
            unset($this->org_nonprofit_flag);
        } else {
            $this->org_nonprofit_flag = $org_nonprofit_flag;
        }
        
        return $this;
    }
    /**
     * Get org_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrg_add_user(): ?string
    {
        return $this->org_add_user ?? null;
    }
    /**
     * Set org_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $org_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_add_user(?string $org_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($org_add_user) && !is_string($org_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($org_add_user, true), gettype($org_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($org_add_user) && mb_strlen((string) $org_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $org_add_user)), __LINE__);
        }
        if (is_null($org_add_user) || (is_array($org_add_user) && empty($org_add_user))) {
            unset($this->org_add_user);
        } else {
            $this->org_add_user = $org_add_user;
        }
        
        return $this;
    }
    /**
     * Get org_org_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrg_org_cst_key(): ?string
    {
        return $this->org_org_cst_key ?? null;
    }
    /**
     * Set org_org_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $org_org_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_org_cst_key(?string $org_org_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($org_org_cst_key) && !is_string($org_org_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($org_org_cst_key, true), gettype($org_org_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($org_org_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $org_org_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($org_org_cst_key, true)), __LINE__);
        }
        if (is_null($org_org_cst_key) || (is_array($org_org_cst_key) && empty($org_org_cst_key))) {
            unset($this->org_org_cst_key);
        } else {
            $this->org_org_cst_key = $org_org_cst_key;
        }
        
        return $this;
    }
    /**
     * Get org_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrg_change_date(): ?string
    {
        return $this->org_change_date ?? null;
    }
    /**
     * Set org_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $org_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_change_date(?string $org_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($org_change_date) && !is_string($org_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($org_change_date, true), gettype($org_change_date)), __LINE__);
        }
        if (is_null($org_change_date) || (is_array($org_change_date) && empty($org_change_date))) {
            unset($this->org_change_date);
        } else {
            $this->org_change_date = $org_change_date;
        }
        
        return $this;
    }
    /**
     * Get org_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrg_change_user(): ?string
    {
        return $this->org_change_user ?? null;
    }
    /**
     * Set org_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $org_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_change_user(?string $org_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($org_change_user) && !is_string($org_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($org_change_user, true), gettype($org_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($org_change_user) && mb_strlen((string) $org_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $org_change_user)), __LINE__);
        }
        if (is_null($org_change_user) || (is_array($org_change_user) && empty($org_change_user))) {
            unset($this->org_change_user);
        } else {
            $this->org_change_user = $org_change_user;
        }
        
        return $this;
    }
    /**
     * Get org_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrg_delete_flag(): ?string
    {
        return $this->org_delete_flag ?? null;
    }
    /**
     * Set org_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $org_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Organization_DataObjectType
     */
    public function setOrg_delete_flag(?string $org_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($org_delete_flag) && !is_string($org_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($org_delete_flag, true), gettype($org_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($org_delete_flag) && $org_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($org_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($org_delete_flag) && $org_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($org_delete_flag, true)), __LINE__);
        }
        if (is_null($org_delete_flag) || (is_array($org_delete_flag) && empty($org_delete_flag))) {
            unset($this->org_delete_flag);
        } else {
            $this->org_delete_flag = $org_delete_flag;
        }
        
        return $this;
    }
}
