<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mb_membership_Package_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Mb_membership_Package_DataObjectType extends AbstractStructBase
{
    /**
     * The pak_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Package. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pak_prd_key = null;
    /**
     * The pak_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pak_add_user = null;
    /**
     * The pak_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pak_add_date = null;
    /**
     * The pak_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pak_change_user = null;
    /**
     * The pak_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pak_change_date = null;
    /**
     * The pak_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pak_delete_flag = null;
    /**
     * The pak_prd_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pak_prd_key_ext = null;
    /**
     * The pak_dues_flag
     * Meta information extracted from the WSDL
     * - documentation: Dues Package Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pak_dues_flag = null;
    /**
     * The pak_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pak_entity_key = null;
    /**
     * The pak_sell_online_flag
     * Meta information extracted from the WSDL
     * - documentation: Sell Online. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pak_sell_online_flag = null;
    /**
     * The pak_post_online_date
     * Meta information extracted from the WSDL
     * - documentation: Post To WEB After Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pak_post_online_date = null;
    /**
     * The pak_remove_online_date
     * Meta information extracted from the WSDL
     * - documentation: Remove From WEB After Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pak_remove_online_date = null;
    /**
     * The pak_allow_installment
     * Meta information extracted from the WSDL
     * - documentation: allow installment. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pak_allow_installment = null;
    /**
     * The pak_has_optional_components
     * Meta information extracted from the WSDL
     * - documentation: has optional components. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pak_has_optional_components = null;
    /**
     * The pak_optional_item_count
     * Meta information extracted from the WSDL
     * - documentation: optional item count. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $pak_optional_item_count = null;
    /**
     * The pak_prd_renewal_key
     * Meta information extracted from the WSDL
     * - documentation: Renewal Package. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pak_prd_renewal_key = null;
    /**
     * The pak_events_flag
     * Meta information extracted from the WSDL
     * - documentation: Events Package Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pak_events_flag = null;
    /**
     * The pak_hide_components_flag
     * Meta information extracted from the WSDL
     * - documentation: Hide Package Components on eWeb. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pak_hide_components_flag = null;
    /**
     * The pak_collective_dues_flag
     * Meta information extracted from the WSDL
     * - documentation: Collective Dues Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pak_collective_dues_flag = null;
    /**
     * Constructor method for mb_membership_Package_DataObjectType
     * @uses Mb_membership_Package_DataObjectType::setPak_prd_key()
     * @uses Mb_membership_Package_DataObjectType::setPak_add_user()
     * @uses Mb_membership_Package_DataObjectType::setPak_add_date()
     * @uses Mb_membership_Package_DataObjectType::setPak_change_user()
     * @uses Mb_membership_Package_DataObjectType::setPak_change_date()
     * @uses Mb_membership_Package_DataObjectType::setPak_delete_flag()
     * @uses Mb_membership_Package_DataObjectType::setPak_prd_key_ext()
     * @uses Mb_membership_Package_DataObjectType::setPak_dues_flag()
     * @uses Mb_membership_Package_DataObjectType::setPak_entity_key()
     * @uses Mb_membership_Package_DataObjectType::setPak_sell_online_flag()
     * @uses Mb_membership_Package_DataObjectType::setPak_post_online_date()
     * @uses Mb_membership_Package_DataObjectType::setPak_remove_online_date()
     * @uses Mb_membership_Package_DataObjectType::setPak_allow_installment()
     * @uses Mb_membership_Package_DataObjectType::setPak_has_optional_components()
     * @uses Mb_membership_Package_DataObjectType::setPak_optional_item_count()
     * @uses Mb_membership_Package_DataObjectType::setPak_prd_renewal_key()
     * @uses Mb_membership_Package_DataObjectType::setPak_events_flag()
     * @uses Mb_membership_Package_DataObjectType::setPak_hide_components_flag()
     * @uses Mb_membership_Package_DataObjectType::setPak_collective_dues_flag()
     * @param string $pak_prd_key
     * @param string $pak_add_user
     * @param string $pak_add_date
     * @param string $pak_change_user
     * @param string $pak_change_date
     * @param string $pak_delete_flag
     * @param string $pak_prd_key_ext
     * @param string $pak_dues_flag
     * @param string $pak_entity_key
     * @param string $pak_sell_online_flag
     * @param string $pak_post_online_date
     * @param string $pak_remove_online_date
     * @param string $pak_allow_installment
     * @param string $pak_has_optional_components
     * @param int $pak_optional_item_count
     * @param string $pak_prd_renewal_key
     * @param string $pak_events_flag
     * @param string $pak_hide_components_flag
     * @param string $pak_collective_dues_flag
     */
    public function __construct(?string $pak_prd_key = null, ?string $pak_add_user = null, ?string $pak_add_date = null, ?string $pak_change_user = null, ?string $pak_change_date = null, ?string $pak_delete_flag = null, ?string $pak_prd_key_ext = null, ?string $pak_dues_flag = null, ?string $pak_entity_key = null, ?string $pak_sell_online_flag = null, ?string $pak_post_online_date = null, ?string $pak_remove_online_date = null, ?string $pak_allow_installment = null, ?string $pak_has_optional_components = null, ?int $pak_optional_item_count = null, ?string $pak_prd_renewal_key = null, ?string $pak_events_flag = null, ?string $pak_hide_components_flag = null, ?string $pak_collective_dues_flag = null)
    {
        $this
            ->setPak_prd_key($pak_prd_key)
            ->setPak_add_user($pak_add_user)
            ->setPak_add_date($pak_add_date)
            ->setPak_change_user($pak_change_user)
            ->setPak_change_date($pak_change_date)
            ->setPak_delete_flag($pak_delete_flag)
            ->setPak_prd_key_ext($pak_prd_key_ext)
            ->setPak_dues_flag($pak_dues_flag)
            ->setPak_entity_key($pak_entity_key)
            ->setPak_sell_online_flag($pak_sell_online_flag)
            ->setPak_post_online_date($pak_post_online_date)
            ->setPak_remove_online_date($pak_remove_online_date)
            ->setPak_allow_installment($pak_allow_installment)
            ->setPak_has_optional_components($pak_has_optional_components)
            ->setPak_optional_item_count($pak_optional_item_count)
            ->setPak_prd_renewal_key($pak_prd_renewal_key)
            ->setPak_events_flag($pak_events_flag)
            ->setPak_hide_components_flag($pak_hide_components_flag)
            ->setPak_collective_dues_flag($pak_collective_dues_flag);
    }
    /**
     * Get pak_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPak_prd_key(): ?string
    {
        return $this->pak_prd_key ?? null;
    }
    /**
     * Set pak_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pak_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType
     */
    public function setPak_prd_key(?string $pak_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pak_prd_key) && !is_string($pak_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pak_prd_key, true), gettype($pak_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pak_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pak_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pak_prd_key, true)), __LINE__);
        }
        if (is_null($pak_prd_key) || (is_array($pak_prd_key) && empty($pak_prd_key))) {
            unset($this->pak_prd_key);
        } else {
            $this->pak_prd_key = $pak_prd_key;
        }
        
        return $this;
    }
    /**
     * Get pak_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPak_add_user(): ?string
    {
        return $this->pak_add_user ?? null;
    }
    /**
     * Set pak_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pak_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType
     */
    public function setPak_add_user(?string $pak_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($pak_add_user) && !is_string($pak_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pak_add_user, true), gettype($pak_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($pak_add_user) && mb_strlen((string) $pak_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $pak_add_user)), __LINE__);
        }
        if (is_null($pak_add_user) || (is_array($pak_add_user) && empty($pak_add_user))) {
            unset($this->pak_add_user);
        } else {
            $this->pak_add_user = $pak_add_user;
        }
        
        return $this;
    }
    /**
     * Get pak_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPak_add_date(): ?string
    {
        return $this->pak_add_date ?? null;
    }
    /**
     * Set pak_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pak_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType
     */
    public function setPak_add_date(?string $pak_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pak_add_date) && !is_string($pak_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pak_add_date, true), gettype($pak_add_date)), __LINE__);
        }
        if (is_null($pak_add_date) || (is_array($pak_add_date) && empty($pak_add_date))) {
            unset($this->pak_add_date);
        } else {
            $this->pak_add_date = $pak_add_date;
        }
        
        return $this;
    }
    /**
     * Get pak_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPak_change_user(): ?string
    {
        return $this->pak_change_user ?? null;
    }
    /**
     * Set pak_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pak_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType
     */
    public function setPak_change_user(?string $pak_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($pak_change_user) && !is_string($pak_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pak_change_user, true), gettype($pak_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($pak_change_user) && mb_strlen((string) $pak_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $pak_change_user)), __LINE__);
        }
        if (is_null($pak_change_user) || (is_array($pak_change_user) && empty($pak_change_user))) {
            unset($this->pak_change_user);
        } else {
            $this->pak_change_user = $pak_change_user;
        }
        
        return $this;
    }
    /**
     * Get pak_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPak_change_date(): ?string
    {
        return $this->pak_change_date ?? null;
    }
    /**
     * Set pak_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pak_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType
     */
    public function setPak_change_date(?string $pak_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pak_change_date) && !is_string($pak_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pak_change_date, true), gettype($pak_change_date)), __LINE__);
        }
        if (is_null($pak_change_date) || (is_array($pak_change_date) && empty($pak_change_date))) {
            unset($this->pak_change_date);
        } else {
            $this->pak_change_date = $pak_change_date;
        }
        
        return $this;
    }
    /**
     * Get pak_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPak_delete_flag(): ?string
    {
        return $this->pak_delete_flag ?? null;
    }
    /**
     * Set pak_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pak_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType
     */
    public function setPak_delete_flag(?string $pak_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pak_delete_flag) && !is_string($pak_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pak_delete_flag, true), gettype($pak_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pak_delete_flag) && $pak_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pak_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pak_delete_flag) && $pak_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pak_delete_flag, true)), __LINE__);
        }
        if (is_null($pak_delete_flag) || (is_array($pak_delete_flag) && empty($pak_delete_flag))) {
            unset($this->pak_delete_flag);
        } else {
            $this->pak_delete_flag = $pak_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get pak_prd_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPak_prd_key_ext(): ?string
    {
        return $this->pak_prd_key_ext ?? null;
    }
    /**
     * Set pak_prd_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pak_prd_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType
     */
    public function setPak_prd_key_ext(?string $pak_prd_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($pak_prd_key_ext) && !is_string($pak_prd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pak_prd_key_ext, true), gettype($pak_prd_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pak_prd_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pak_prd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pak_prd_key_ext, true)), __LINE__);
        }
        if (is_null($pak_prd_key_ext) || (is_array($pak_prd_key_ext) && empty($pak_prd_key_ext))) {
            unset($this->pak_prd_key_ext);
        } else {
            $this->pak_prd_key_ext = $pak_prd_key_ext;
        }
        
        return $this;
    }
    /**
     * Get pak_dues_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPak_dues_flag(): ?string
    {
        return $this->pak_dues_flag ?? null;
    }
    /**
     * Set pak_dues_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pak_dues_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType
     */
    public function setPak_dues_flag(?string $pak_dues_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pak_dues_flag) && !is_string($pak_dues_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pak_dues_flag, true), gettype($pak_dues_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pak_dues_flag) && $pak_dues_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pak_dues_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pak_dues_flag) && $pak_dues_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pak_dues_flag, true)), __LINE__);
        }
        if (is_null($pak_dues_flag) || (is_array($pak_dues_flag) && empty($pak_dues_flag))) {
            unset($this->pak_dues_flag);
        } else {
            $this->pak_dues_flag = $pak_dues_flag;
        }
        
        return $this;
    }
    /**
     * Get pak_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPak_entity_key(): ?string
    {
        return $this->pak_entity_key ?? null;
    }
    /**
     * Set pak_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pak_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType
     */
    public function setPak_entity_key(?string $pak_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pak_entity_key) && !is_string($pak_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pak_entity_key, true), gettype($pak_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pak_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pak_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pak_entity_key, true)), __LINE__);
        }
        if (is_null($pak_entity_key) || (is_array($pak_entity_key) && empty($pak_entity_key))) {
            unset($this->pak_entity_key);
        } else {
            $this->pak_entity_key = $pak_entity_key;
        }
        
        return $this;
    }
    /**
     * Get pak_sell_online_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPak_sell_online_flag(): ?string
    {
        return $this->pak_sell_online_flag ?? null;
    }
    /**
     * Set pak_sell_online_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pak_sell_online_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType
     */
    public function setPak_sell_online_flag(?string $pak_sell_online_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pak_sell_online_flag) && !is_string($pak_sell_online_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pak_sell_online_flag, true), gettype($pak_sell_online_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pak_sell_online_flag) && $pak_sell_online_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pak_sell_online_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pak_sell_online_flag) && $pak_sell_online_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pak_sell_online_flag, true)), __LINE__);
        }
        if (is_null($pak_sell_online_flag) || (is_array($pak_sell_online_flag) && empty($pak_sell_online_flag))) {
            unset($this->pak_sell_online_flag);
        } else {
            $this->pak_sell_online_flag = $pak_sell_online_flag;
        }
        
        return $this;
    }
    /**
     * Get pak_post_online_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPak_post_online_date(): ?string
    {
        return $this->pak_post_online_date ?? null;
    }
    /**
     * Set pak_post_online_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pak_post_online_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType
     */
    public function setPak_post_online_date(?string $pak_post_online_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pak_post_online_date) && !is_string($pak_post_online_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pak_post_online_date, true), gettype($pak_post_online_date)), __LINE__);
        }
        if (is_null($pak_post_online_date) || (is_array($pak_post_online_date) && empty($pak_post_online_date))) {
            unset($this->pak_post_online_date);
        } else {
            $this->pak_post_online_date = $pak_post_online_date;
        }
        
        return $this;
    }
    /**
     * Get pak_remove_online_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPak_remove_online_date(): ?string
    {
        return $this->pak_remove_online_date ?? null;
    }
    /**
     * Set pak_remove_online_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pak_remove_online_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType
     */
    public function setPak_remove_online_date(?string $pak_remove_online_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pak_remove_online_date) && !is_string($pak_remove_online_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pak_remove_online_date, true), gettype($pak_remove_online_date)), __LINE__);
        }
        if (is_null($pak_remove_online_date) || (is_array($pak_remove_online_date) && empty($pak_remove_online_date))) {
            unset($this->pak_remove_online_date);
        } else {
            $this->pak_remove_online_date = $pak_remove_online_date;
        }
        
        return $this;
    }
    /**
     * Get pak_allow_installment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPak_allow_installment(): ?string
    {
        return $this->pak_allow_installment ?? null;
    }
    /**
     * Set pak_allow_installment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pak_allow_installment
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType
     */
    public function setPak_allow_installment(?string $pak_allow_installment = null): self
    {
        // validation for constraint: string
        if (!is_null($pak_allow_installment) && !is_string($pak_allow_installment)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pak_allow_installment, true), gettype($pak_allow_installment)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pak_allow_installment) && $pak_allow_installment > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pak_allow_installment, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pak_allow_installment) && $pak_allow_installment < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pak_allow_installment, true)), __LINE__);
        }
        if (is_null($pak_allow_installment) || (is_array($pak_allow_installment) && empty($pak_allow_installment))) {
            unset($this->pak_allow_installment);
        } else {
            $this->pak_allow_installment = $pak_allow_installment;
        }
        
        return $this;
    }
    /**
     * Get pak_has_optional_components value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPak_has_optional_components(): ?string
    {
        return $this->pak_has_optional_components ?? null;
    }
    /**
     * Set pak_has_optional_components value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pak_has_optional_components
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType
     */
    public function setPak_has_optional_components(?string $pak_has_optional_components = null): self
    {
        // validation for constraint: string
        if (!is_null($pak_has_optional_components) && !is_string($pak_has_optional_components)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pak_has_optional_components, true), gettype($pak_has_optional_components)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pak_has_optional_components) && $pak_has_optional_components > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pak_has_optional_components, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pak_has_optional_components) && $pak_has_optional_components < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pak_has_optional_components, true)), __LINE__);
        }
        if (is_null($pak_has_optional_components) || (is_array($pak_has_optional_components) && empty($pak_has_optional_components))) {
            unset($this->pak_has_optional_components);
        } else {
            $this->pak_has_optional_components = $pak_has_optional_components;
        }
        
        return $this;
    }
    /**
     * Get pak_optional_item_count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPak_optional_item_count(): ?int
    {
        return $this->pak_optional_item_count ?? null;
    }
    /**
     * Set pak_optional_item_count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pak_optional_item_count
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType
     */
    public function setPak_optional_item_count(?int $pak_optional_item_count = null): self
    {
        // validation for constraint: int
        if (!is_null($pak_optional_item_count) && !(is_int($pak_optional_item_count) || ctype_digit($pak_optional_item_count))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pak_optional_item_count, true), gettype($pak_optional_item_count)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($pak_optional_item_count) && $pak_optional_item_count > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($pak_optional_item_count, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($pak_optional_item_count) && $pak_optional_item_count < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($pak_optional_item_count, true)), __LINE__);
        }
        if (is_null($pak_optional_item_count) || (is_array($pak_optional_item_count) && empty($pak_optional_item_count))) {
            unset($this->pak_optional_item_count);
        } else {
            $this->pak_optional_item_count = $pak_optional_item_count;
        }
        
        return $this;
    }
    /**
     * Get pak_prd_renewal_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPak_prd_renewal_key(): ?string
    {
        return $this->pak_prd_renewal_key ?? null;
    }
    /**
     * Set pak_prd_renewal_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pak_prd_renewal_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType
     */
    public function setPak_prd_renewal_key(?string $pak_prd_renewal_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pak_prd_renewal_key) && !is_string($pak_prd_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pak_prd_renewal_key, true), gettype($pak_prd_renewal_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pak_prd_renewal_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pak_prd_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pak_prd_renewal_key, true)), __LINE__);
        }
        if (is_null($pak_prd_renewal_key) || (is_array($pak_prd_renewal_key) && empty($pak_prd_renewal_key))) {
            unset($this->pak_prd_renewal_key);
        } else {
            $this->pak_prd_renewal_key = $pak_prd_renewal_key;
        }
        
        return $this;
    }
    /**
     * Get pak_events_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPak_events_flag(): ?string
    {
        return $this->pak_events_flag ?? null;
    }
    /**
     * Set pak_events_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pak_events_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType
     */
    public function setPak_events_flag(?string $pak_events_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pak_events_flag) && !is_string($pak_events_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pak_events_flag, true), gettype($pak_events_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pak_events_flag) && $pak_events_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pak_events_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pak_events_flag) && $pak_events_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pak_events_flag, true)), __LINE__);
        }
        if (is_null($pak_events_flag) || (is_array($pak_events_flag) && empty($pak_events_flag))) {
            unset($this->pak_events_flag);
        } else {
            $this->pak_events_flag = $pak_events_flag;
        }
        
        return $this;
    }
    /**
     * Get pak_hide_components_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPak_hide_components_flag(): ?string
    {
        return $this->pak_hide_components_flag ?? null;
    }
    /**
     * Set pak_hide_components_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pak_hide_components_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType
     */
    public function setPak_hide_components_flag(?string $pak_hide_components_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pak_hide_components_flag) && !is_string($pak_hide_components_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pak_hide_components_flag, true), gettype($pak_hide_components_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pak_hide_components_flag) && $pak_hide_components_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pak_hide_components_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pak_hide_components_flag) && $pak_hide_components_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pak_hide_components_flag, true)), __LINE__);
        }
        if (is_null($pak_hide_components_flag) || (is_array($pak_hide_components_flag) && empty($pak_hide_components_flag))) {
            unset($this->pak_hide_components_flag);
        } else {
            $this->pak_hide_components_flag = $pak_hide_components_flag;
        }
        
        return $this;
    }
    /**
     * Get pak_collective_dues_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPak_collective_dues_flag(): ?string
    {
        return $this->pak_collective_dues_flag ?? null;
    }
    /**
     * Set pak_collective_dues_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pak_collective_dues_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_DataObjectType
     */
    public function setPak_collective_dues_flag(?string $pak_collective_dues_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pak_collective_dues_flag) && !is_string($pak_collective_dues_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pak_collective_dues_flag, true), gettype($pak_collective_dues_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pak_collective_dues_flag) && $pak_collective_dues_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pak_collective_dues_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pak_collective_dues_flag) && $pak_collective_dues_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pak_collective_dues_flag, true)), __LINE__);
        }
        if (is_null($pak_collective_dues_flag) || (is_array($pak_collective_dues_flag) && empty($pak_collective_dues_flag))) {
            unset($this->pak_collective_dues_flag);
        } else {
            $this->pak_collective_dues_flag = $pak_collective_dues_flag;
        }
        
        return $this;
    }
}
