<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mb_membership_Package_Renewal_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Mb_membership_Package_Renewal_DataObjectType extends AbstractStructBase
{
    /**
     * The pk2__pak_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Package. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pk2__pak_prd_key = null;
    /**
     * The pk2__pak_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pk2__pak_add_user = null;
    /**
     * The pk2__pak_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pk2__pak_add_date = null;
    /**
     * The pk2__pak_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pk2__pak_change_user = null;
    /**
     * The pk2__pak_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pk2__pak_change_date = null;
    /**
     * The pk2__pak_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pk2__pak_delete_flag = null;
    /**
     * The pk2__pak_prd_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pk2__pak_prd_key_ext = null;
    /**
     * The pk2__pak_dues_flag
     * Meta information extracted from the WSDL
     * - documentation: Dues Package Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pk2__pak_dues_flag = null;
    /**
     * The pk2__pak_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pk2__pak_entity_key = null;
    /**
     * The pk2__pak_sell_online_flag
     * Meta information extracted from the WSDL
     * - documentation: Sell Online. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pk2__pak_sell_online_flag = null;
    /**
     * The pk2__pak_post_online_date
     * Meta information extracted from the WSDL
     * - documentation: Post To WEB After Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pk2__pak_post_online_date = null;
    /**
     * The pk2__pak_remove_online_date
     * Meta information extracted from the WSDL
     * - documentation: Remove From WEB After Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pk2__pak_remove_online_date = null;
    /**
     * The pk2__pak_allow_installment
     * Meta information extracted from the WSDL
     * - documentation: allow installment. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pk2__pak_allow_installment = null;
    /**
     * The pk2__pak_has_optional_components
     * Meta information extracted from the WSDL
     * - documentation: has optional components. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pk2__pak_has_optional_components = null;
    /**
     * The pk2__pak_optional_item_count
     * Meta information extracted from the WSDL
     * - documentation: optional item count. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $pk2__pak_optional_item_count = null;
    /**
     * The pk2__pak_prd_renewal_key
     * Meta information extracted from the WSDL
     * - documentation: Renewal Package. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pk2__pak_prd_renewal_key = null;
    /**
     * The pk2__pak_events_flag
     * Meta information extracted from the WSDL
     * - documentation: Events Package Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pk2__pak_events_flag = null;
    /**
     * The pk2__pak_hide_components_flag
     * Meta information extracted from the WSDL
     * - documentation: Hide Package Components on eWeb. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pk2__pak_hide_components_flag = null;
    /**
     * The pk2__pak_collective_dues_flag
     * Meta information extracted from the WSDL
     * - documentation: Collective Dues Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pk2__pak_collective_dues_flag = null;
    /**
     * Constructor method for mb_membership_Package_Renewal_DataObjectType
     * @uses Mb_membership_Package_Renewal_DataObjectType::setPk2__pak_prd_key()
     * @uses Mb_membership_Package_Renewal_DataObjectType::setPk2__pak_add_user()
     * @uses Mb_membership_Package_Renewal_DataObjectType::setPk2__pak_add_date()
     * @uses Mb_membership_Package_Renewal_DataObjectType::setPk2__pak_change_user()
     * @uses Mb_membership_Package_Renewal_DataObjectType::setPk2__pak_change_date()
     * @uses Mb_membership_Package_Renewal_DataObjectType::setPk2__pak_delete_flag()
     * @uses Mb_membership_Package_Renewal_DataObjectType::setPk2__pak_prd_key_ext()
     * @uses Mb_membership_Package_Renewal_DataObjectType::setPk2__pak_dues_flag()
     * @uses Mb_membership_Package_Renewal_DataObjectType::setPk2__pak_entity_key()
     * @uses Mb_membership_Package_Renewal_DataObjectType::setPk2__pak_sell_online_flag()
     * @uses Mb_membership_Package_Renewal_DataObjectType::setPk2__pak_post_online_date()
     * @uses Mb_membership_Package_Renewal_DataObjectType::setPk2__pak_remove_online_date()
     * @uses Mb_membership_Package_Renewal_DataObjectType::setPk2__pak_allow_installment()
     * @uses Mb_membership_Package_Renewal_DataObjectType::setPk2__pak_has_optional_components()
     * @uses Mb_membership_Package_Renewal_DataObjectType::setPk2__pak_optional_item_count()
     * @uses Mb_membership_Package_Renewal_DataObjectType::setPk2__pak_prd_renewal_key()
     * @uses Mb_membership_Package_Renewal_DataObjectType::setPk2__pak_events_flag()
     * @uses Mb_membership_Package_Renewal_DataObjectType::setPk2__pak_hide_components_flag()
     * @uses Mb_membership_Package_Renewal_DataObjectType::setPk2__pak_collective_dues_flag()
     * @param string $pk2__pak_prd_key
     * @param string $pk2__pak_add_user
     * @param string $pk2__pak_add_date
     * @param string $pk2__pak_change_user
     * @param string $pk2__pak_change_date
     * @param string $pk2__pak_delete_flag
     * @param string $pk2__pak_prd_key_ext
     * @param string $pk2__pak_dues_flag
     * @param string $pk2__pak_entity_key
     * @param string $pk2__pak_sell_online_flag
     * @param string $pk2__pak_post_online_date
     * @param string $pk2__pak_remove_online_date
     * @param string $pk2__pak_allow_installment
     * @param string $pk2__pak_has_optional_components
     * @param int $pk2__pak_optional_item_count
     * @param string $pk2__pak_prd_renewal_key
     * @param string $pk2__pak_events_flag
     * @param string $pk2__pak_hide_components_flag
     * @param string $pk2__pak_collective_dues_flag
     */
    public function __construct(?string $pk2__pak_prd_key = null, ?string $pk2__pak_add_user = null, ?string $pk2__pak_add_date = null, ?string $pk2__pak_change_user = null, ?string $pk2__pak_change_date = null, ?string $pk2__pak_delete_flag = null, ?string $pk2__pak_prd_key_ext = null, ?string $pk2__pak_dues_flag = null, ?string $pk2__pak_entity_key = null, ?string $pk2__pak_sell_online_flag = null, ?string $pk2__pak_post_online_date = null, ?string $pk2__pak_remove_online_date = null, ?string $pk2__pak_allow_installment = null, ?string $pk2__pak_has_optional_components = null, ?int $pk2__pak_optional_item_count = null, ?string $pk2__pak_prd_renewal_key = null, ?string $pk2__pak_events_flag = null, ?string $pk2__pak_hide_components_flag = null, ?string $pk2__pak_collective_dues_flag = null)
    {
        $this
            ->setPk2__pak_prd_key($pk2__pak_prd_key)
            ->setPk2__pak_add_user($pk2__pak_add_user)
            ->setPk2__pak_add_date($pk2__pak_add_date)
            ->setPk2__pak_change_user($pk2__pak_change_user)
            ->setPk2__pak_change_date($pk2__pak_change_date)
            ->setPk2__pak_delete_flag($pk2__pak_delete_flag)
            ->setPk2__pak_prd_key_ext($pk2__pak_prd_key_ext)
            ->setPk2__pak_dues_flag($pk2__pak_dues_flag)
            ->setPk2__pak_entity_key($pk2__pak_entity_key)
            ->setPk2__pak_sell_online_flag($pk2__pak_sell_online_flag)
            ->setPk2__pak_post_online_date($pk2__pak_post_online_date)
            ->setPk2__pak_remove_online_date($pk2__pak_remove_online_date)
            ->setPk2__pak_allow_installment($pk2__pak_allow_installment)
            ->setPk2__pak_has_optional_components($pk2__pak_has_optional_components)
            ->setPk2__pak_optional_item_count($pk2__pak_optional_item_count)
            ->setPk2__pak_prd_renewal_key($pk2__pak_prd_renewal_key)
            ->setPk2__pak_events_flag($pk2__pak_events_flag)
            ->setPk2__pak_hide_components_flag($pk2__pak_hide_components_flag)
            ->setPk2__pak_collective_dues_flag($pk2__pak_collective_dues_flag);
    }
    /**
     * Get pk2__pak_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPk2__pak_prd_key(): ?string
    {
        return $this->pk2__pak_prd_key ?? null;
    }
    /**
     * Set pk2__pak_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pk2__pak_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType
     */
    public function setPk2__pak_prd_key(?string $pk2__pak_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pk2__pak_prd_key) && !is_string($pk2__pak_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pk2__pak_prd_key, true), gettype($pk2__pak_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pk2__pak_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pk2__pak_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pk2__pak_prd_key, true)), __LINE__);
        }
        if (is_null($pk2__pak_prd_key) || (is_array($pk2__pak_prd_key) && empty($pk2__pak_prd_key))) {
            unset($this->pk2__pak_prd_key);
        } else {
            $this->pk2__pak_prd_key = $pk2__pak_prd_key;
        }
        
        return $this;
    }
    /**
     * Get pk2__pak_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPk2__pak_add_user(): ?string
    {
        return $this->pk2__pak_add_user ?? null;
    }
    /**
     * Set pk2__pak_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pk2__pak_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType
     */
    public function setPk2__pak_add_user(?string $pk2__pak_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($pk2__pak_add_user) && !is_string($pk2__pak_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pk2__pak_add_user, true), gettype($pk2__pak_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($pk2__pak_add_user) && mb_strlen((string) $pk2__pak_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $pk2__pak_add_user)), __LINE__);
        }
        if (is_null($pk2__pak_add_user) || (is_array($pk2__pak_add_user) && empty($pk2__pak_add_user))) {
            unset($this->pk2__pak_add_user);
        } else {
            $this->pk2__pak_add_user = $pk2__pak_add_user;
        }
        
        return $this;
    }
    /**
     * Get pk2__pak_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPk2__pak_add_date(): ?string
    {
        return $this->pk2__pak_add_date ?? null;
    }
    /**
     * Set pk2__pak_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pk2__pak_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType
     */
    public function setPk2__pak_add_date(?string $pk2__pak_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pk2__pak_add_date) && !is_string($pk2__pak_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pk2__pak_add_date, true), gettype($pk2__pak_add_date)), __LINE__);
        }
        if (is_null($pk2__pak_add_date) || (is_array($pk2__pak_add_date) && empty($pk2__pak_add_date))) {
            unset($this->pk2__pak_add_date);
        } else {
            $this->pk2__pak_add_date = $pk2__pak_add_date;
        }
        
        return $this;
    }
    /**
     * Get pk2__pak_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPk2__pak_change_user(): ?string
    {
        return $this->pk2__pak_change_user ?? null;
    }
    /**
     * Set pk2__pak_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pk2__pak_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType
     */
    public function setPk2__pak_change_user(?string $pk2__pak_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($pk2__pak_change_user) && !is_string($pk2__pak_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pk2__pak_change_user, true), gettype($pk2__pak_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($pk2__pak_change_user) && mb_strlen((string) $pk2__pak_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $pk2__pak_change_user)), __LINE__);
        }
        if (is_null($pk2__pak_change_user) || (is_array($pk2__pak_change_user) && empty($pk2__pak_change_user))) {
            unset($this->pk2__pak_change_user);
        } else {
            $this->pk2__pak_change_user = $pk2__pak_change_user;
        }
        
        return $this;
    }
    /**
     * Get pk2__pak_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPk2__pak_change_date(): ?string
    {
        return $this->pk2__pak_change_date ?? null;
    }
    /**
     * Set pk2__pak_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pk2__pak_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType
     */
    public function setPk2__pak_change_date(?string $pk2__pak_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pk2__pak_change_date) && !is_string($pk2__pak_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pk2__pak_change_date, true), gettype($pk2__pak_change_date)), __LINE__);
        }
        if (is_null($pk2__pak_change_date) || (is_array($pk2__pak_change_date) && empty($pk2__pak_change_date))) {
            unset($this->pk2__pak_change_date);
        } else {
            $this->pk2__pak_change_date = $pk2__pak_change_date;
        }
        
        return $this;
    }
    /**
     * Get pk2__pak_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPk2__pak_delete_flag(): ?string
    {
        return $this->pk2__pak_delete_flag ?? null;
    }
    /**
     * Set pk2__pak_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pk2__pak_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType
     */
    public function setPk2__pak_delete_flag(?string $pk2__pak_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pk2__pak_delete_flag) && !is_string($pk2__pak_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pk2__pak_delete_flag, true), gettype($pk2__pak_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pk2__pak_delete_flag) && $pk2__pak_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pk2__pak_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pk2__pak_delete_flag) && $pk2__pak_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pk2__pak_delete_flag, true)), __LINE__);
        }
        if (is_null($pk2__pak_delete_flag) || (is_array($pk2__pak_delete_flag) && empty($pk2__pak_delete_flag))) {
            unset($this->pk2__pak_delete_flag);
        } else {
            $this->pk2__pak_delete_flag = $pk2__pak_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get pk2__pak_prd_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPk2__pak_prd_key_ext(): ?string
    {
        return $this->pk2__pak_prd_key_ext ?? null;
    }
    /**
     * Set pk2__pak_prd_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pk2__pak_prd_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType
     */
    public function setPk2__pak_prd_key_ext(?string $pk2__pak_prd_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($pk2__pak_prd_key_ext) && !is_string($pk2__pak_prd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pk2__pak_prd_key_ext, true), gettype($pk2__pak_prd_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pk2__pak_prd_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pk2__pak_prd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pk2__pak_prd_key_ext, true)), __LINE__);
        }
        if (is_null($pk2__pak_prd_key_ext) || (is_array($pk2__pak_prd_key_ext) && empty($pk2__pak_prd_key_ext))) {
            unset($this->pk2__pak_prd_key_ext);
        } else {
            $this->pk2__pak_prd_key_ext = $pk2__pak_prd_key_ext;
        }
        
        return $this;
    }
    /**
     * Get pk2__pak_dues_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPk2__pak_dues_flag(): ?string
    {
        return $this->pk2__pak_dues_flag ?? null;
    }
    /**
     * Set pk2__pak_dues_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pk2__pak_dues_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType
     */
    public function setPk2__pak_dues_flag(?string $pk2__pak_dues_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pk2__pak_dues_flag) && !is_string($pk2__pak_dues_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pk2__pak_dues_flag, true), gettype($pk2__pak_dues_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pk2__pak_dues_flag) && $pk2__pak_dues_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pk2__pak_dues_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pk2__pak_dues_flag) && $pk2__pak_dues_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pk2__pak_dues_flag, true)), __LINE__);
        }
        if (is_null($pk2__pak_dues_flag) || (is_array($pk2__pak_dues_flag) && empty($pk2__pak_dues_flag))) {
            unset($this->pk2__pak_dues_flag);
        } else {
            $this->pk2__pak_dues_flag = $pk2__pak_dues_flag;
        }
        
        return $this;
    }
    /**
     * Get pk2__pak_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPk2__pak_entity_key(): ?string
    {
        return $this->pk2__pak_entity_key ?? null;
    }
    /**
     * Set pk2__pak_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pk2__pak_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType
     */
    public function setPk2__pak_entity_key(?string $pk2__pak_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pk2__pak_entity_key) && !is_string($pk2__pak_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pk2__pak_entity_key, true), gettype($pk2__pak_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pk2__pak_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pk2__pak_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pk2__pak_entity_key, true)), __LINE__);
        }
        if (is_null($pk2__pak_entity_key) || (is_array($pk2__pak_entity_key) && empty($pk2__pak_entity_key))) {
            unset($this->pk2__pak_entity_key);
        } else {
            $this->pk2__pak_entity_key = $pk2__pak_entity_key;
        }
        
        return $this;
    }
    /**
     * Get pk2__pak_sell_online_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPk2__pak_sell_online_flag(): ?string
    {
        return $this->pk2__pak_sell_online_flag ?? null;
    }
    /**
     * Set pk2__pak_sell_online_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pk2__pak_sell_online_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType
     */
    public function setPk2__pak_sell_online_flag(?string $pk2__pak_sell_online_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pk2__pak_sell_online_flag) && !is_string($pk2__pak_sell_online_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pk2__pak_sell_online_flag, true), gettype($pk2__pak_sell_online_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pk2__pak_sell_online_flag) && $pk2__pak_sell_online_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pk2__pak_sell_online_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pk2__pak_sell_online_flag) && $pk2__pak_sell_online_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pk2__pak_sell_online_flag, true)), __LINE__);
        }
        if (is_null($pk2__pak_sell_online_flag) || (is_array($pk2__pak_sell_online_flag) && empty($pk2__pak_sell_online_flag))) {
            unset($this->pk2__pak_sell_online_flag);
        } else {
            $this->pk2__pak_sell_online_flag = $pk2__pak_sell_online_flag;
        }
        
        return $this;
    }
    /**
     * Get pk2__pak_post_online_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPk2__pak_post_online_date(): ?string
    {
        return $this->pk2__pak_post_online_date ?? null;
    }
    /**
     * Set pk2__pak_post_online_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pk2__pak_post_online_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType
     */
    public function setPk2__pak_post_online_date(?string $pk2__pak_post_online_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pk2__pak_post_online_date) && !is_string($pk2__pak_post_online_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pk2__pak_post_online_date, true), gettype($pk2__pak_post_online_date)), __LINE__);
        }
        if (is_null($pk2__pak_post_online_date) || (is_array($pk2__pak_post_online_date) && empty($pk2__pak_post_online_date))) {
            unset($this->pk2__pak_post_online_date);
        } else {
            $this->pk2__pak_post_online_date = $pk2__pak_post_online_date;
        }
        
        return $this;
    }
    /**
     * Get pk2__pak_remove_online_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPk2__pak_remove_online_date(): ?string
    {
        return $this->pk2__pak_remove_online_date ?? null;
    }
    /**
     * Set pk2__pak_remove_online_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pk2__pak_remove_online_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType
     */
    public function setPk2__pak_remove_online_date(?string $pk2__pak_remove_online_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pk2__pak_remove_online_date) && !is_string($pk2__pak_remove_online_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pk2__pak_remove_online_date, true), gettype($pk2__pak_remove_online_date)), __LINE__);
        }
        if (is_null($pk2__pak_remove_online_date) || (is_array($pk2__pak_remove_online_date) && empty($pk2__pak_remove_online_date))) {
            unset($this->pk2__pak_remove_online_date);
        } else {
            $this->pk2__pak_remove_online_date = $pk2__pak_remove_online_date;
        }
        
        return $this;
    }
    /**
     * Get pk2__pak_allow_installment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPk2__pak_allow_installment(): ?string
    {
        return $this->pk2__pak_allow_installment ?? null;
    }
    /**
     * Set pk2__pak_allow_installment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pk2__pak_allow_installment
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType
     */
    public function setPk2__pak_allow_installment(?string $pk2__pak_allow_installment = null): self
    {
        // validation for constraint: string
        if (!is_null($pk2__pak_allow_installment) && !is_string($pk2__pak_allow_installment)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pk2__pak_allow_installment, true), gettype($pk2__pak_allow_installment)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pk2__pak_allow_installment) && $pk2__pak_allow_installment > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pk2__pak_allow_installment, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pk2__pak_allow_installment) && $pk2__pak_allow_installment < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pk2__pak_allow_installment, true)), __LINE__);
        }
        if (is_null($pk2__pak_allow_installment) || (is_array($pk2__pak_allow_installment) && empty($pk2__pak_allow_installment))) {
            unset($this->pk2__pak_allow_installment);
        } else {
            $this->pk2__pak_allow_installment = $pk2__pak_allow_installment;
        }
        
        return $this;
    }
    /**
     * Get pk2__pak_has_optional_components value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPk2__pak_has_optional_components(): ?string
    {
        return $this->pk2__pak_has_optional_components ?? null;
    }
    /**
     * Set pk2__pak_has_optional_components value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pk2__pak_has_optional_components
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType
     */
    public function setPk2__pak_has_optional_components(?string $pk2__pak_has_optional_components = null): self
    {
        // validation for constraint: string
        if (!is_null($pk2__pak_has_optional_components) && !is_string($pk2__pak_has_optional_components)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pk2__pak_has_optional_components, true), gettype($pk2__pak_has_optional_components)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pk2__pak_has_optional_components) && $pk2__pak_has_optional_components > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pk2__pak_has_optional_components, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pk2__pak_has_optional_components) && $pk2__pak_has_optional_components < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pk2__pak_has_optional_components, true)), __LINE__);
        }
        if (is_null($pk2__pak_has_optional_components) || (is_array($pk2__pak_has_optional_components) && empty($pk2__pak_has_optional_components))) {
            unset($this->pk2__pak_has_optional_components);
        } else {
            $this->pk2__pak_has_optional_components = $pk2__pak_has_optional_components;
        }
        
        return $this;
    }
    /**
     * Get pk2__pak_optional_item_count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPk2__pak_optional_item_count(): ?int
    {
        return $this->pk2__pak_optional_item_count ?? null;
    }
    /**
     * Set pk2__pak_optional_item_count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pk2__pak_optional_item_count
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType
     */
    public function setPk2__pak_optional_item_count(?int $pk2__pak_optional_item_count = null): self
    {
        // validation for constraint: int
        if (!is_null($pk2__pak_optional_item_count) && !(is_int($pk2__pak_optional_item_count) || ctype_digit($pk2__pak_optional_item_count))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pk2__pak_optional_item_count, true), gettype($pk2__pak_optional_item_count)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($pk2__pak_optional_item_count) && $pk2__pak_optional_item_count > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($pk2__pak_optional_item_count, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($pk2__pak_optional_item_count) && $pk2__pak_optional_item_count < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($pk2__pak_optional_item_count, true)), __LINE__);
        }
        if (is_null($pk2__pak_optional_item_count) || (is_array($pk2__pak_optional_item_count) && empty($pk2__pak_optional_item_count))) {
            unset($this->pk2__pak_optional_item_count);
        } else {
            $this->pk2__pak_optional_item_count = $pk2__pak_optional_item_count;
        }
        
        return $this;
    }
    /**
     * Get pk2__pak_prd_renewal_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPk2__pak_prd_renewal_key(): ?string
    {
        return $this->pk2__pak_prd_renewal_key ?? null;
    }
    /**
     * Set pk2__pak_prd_renewal_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pk2__pak_prd_renewal_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType
     */
    public function setPk2__pak_prd_renewal_key(?string $pk2__pak_prd_renewal_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pk2__pak_prd_renewal_key) && !is_string($pk2__pak_prd_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pk2__pak_prd_renewal_key, true), gettype($pk2__pak_prd_renewal_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pk2__pak_prd_renewal_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pk2__pak_prd_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pk2__pak_prd_renewal_key, true)), __LINE__);
        }
        if (is_null($pk2__pak_prd_renewal_key) || (is_array($pk2__pak_prd_renewal_key) && empty($pk2__pak_prd_renewal_key))) {
            unset($this->pk2__pak_prd_renewal_key);
        } else {
            $this->pk2__pak_prd_renewal_key = $pk2__pak_prd_renewal_key;
        }
        
        return $this;
    }
    /**
     * Get pk2__pak_events_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPk2__pak_events_flag(): ?string
    {
        return $this->pk2__pak_events_flag ?? null;
    }
    /**
     * Set pk2__pak_events_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pk2__pak_events_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType
     */
    public function setPk2__pak_events_flag(?string $pk2__pak_events_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pk2__pak_events_flag) && !is_string($pk2__pak_events_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pk2__pak_events_flag, true), gettype($pk2__pak_events_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pk2__pak_events_flag) && $pk2__pak_events_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pk2__pak_events_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pk2__pak_events_flag) && $pk2__pak_events_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pk2__pak_events_flag, true)), __LINE__);
        }
        if (is_null($pk2__pak_events_flag) || (is_array($pk2__pak_events_flag) && empty($pk2__pak_events_flag))) {
            unset($this->pk2__pak_events_flag);
        } else {
            $this->pk2__pak_events_flag = $pk2__pak_events_flag;
        }
        
        return $this;
    }
    /**
     * Get pk2__pak_hide_components_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPk2__pak_hide_components_flag(): ?string
    {
        return $this->pk2__pak_hide_components_flag ?? null;
    }
    /**
     * Set pk2__pak_hide_components_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pk2__pak_hide_components_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType
     */
    public function setPk2__pak_hide_components_flag(?string $pk2__pak_hide_components_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pk2__pak_hide_components_flag) && !is_string($pk2__pak_hide_components_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pk2__pak_hide_components_flag, true), gettype($pk2__pak_hide_components_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pk2__pak_hide_components_flag) && $pk2__pak_hide_components_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pk2__pak_hide_components_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pk2__pak_hide_components_flag) && $pk2__pak_hide_components_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pk2__pak_hide_components_flag, true)), __LINE__);
        }
        if (is_null($pk2__pak_hide_components_flag) || (is_array($pk2__pak_hide_components_flag) && empty($pk2__pak_hide_components_flag))) {
            unset($this->pk2__pak_hide_components_flag);
        } else {
            $this->pk2__pak_hide_components_flag = $pk2__pak_hide_components_flag;
        }
        
        return $this;
    }
    /**
     * Get pk2__pak_collective_dues_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPk2__pak_collective_dues_flag(): ?string
    {
        return $this->pk2__pak_collective_dues_flag ?? null;
    }
    /**
     * Set pk2__pak_collective_dues_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pk2__pak_collective_dues_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Renewal_DataObjectType
     */
    public function setPk2__pak_collective_dues_flag(?string $pk2__pak_collective_dues_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pk2__pak_collective_dues_flag) && !is_string($pk2__pak_collective_dues_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pk2__pak_collective_dues_flag, true), gettype($pk2__pak_collective_dues_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pk2__pak_collective_dues_flag) && $pk2__pak_collective_dues_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pk2__pak_collective_dues_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pk2__pak_collective_dues_flag) && $pk2__pak_collective_dues_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pk2__pak_collective_dues_flag, true)), __LINE__);
        }
        if (is_null($pk2__pak_collective_dues_flag) || (is_array($pk2__pak_collective_dues_flag) && empty($pk2__pak_collective_dues_flag))) {
            unset($this->pk2__pak_collective_dues_flag);
        } else {
            $this->pk2__pak_collective_dues_flag = $pk2__pak_collective_dues_flag;
        }
        
        return $this;
    }
}
