<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mb_membership_Product_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Mb_membership_Product_DataObjectType extends AbstractStructBase
{
    /**
     * The prd_key
     * Meta information extracted from the WSDL
     * - documentation: Product Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prd_key = null;
    /**
     * The prd_name
     * Meta information extracted from the WSDL
     * - documentation: Product Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_name = null;
    /**
     * The prd_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_add_user = null;
    /**
     * The prd_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_add_date = null;
    /**
     * The prd_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_change_user = null;
    /**
     * The prd_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_change_date = null;
    /**
     * The prd_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_delete_flag = null;
    /**
     * The prd_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prd_key_ext = null;
    /**
     * The prd_description
     * Meta information extracted from the WSDL
     * - documentation: Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_description = null;
    /**
     * The prd_allow_partial_ship_flag
     * Meta information extracted from the WSDL
     * - documentation: Allow Partial Shipments. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_allow_partial_ship_flag = null;
    /**
     * The prd_track_inventory_flag
     * Meta information extracted from the WSDL
     * - documentation: Track Inventory Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_track_inventory_flag = null;
    /**
     * The prd_gla_cogs_key
     * Meta information extracted from the WSDL
     * - documentation: COGS Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prd_gla_cogs_key = null;
    /**
     * The prd_gla_inventory_key
     * Meta information extracted from the WSDL
     * - documentation: Inventory Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prd_gla_inventory_key = null;
    /**
     * The prd_ptp_key
     * Meta information extracted from the WSDL
     * - documentation: Product Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prd_ptp_key = null;
    /**
     * The prd_start_date
     * Meta information extracted from the WSDL
     * - documentation: Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_start_date = null;
    /**
     * The prd_taxable_flag
     * Meta information extracted from the WSDL
     * - documentation: Taxable Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_taxable_flag = null;
    /**
     * The prd_allow_backorder
     * Meta information extracted from the WSDL
     * - documentation: Allow Backorders. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_allow_backorder = null;
    /**
     * The prd_end_date
     * Meta information extracted from the WSDL
     * - documentation: End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_end_date = null;
    /**
     * The prd_atc_key
     * Meta information extracted from the WSDL
     * - documentation: Business Unit.This element has a default value of 'aad02d37-912e-47b0-88fe-ee3b6caf35da'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prd_atc_key = null;
    /**
     * The prd_qty_reorder
     * Meta information extracted from the WSDL
     * - documentation: Quantity on Order. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $prd_qty_reorder = null;
    /**
     * The prd_restock_fee
     * Meta information extracted from the WSDL
     * - documentation: Default Restocking Fee. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $prd_restock_fee = null;
    /**
     * The prd_restock_percent
     * Meta information extracted from the WSDL
     * - documentation: Default Restocking Percent. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $prd_restock_percent = null;
    /**
     * The prd_restock_percent_cp
     * Meta information extracted from the WSDL
     * - documentation: restock percent. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $prd_restock_percent_cp = null;
    /**
     * The prd_mail
     * Meta information extracted from the WSDL
     * - documentation: send via mail. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_mail = null;
    /**
     * The prd_email
     * Meta information extracted from the WSDL
     * - documentation: send via email. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_email = null;
    /**
     * The prd_fax
     * Meta information extracted from the WSDL
     * - documentation: send via fax. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_fax = null;
    /**
     * The prd_sell_online
     * Meta information extracted from the WSDL
     * - documentation: Sell Online?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_sell_online = null;
    /**
     * The prd_online_abstract
     * Meta information extracted from the WSDL
     * - documentation: Online Abstract. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_online_abstract = null;
    /**
     * The prd_code
     * Meta information extracted from the WSDL
     * - documentation: Product Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_code = null;
    /**
     * The prd_short_description
     * Meta information extracted from the WSDL
     * - documentation: Short Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 400
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_short_description = null;
    /**
     * The prd_thumbnail_doc_key
     * Meta information extracted from the WSDL
     * - documentation: Thumbnail. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prd_thumbnail_doc_key = null;
    /**
     * The prd_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prd_entity_key = null;
    /**
     * The prd_web
     * Meta information extracted from the WSDL
     * - documentation: send via web. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_web = null;
    /**
     * The prd_microfiche
     * Meta information extracted from the WSDL
     * - documentation: send via microfiche. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_microfiche = null;
    /**
     * The prd_post_to_web_date
     * Meta information extracted from the WSDL
     * - documentation: post to web date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_post_to_web_date = null;
    /**
     * The prd_remove_from_web_date
     * Meta information extracted from the WSDL
     * - documentation: remove from web date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_remove_from_web_date = null;
    /**
     * The prd_ptc_key
     * Meta information extracted from the WSDL
     * - documentation: Product Category. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prd_ptc_key = null;
    /**
     * The prd_format
     * Meta information extracted from the WSDL
     * - documentation: Product Format. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_format = null;
    /**
     * The prd_download_url
     * Meta information extracted from the WSDL
     * - documentation: Electronic Product Download UR. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_download_url = null;
    /**
     * The prd_show_as_new_until
     * Meta information extracted from the WSDL
     * - documentation: Show as new until. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_show_as_new_until = null;
    /**
     * The prd_pjt_key
     * Meta information extracted from the WSDL
     * - documentation: Project. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prd_pjt_key = null;
    /**
     * The prd_gla_damaged_goods_key
     * Meta information extracted from the WSDL
     * - documentation: Damaged Goods Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prd_gla_damaged_goods_key = null;
    /**
     * The prd_order
     * Meta information extracted from the WSDL
     * - documentation: order. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $prd_order = null;
    /**
     * The prd_download_available_days
     * Meta information extracted from the WSDL
     * - documentation: Days Available. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $prd_download_available_days = null;
    /**
     * The prd_weighted_average_cost
     * Meta information extracted from the WSDL
     * - documentation: Weighted Average Cost. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $prd_weighted_average_cost = null;
    /**
     * The prd_featured_product_flag
     * Meta information extracted from the WSDL
     * - documentation: Featured Product?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_featured_product_flag = null;
    /**
     * The prd_download_available_count
     * Meta information extracted from the WSDL
     * - documentation: Number of Available Downloads. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $prd_download_available_count = null;
    /**
     * The prd_cct_key
     * Meta information extracted from the WSDL
     * - documentation: Correspondence Template. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prd_cct_key = null;
    /**
     * The prd_pts_key
     * Meta information extracted from the WSDL
     * - documentation: Subcategory. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prd_pts_key = null;
    /**
     * The prd_cmo_key
     * Meta information extracted from the WSDL
     * - documentation: Commodity Code Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prd_cmo_key = null;
    /**
     * The prd_out_of_stock_override_message
     * Meta information extracted from the WSDL
     * - documentation: Out of stock override message. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_out_of_stock_override_message = null;
    /**
     * The prd_pst_key
     * Meta information extracted from the WSDL
     * - documentation: Size/Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prd_pst_key = null;
    /**
     * The prd_pcr_key
     * Meta information extracted from the WSDL
     * - documentation: Color. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prd_pcr_key = null;
    /**
     * The prd_display_product_name
     * Meta information extracted from the WSDL
     * - documentation: Display/Search Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prd_display_product_name = null;
    /**
     * The prd_display_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Display/Search Product. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prd_display_prd_key = null;
    /**
     * Constructor method for mb_membership_Product_DataObjectType
     * @uses Mb_membership_Product_DataObjectType::setPrd_key()
     * @uses Mb_membership_Product_DataObjectType::setPrd_name()
     * @uses Mb_membership_Product_DataObjectType::setPrd_add_user()
     * @uses Mb_membership_Product_DataObjectType::setPrd_add_date()
     * @uses Mb_membership_Product_DataObjectType::setPrd_change_user()
     * @uses Mb_membership_Product_DataObjectType::setPrd_change_date()
     * @uses Mb_membership_Product_DataObjectType::setPrd_delete_flag()
     * @uses Mb_membership_Product_DataObjectType::setPrd_key_ext()
     * @uses Mb_membership_Product_DataObjectType::setPrd_description()
     * @uses Mb_membership_Product_DataObjectType::setPrd_allow_partial_ship_flag()
     * @uses Mb_membership_Product_DataObjectType::setPrd_track_inventory_flag()
     * @uses Mb_membership_Product_DataObjectType::setPrd_gla_cogs_key()
     * @uses Mb_membership_Product_DataObjectType::setPrd_gla_inventory_key()
     * @uses Mb_membership_Product_DataObjectType::setPrd_ptp_key()
     * @uses Mb_membership_Product_DataObjectType::setPrd_start_date()
     * @uses Mb_membership_Product_DataObjectType::setPrd_taxable_flag()
     * @uses Mb_membership_Product_DataObjectType::setPrd_allow_backorder()
     * @uses Mb_membership_Product_DataObjectType::setPrd_end_date()
     * @uses Mb_membership_Product_DataObjectType::setPrd_atc_key()
     * @uses Mb_membership_Product_DataObjectType::setPrd_qty_reorder()
     * @uses Mb_membership_Product_DataObjectType::setPrd_restock_fee()
     * @uses Mb_membership_Product_DataObjectType::setPrd_restock_percent()
     * @uses Mb_membership_Product_DataObjectType::setPrd_restock_percent_cp()
     * @uses Mb_membership_Product_DataObjectType::setPrd_mail()
     * @uses Mb_membership_Product_DataObjectType::setPrd_email()
     * @uses Mb_membership_Product_DataObjectType::setPrd_fax()
     * @uses Mb_membership_Product_DataObjectType::setPrd_sell_online()
     * @uses Mb_membership_Product_DataObjectType::setPrd_online_abstract()
     * @uses Mb_membership_Product_DataObjectType::setPrd_code()
     * @uses Mb_membership_Product_DataObjectType::setPrd_short_description()
     * @uses Mb_membership_Product_DataObjectType::setPrd_thumbnail_doc_key()
     * @uses Mb_membership_Product_DataObjectType::setPrd_entity_key()
     * @uses Mb_membership_Product_DataObjectType::setPrd_web()
     * @uses Mb_membership_Product_DataObjectType::setPrd_microfiche()
     * @uses Mb_membership_Product_DataObjectType::setPrd_post_to_web_date()
     * @uses Mb_membership_Product_DataObjectType::setPrd_remove_from_web_date()
     * @uses Mb_membership_Product_DataObjectType::setPrd_ptc_key()
     * @uses Mb_membership_Product_DataObjectType::setPrd_format()
     * @uses Mb_membership_Product_DataObjectType::setPrd_download_url()
     * @uses Mb_membership_Product_DataObjectType::setPrd_show_as_new_until()
     * @uses Mb_membership_Product_DataObjectType::setPrd_pjt_key()
     * @uses Mb_membership_Product_DataObjectType::setPrd_gla_damaged_goods_key()
     * @uses Mb_membership_Product_DataObjectType::setPrd_order()
     * @uses Mb_membership_Product_DataObjectType::setPrd_download_available_days()
     * @uses Mb_membership_Product_DataObjectType::setPrd_weighted_average_cost()
     * @uses Mb_membership_Product_DataObjectType::setPrd_featured_product_flag()
     * @uses Mb_membership_Product_DataObjectType::setPrd_download_available_count()
     * @uses Mb_membership_Product_DataObjectType::setPrd_cct_key()
     * @uses Mb_membership_Product_DataObjectType::setPrd_pts_key()
     * @uses Mb_membership_Product_DataObjectType::setPrd_cmo_key()
     * @uses Mb_membership_Product_DataObjectType::setPrd_out_of_stock_override_message()
     * @uses Mb_membership_Product_DataObjectType::setPrd_pst_key()
     * @uses Mb_membership_Product_DataObjectType::setPrd_pcr_key()
     * @uses Mb_membership_Product_DataObjectType::setPrd_display_product_name()
     * @uses Mb_membership_Product_DataObjectType::setPrd_display_prd_key()
     * @param string $prd_key
     * @param string $prd_name
     * @param string $prd_add_user
     * @param string $prd_add_date
     * @param string $prd_change_user
     * @param string $prd_change_date
     * @param string $prd_delete_flag
     * @param string $prd_key_ext
     * @param string $prd_description
     * @param string $prd_allow_partial_ship_flag
     * @param string $prd_track_inventory_flag
     * @param string $prd_gla_cogs_key
     * @param string $prd_gla_inventory_key
     * @param string $prd_ptp_key
     * @param string $prd_start_date
     * @param string $prd_taxable_flag
     * @param string $prd_allow_backorder
     * @param string $prd_end_date
     * @param string $prd_atc_key
     * @param float $prd_qty_reorder
     * @param float $prd_restock_fee
     * @param float $prd_restock_percent
     * @param float $prd_restock_percent_cp
     * @param string $prd_mail
     * @param string $prd_email
     * @param string $prd_fax
     * @param string $prd_sell_online
     * @param string $prd_online_abstract
     * @param string $prd_code
     * @param string $prd_short_description
     * @param string $prd_thumbnail_doc_key
     * @param string $prd_entity_key
     * @param string $prd_web
     * @param string $prd_microfiche
     * @param string $prd_post_to_web_date
     * @param string $prd_remove_from_web_date
     * @param string $prd_ptc_key
     * @param string $prd_format
     * @param string $prd_download_url
     * @param string $prd_show_as_new_until
     * @param string $prd_pjt_key
     * @param string $prd_gla_damaged_goods_key
     * @param int $prd_order
     * @param int $prd_download_available_days
     * @param float $prd_weighted_average_cost
     * @param string $prd_featured_product_flag
     * @param int $prd_download_available_count
     * @param string $prd_cct_key
     * @param string $prd_pts_key
     * @param string $prd_cmo_key
     * @param string $prd_out_of_stock_override_message
     * @param string $prd_pst_key
     * @param string $prd_pcr_key
     * @param string $prd_display_product_name
     * @param string $prd_display_prd_key
     */
    public function __construct(?string $prd_key = null, ?string $prd_name = null, ?string $prd_add_user = null, ?string $prd_add_date = null, ?string $prd_change_user = null, ?string $prd_change_date = null, ?string $prd_delete_flag = null, ?string $prd_key_ext = null, ?string $prd_description = null, ?string $prd_allow_partial_ship_flag = null, ?string $prd_track_inventory_flag = null, ?string $prd_gla_cogs_key = null, ?string $prd_gla_inventory_key = null, ?string $prd_ptp_key = null, ?string $prd_start_date = null, ?string $prd_taxable_flag = null, ?string $prd_allow_backorder = null, ?string $prd_end_date = null, ?string $prd_atc_key = null, ?float $prd_qty_reorder = null, ?float $prd_restock_fee = null, ?float $prd_restock_percent = null, ?float $prd_restock_percent_cp = null, ?string $prd_mail = null, ?string $prd_email = null, ?string $prd_fax = null, ?string $prd_sell_online = null, ?string $prd_online_abstract = null, ?string $prd_code = null, ?string $prd_short_description = null, ?string $prd_thumbnail_doc_key = null, ?string $prd_entity_key = null, ?string $prd_web = null, ?string $prd_microfiche = null, ?string $prd_post_to_web_date = null, ?string $prd_remove_from_web_date = null, ?string $prd_ptc_key = null, ?string $prd_format = null, ?string $prd_download_url = null, ?string $prd_show_as_new_until = null, ?string $prd_pjt_key = null, ?string $prd_gla_damaged_goods_key = null, ?int $prd_order = null, ?int $prd_download_available_days = null, ?float $prd_weighted_average_cost = null, ?string $prd_featured_product_flag = null, ?int $prd_download_available_count = null, ?string $prd_cct_key = null, ?string $prd_pts_key = null, ?string $prd_cmo_key = null, ?string $prd_out_of_stock_override_message = null, ?string $prd_pst_key = null, ?string $prd_pcr_key = null, ?string $prd_display_product_name = null, ?string $prd_display_prd_key = null)
    {
        $this
            ->setPrd_key($prd_key)
            ->setPrd_name($prd_name)
            ->setPrd_add_user($prd_add_user)
            ->setPrd_add_date($prd_add_date)
            ->setPrd_change_user($prd_change_user)
            ->setPrd_change_date($prd_change_date)
            ->setPrd_delete_flag($prd_delete_flag)
            ->setPrd_key_ext($prd_key_ext)
            ->setPrd_description($prd_description)
            ->setPrd_allow_partial_ship_flag($prd_allow_partial_ship_flag)
            ->setPrd_track_inventory_flag($prd_track_inventory_flag)
            ->setPrd_gla_cogs_key($prd_gla_cogs_key)
            ->setPrd_gla_inventory_key($prd_gla_inventory_key)
            ->setPrd_ptp_key($prd_ptp_key)
            ->setPrd_start_date($prd_start_date)
            ->setPrd_taxable_flag($prd_taxable_flag)
            ->setPrd_allow_backorder($prd_allow_backorder)
            ->setPrd_end_date($prd_end_date)
            ->setPrd_atc_key($prd_atc_key)
            ->setPrd_qty_reorder($prd_qty_reorder)
            ->setPrd_restock_fee($prd_restock_fee)
            ->setPrd_restock_percent($prd_restock_percent)
            ->setPrd_restock_percent_cp($prd_restock_percent_cp)
            ->setPrd_mail($prd_mail)
            ->setPrd_email($prd_email)
            ->setPrd_fax($prd_fax)
            ->setPrd_sell_online($prd_sell_online)
            ->setPrd_online_abstract($prd_online_abstract)
            ->setPrd_code($prd_code)
            ->setPrd_short_description($prd_short_description)
            ->setPrd_thumbnail_doc_key($prd_thumbnail_doc_key)
            ->setPrd_entity_key($prd_entity_key)
            ->setPrd_web($prd_web)
            ->setPrd_microfiche($prd_microfiche)
            ->setPrd_post_to_web_date($prd_post_to_web_date)
            ->setPrd_remove_from_web_date($prd_remove_from_web_date)
            ->setPrd_ptc_key($prd_ptc_key)
            ->setPrd_format($prd_format)
            ->setPrd_download_url($prd_download_url)
            ->setPrd_show_as_new_until($prd_show_as_new_until)
            ->setPrd_pjt_key($prd_pjt_key)
            ->setPrd_gla_damaged_goods_key($prd_gla_damaged_goods_key)
            ->setPrd_order($prd_order)
            ->setPrd_download_available_days($prd_download_available_days)
            ->setPrd_weighted_average_cost($prd_weighted_average_cost)
            ->setPrd_featured_product_flag($prd_featured_product_flag)
            ->setPrd_download_available_count($prd_download_available_count)
            ->setPrd_cct_key($prd_cct_key)
            ->setPrd_pts_key($prd_pts_key)
            ->setPrd_cmo_key($prd_cmo_key)
            ->setPrd_out_of_stock_override_message($prd_out_of_stock_override_message)
            ->setPrd_pst_key($prd_pst_key)
            ->setPrd_pcr_key($prd_pcr_key)
            ->setPrd_display_product_name($prd_display_product_name)
            ->setPrd_display_prd_key($prd_display_prd_key);
    }
    /**
     * Get prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_key(): ?string
    {
        return $this->prd_key ?? null;
    }
    /**
     * Set prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_key(?string $prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_key) && !is_string($prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_key, true), gettype($prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prd_key, true)), __LINE__);
        }
        if (is_null($prd_key) || (is_array($prd_key) && empty($prd_key))) {
            unset($this->prd_key);
        } else {
            $this->prd_key = $prd_key;
        }
        
        return $this;
    }
    /**
     * Get prd_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_name(): ?string
    {
        return $this->prd_name ?? null;
    }
    /**
     * Set prd_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_name(?string $prd_name = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_name) && !is_string($prd_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_name, true), gettype($prd_name)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($prd_name) && mb_strlen((string) $prd_name) > 255) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen((string) $prd_name)), __LINE__);
        }
        if (is_null($prd_name) || (is_array($prd_name) && empty($prd_name))) {
            unset($this->prd_name);
        } else {
            $this->prd_name = $prd_name;
        }
        
        return $this;
    }
    /**
     * Get prd_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_add_user(): ?string
    {
        return $this->prd_add_user ?? null;
    }
    /**
     * Set prd_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_add_user(?string $prd_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_add_user) && !is_string($prd_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_add_user, true), gettype($prd_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($prd_add_user) && mb_strlen((string) $prd_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $prd_add_user)), __LINE__);
        }
        if (is_null($prd_add_user) || (is_array($prd_add_user) && empty($prd_add_user))) {
            unset($this->prd_add_user);
        } else {
            $this->prd_add_user = $prd_add_user;
        }
        
        return $this;
    }
    /**
     * Get prd_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_add_date(): ?string
    {
        return $this->prd_add_date ?? null;
    }
    /**
     * Set prd_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_add_date(?string $prd_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_add_date) && !is_string($prd_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_add_date, true), gettype($prd_add_date)), __LINE__);
        }
        if (is_null($prd_add_date) || (is_array($prd_add_date) && empty($prd_add_date))) {
            unset($this->prd_add_date);
        } else {
            $this->prd_add_date = $prd_add_date;
        }
        
        return $this;
    }
    /**
     * Get prd_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_change_user(): ?string
    {
        return $this->prd_change_user ?? null;
    }
    /**
     * Set prd_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_change_user(?string $prd_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_change_user) && !is_string($prd_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_change_user, true), gettype($prd_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($prd_change_user) && mb_strlen((string) $prd_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $prd_change_user)), __LINE__);
        }
        if (is_null($prd_change_user) || (is_array($prd_change_user) && empty($prd_change_user))) {
            unset($this->prd_change_user);
        } else {
            $this->prd_change_user = $prd_change_user;
        }
        
        return $this;
    }
    /**
     * Get prd_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_change_date(): ?string
    {
        return $this->prd_change_date ?? null;
    }
    /**
     * Set prd_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_change_date(?string $prd_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_change_date) && !is_string($prd_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_change_date, true), gettype($prd_change_date)), __LINE__);
        }
        if (is_null($prd_change_date) || (is_array($prd_change_date) && empty($prd_change_date))) {
            unset($this->prd_change_date);
        } else {
            $this->prd_change_date = $prd_change_date;
        }
        
        return $this;
    }
    /**
     * Get prd_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_delete_flag(): ?string
    {
        return $this->prd_delete_flag ?? null;
    }
    /**
     * Set prd_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_delete_flag(?string $prd_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_delete_flag) && !is_string($prd_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_delete_flag, true), gettype($prd_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prd_delete_flag) && $prd_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prd_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prd_delete_flag) && $prd_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prd_delete_flag, true)), __LINE__);
        }
        if (is_null($prd_delete_flag) || (is_array($prd_delete_flag) && empty($prd_delete_flag))) {
            unset($this->prd_delete_flag);
        } else {
            $this->prd_delete_flag = $prd_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get prd_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_key_ext(): ?string
    {
        return $this->prd_key_ext ?? null;
    }
    /**
     * Set prd_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_key_ext(?string $prd_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_key_ext) && !is_string($prd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_key_ext, true), gettype($prd_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prd_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prd_key_ext, true)), __LINE__);
        }
        if (is_null($prd_key_ext) || (is_array($prd_key_ext) && empty($prd_key_ext))) {
            unset($this->prd_key_ext);
        } else {
            $this->prd_key_ext = $prd_key_ext;
        }
        
        return $this;
    }
    /**
     * Get prd_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_description(): ?string
    {
        return $this->prd_description ?? null;
    }
    /**
     * Set prd_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_description(?string $prd_description = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_description) && !is_string($prd_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_description, true), gettype($prd_description)), __LINE__);
        }
        if (is_null($prd_description) || (is_array($prd_description) && empty($prd_description))) {
            unset($this->prd_description);
        } else {
            $this->prd_description = $prd_description;
        }
        
        return $this;
    }
    /**
     * Get prd_allow_partial_ship_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_allow_partial_ship_flag(): ?string
    {
        return $this->prd_allow_partial_ship_flag ?? null;
    }
    /**
     * Set prd_allow_partial_ship_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_allow_partial_ship_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_allow_partial_ship_flag(?string $prd_allow_partial_ship_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_allow_partial_ship_flag) && !is_string($prd_allow_partial_ship_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_allow_partial_ship_flag, true), gettype($prd_allow_partial_ship_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prd_allow_partial_ship_flag) && $prd_allow_partial_ship_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prd_allow_partial_ship_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prd_allow_partial_ship_flag) && $prd_allow_partial_ship_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prd_allow_partial_ship_flag, true)), __LINE__);
        }
        if (is_null($prd_allow_partial_ship_flag) || (is_array($prd_allow_partial_ship_flag) && empty($prd_allow_partial_ship_flag))) {
            unset($this->prd_allow_partial_ship_flag);
        } else {
            $this->prd_allow_partial_ship_flag = $prd_allow_partial_ship_flag;
        }
        
        return $this;
    }
    /**
     * Get prd_track_inventory_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_track_inventory_flag(): ?string
    {
        return $this->prd_track_inventory_flag ?? null;
    }
    /**
     * Set prd_track_inventory_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_track_inventory_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_track_inventory_flag(?string $prd_track_inventory_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_track_inventory_flag) && !is_string($prd_track_inventory_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_track_inventory_flag, true), gettype($prd_track_inventory_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prd_track_inventory_flag) && $prd_track_inventory_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prd_track_inventory_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prd_track_inventory_flag) && $prd_track_inventory_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prd_track_inventory_flag, true)), __LINE__);
        }
        if (is_null($prd_track_inventory_flag) || (is_array($prd_track_inventory_flag) && empty($prd_track_inventory_flag))) {
            unset($this->prd_track_inventory_flag);
        } else {
            $this->prd_track_inventory_flag = $prd_track_inventory_flag;
        }
        
        return $this;
    }
    /**
     * Get prd_gla_cogs_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_gla_cogs_key(): ?string
    {
        return $this->prd_gla_cogs_key ?? null;
    }
    /**
     * Set prd_gla_cogs_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_gla_cogs_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_gla_cogs_key(?string $prd_gla_cogs_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_gla_cogs_key) && !is_string($prd_gla_cogs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_gla_cogs_key, true), gettype($prd_gla_cogs_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prd_gla_cogs_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prd_gla_cogs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prd_gla_cogs_key, true)), __LINE__);
        }
        if (is_null($prd_gla_cogs_key) || (is_array($prd_gla_cogs_key) && empty($prd_gla_cogs_key))) {
            unset($this->prd_gla_cogs_key);
        } else {
            $this->prd_gla_cogs_key = $prd_gla_cogs_key;
        }
        
        return $this;
    }
    /**
     * Get prd_gla_inventory_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_gla_inventory_key(): ?string
    {
        return $this->prd_gla_inventory_key ?? null;
    }
    /**
     * Set prd_gla_inventory_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_gla_inventory_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_gla_inventory_key(?string $prd_gla_inventory_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_gla_inventory_key) && !is_string($prd_gla_inventory_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_gla_inventory_key, true), gettype($prd_gla_inventory_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prd_gla_inventory_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prd_gla_inventory_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prd_gla_inventory_key, true)), __LINE__);
        }
        if (is_null($prd_gla_inventory_key) || (is_array($prd_gla_inventory_key) && empty($prd_gla_inventory_key))) {
            unset($this->prd_gla_inventory_key);
        } else {
            $this->prd_gla_inventory_key = $prd_gla_inventory_key;
        }
        
        return $this;
    }
    /**
     * Get prd_ptp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_ptp_key(): ?string
    {
        return $this->prd_ptp_key ?? null;
    }
    /**
     * Set prd_ptp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_ptp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_ptp_key(?string $prd_ptp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_ptp_key) && !is_string($prd_ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_ptp_key, true), gettype($prd_ptp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prd_ptp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prd_ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prd_ptp_key, true)), __LINE__);
        }
        if (is_null($prd_ptp_key) || (is_array($prd_ptp_key) && empty($prd_ptp_key))) {
            unset($this->prd_ptp_key);
        } else {
            $this->prd_ptp_key = $prd_ptp_key;
        }
        
        return $this;
    }
    /**
     * Get prd_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_start_date(): ?string
    {
        return $this->prd_start_date ?? null;
    }
    /**
     * Set prd_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_start_date(?string $prd_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_start_date) && !is_string($prd_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_start_date, true), gettype($prd_start_date)), __LINE__);
        }
        if (is_null($prd_start_date) || (is_array($prd_start_date) && empty($prd_start_date))) {
            unset($this->prd_start_date);
        } else {
            $this->prd_start_date = $prd_start_date;
        }
        
        return $this;
    }
    /**
     * Get prd_taxable_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_taxable_flag(): ?string
    {
        return $this->prd_taxable_flag ?? null;
    }
    /**
     * Set prd_taxable_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_taxable_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_taxable_flag(?string $prd_taxable_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_taxable_flag) && !is_string($prd_taxable_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_taxable_flag, true), gettype($prd_taxable_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prd_taxable_flag) && $prd_taxable_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prd_taxable_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prd_taxable_flag) && $prd_taxable_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prd_taxable_flag, true)), __LINE__);
        }
        if (is_null($prd_taxable_flag) || (is_array($prd_taxable_flag) && empty($prd_taxable_flag))) {
            unset($this->prd_taxable_flag);
        } else {
            $this->prd_taxable_flag = $prd_taxable_flag;
        }
        
        return $this;
    }
    /**
     * Get prd_allow_backorder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_allow_backorder(): ?string
    {
        return $this->prd_allow_backorder ?? null;
    }
    /**
     * Set prd_allow_backorder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_allow_backorder
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_allow_backorder(?string $prd_allow_backorder = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_allow_backorder) && !is_string($prd_allow_backorder)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_allow_backorder, true), gettype($prd_allow_backorder)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prd_allow_backorder) && $prd_allow_backorder > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prd_allow_backorder, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prd_allow_backorder) && $prd_allow_backorder < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prd_allow_backorder, true)), __LINE__);
        }
        if (is_null($prd_allow_backorder) || (is_array($prd_allow_backorder) && empty($prd_allow_backorder))) {
            unset($this->prd_allow_backorder);
        } else {
            $this->prd_allow_backorder = $prd_allow_backorder;
        }
        
        return $this;
    }
    /**
     * Get prd_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_end_date(): ?string
    {
        return $this->prd_end_date ?? null;
    }
    /**
     * Set prd_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_end_date(?string $prd_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_end_date) && !is_string($prd_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_end_date, true), gettype($prd_end_date)), __LINE__);
        }
        if (is_null($prd_end_date) || (is_array($prd_end_date) && empty($prd_end_date))) {
            unset($this->prd_end_date);
        } else {
            $this->prd_end_date = $prd_end_date;
        }
        
        return $this;
    }
    /**
     * Get prd_atc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_atc_key(): ?string
    {
        return $this->prd_atc_key ?? null;
    }
    /**
     * Set prd_atc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_atc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_atc_key(?string $prd_atc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_atc_key) && !is_string($prd_atc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_atc_key, true), gettype($prd_atc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prd_atc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prd_atc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prd_atc_key, true)), __LINE__);
        }
        if (is_null($prd_atc_key) || (is_array($prd_atc_key) && empty($prd_atc_key))) {
            unset($this->prd_atc_key);
        } else {
            $this->prd_atc_key = $prd_atc_key;
        }
        
        return $this;
    }
    /**
     * Get prd_qty_reorder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrd_qty_reorder(): ?float
    {
        return $this->prd_qty_reorder ?? null;
    }
    /**
     * Set prd_qty_reorder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prd_qty_reorder
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_qty_reorder(?float $prd_qty_reorder = null): self
    {
        // validation for constraint: float
        if (!is_null($prd_qty_reorder) && !(is_float($prd_qty_reorder) || is_numeric($prd_qty_reorder))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prd_qty_reorder, true), gettype($prd_qty_reorder)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($prd_qty_reorder) && mb_strlen(mb_substr((string) $prd_qty_reorder, false !== mb_strpos((string) $prd_qty_reorder, '.') ? mb_strpos((string) $prd_qty_reorder, '.') + 1 : mb_strlen((string) $prd_qty_reorder))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($prd_qty_reorder, true), mb_strlen(mb_substr((string) $prd_qty_reorder, mb_strpos((string) $prd_qty_reorder, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($prd_qty_reorder) && mb_strlen(preg_replace('/(\D)/', '', (string) $prd_qty_reorder)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($prd_qty_reorder, true), mb_strlen(preg_replace('/(\D)/', '', (string) $prd_qty_reorder))), __LINE__);
        }
        if (is_null($prd_qty_reorder) || (is_array($prd_qty_reorder) && empty($prd_qty_reorder))) {
            unset($this->prd_qty_reorder);
        } else {
            $this->prd_qty_reorder = $prd_qty_reorder;
        }
        
        return $this;
    }
    /**
     * Get prd_restock_fee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrd_restock_fee(): ?float
    {
        return $this->prd_restock_fee ?? null;
    }
    /**
     * Set prd_restock_fee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prd_restock_fee
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_restock_fee(?float $prd_restock_fee = null): self
    {
        // validation for constraint: float
        if (!is_null($prd_restock_fee) && !(is_float($prd_restock_fee) || is_numeric($prd_restock_fee))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prd_restock_fee, true), gettype($prd_restock_fee)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($prd_restock_fee) && mb_strlen(mb_substr((string) $prd_restock_fee, false !== mb_strpos((string) $prd_restock_fee, '.') ? mb_strpos((string) $prd_restock_fee, '.') + 1 : mb_strlen((string) $prd_restock_fee))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($prd_restock_fee, true), mb_strlen(mb_substr((string) $prd_restock_fee, mb_strpos((string) $prd_restock_fee, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($prd_restock_fee) && mb_strlen(preg_replace('/(\D)/', '', (string) $prd_restock_fee)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($prd_restock_fee, true), mb_strlen(preg_replace('/(\D)/', '', (string) $prd_restock_fee))), __LINE__);
        }
        if (is_null($prd_restock_fee) || (is_array($prd_restock_fee) && empty($prd_restock_fee))) {
            unset($this->prd_restock_fee);
        } else {
            $this->prd_restock_fee = $prd_restock_fee;
        }
        
        return $this;
    }
    /**
     * Get prd_restock_percent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrd_restock_percent(): ?float
    {
        return $this->prd_restock_percent ?? null;
    }
    /**
     * Set prd_restock_percent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prd_restock_percent
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_restock_percent(?float $prd_restock_percent = null): self
    {
        // validation for constraint: float
        if (!is_null($prd_restock_percent) && !(is_float($prd_restock_percent) || is_numeric($prd_restock_percent))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prd_restock_percent, true), gettype($prd_restock_percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($prd_restock_percent) && mb_strlen(mb_substr((string) $prd_restock_percent, false !== mb_strpos((string) $prd_restock_percent, '.') ? mb_strpos((string) $prd_restock_percent, '.') + 1 : mb_strlen((string) $prd_restock_percent))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($prd_restock_percent, true), mb_strlen(mb_substr((string) $prd_restock_percent, mb_strpos((string) $prd_restock_percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($prd_restock_percent) && mb_strlen(preg_replace('/(\D)/', '', (string) $prd_restock_percent)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($prd_restock_percent, true), mb_strlen(preg_replace('/(\D)/', '', (string) $prd_restock_percent))), __LINE__);
        }
        if (is_null($prd_restock_percent) || (is_array($prd_restock_percent) && empty($prd_restock_percent))) {
            unset($this->prd_restock_percent);
        } else {
            $this->prd_restock_percent = $prd_restock_percent;
        }
        
        return $this;
    }
    /**
     * Get prd_restock_percent_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrd_restock_percent_cp(): ?float
    {
        return $this->prd_restock_percent_cp ?? null;
    }
    /**
     * Set prd_restock_percent_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prd_restock_percent_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_restock_percent_cp(?float $prd_restock_percent_cp = null): self
    {
        // validation for constraint: float
        if (!is_null($prd_restock_percent_cp) && !(is_float($prd_restock_percent_cp) || is_numeric($prd_restock_percent_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prd_restock_percent_cp, true), gettype($prd_restock_percent_cp)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($prd_restock_percent_cp) && mb_strlen(mb_substr((string) $prd_restock_percent_cp, false !== mb_strpos((string) $prd_restock_percent_cp, '.') ? mb_strpos((string) $prd_restock_percent_cp, '.') + 1 : mb_strlen((string) $prd_restock_percent_cp))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($prd_restock_percent_cp, true), mb_strlen(mb_substr((string) $prd_restock_percent_cp, mb_strpos((string) $prd_restock_percent_cp, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($prd_restock_percent_cp) && mb_strlen(preg_replace('/(\D)/', '', (string) $prd_restock_percent_cp)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($prd_restock_percent_cp, true), mb_strlen(preg_replace('/(\D)/', '', (string) $prd_restock_percent_cp))), __LINE__);
        }
        if (is_null($prd_restock_percent_cp) || (is_array($prd_restock_percent_cp) && empty($prd_restock_percent_cp))) {
            unset($this->prd_restock_percent_cp);
        } else {
            $this->prd_restock_percent_cp = $prd_restock_percent_cp;
        }
        
        return $this;
    }
    /**
     * Get prd_mail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_mail(): ?string
    {
        return $this->prd_mail ?? null;
    }
    /**
     * Set prd_mail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_mail
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_mail(?string $prd_mail = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_mail) && !is_string($prd_mail)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_mail, true), gettype($prd_mail)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prd_mail) && $prd_mail > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prd_mail, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prd_mail) && $prd_mail < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prd_mail, true)), __LINE__);
        }
        if (is_null($prd_mail) || (is_array($prd_mail) && empty($prd_mail))) {
            unset($this->prd_mail);
        } else {
            $this->prd_mail = $prd_mail;
        }
        
        return $this;
    }
    /**
     * Get prd_email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_email(): ?string
    {
        return $this->prd_email ?? null;
    }
    /**
     * Set prd_email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_email
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_email(?string $prd_email = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_email) && !is_string($prd_email)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_email, true), gettype($prd_email)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prd_email) && $prd_email > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prd_email, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prd_email) && $prd_email < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prd_email, true)), __LINE__);
        }
        if (is_null($prd_email) || (is_array($prd_email) && empty($prd_email))) {
            unset($this->prd_email);
        } else {
            $this->prd_email = $prd_email;
        }
        
        return $this;
    }
    /**
     * Get prd_fax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_fax(): ?string
    {
        return $this->prd_fax ?? null;
    }
    /**
     * Set prd_fax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_fax
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_fax(?string $prd_fax = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_fax) && !is_string($prd_fax)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_fax, true), gettype($prd_fax)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prd_fax) && $prd_fax > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prd_fax, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prd_fax) && $prd_fax < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prd_fax, true)), __LINE__);
        }
        if (is_null($prd_fax) || (is_array($prd_fax) && empty($prd_fax))) {
            unset($this->prd_fax);
        } else {
            $this->prd_fax = $prd_fax;
        }
        
        return $this;
    }
    /**
     * Get prd_sell_online value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_sell_online(): ?string
    {
        return $this->prd_sell_online ?? null;
    }
    /**
     * Set prd_sell_online value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_sell_online
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_sell_online(?string $prd_sell_online = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_sell_online) && !is_string($prd_sell_online)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_sell_online, true), gettype($prd_sell_online)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prd_sell_online) && $prd_sell_online > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prd_sell_online, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prd_sell_online) && $prd_sell_online < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prd_sell_online, true)), __LINE__);
        }
        if (is_null($prd_sell_online) || (is_array($prd_sell_online) && empty($prd_sell_online))) {
            unset($this->prd_sell_online);
        } else {
            $this->prd_sell_online = $prd_sell_online;
        }
        
        return $this;
    }
    /**
     * Get prd_online_abstract value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_online_abstract(): ?string
    {
        return $this->prd_online_abstract ?? null;
    }
    /**
     * Set prd_online_abstract value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_online_abstract
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_online_abstract(?string $prd_online_abstract = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_online_abstract) && !is_string($prd_online_abstract)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_online_abstract, true), gettype($prd_online_abstract)), __LINE__);
        }
        if (is_null($prd_online_abstract) || (is_array($prd_online_abstract) && empty($prd_online_abstract))) {
            unset($this->prd_online_abstract);
        } else {
            $this->prd_online_abstract = $prd_online_abstract;
        }
        
        return $this;
    }
    /**
     * Get prd_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_code(): ?string
    {
        return $this->prd_code ?? null;
    }
    /**
     * Set prd_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_code(?string $prd_code = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_code) && !is_string($prd_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_code, true), gettype($prd_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($prd_code) && mb_strlen((string) $prd_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $prd_code)), __LINE__);
        }
        if (is_null($prd_code) || (is_array($prd_code) && empty($prd_code))) {
            unset($this->prd_code);
        } else {
            $this->prd_code = $prd_code;
        }
        
        return $this;
    }
    /**
     * Get prd_short_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_short_description(): ?string
    {
        return $this->prd_short_description ?? null;
    }
    /**
     * Set prd_short_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_short_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_short_description(?string $prd_short_description = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_short_description) && !is_string($prd_short_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_short_description, true), gettype($prd_short_description)), __LINE__);
        }
        // validation for constraint: maxLength(400)
        if (!is_null($prd_short_description) && mb_strlen((string) $prd_short_description) > 400) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 400', mb_strlen((string) $prd_short_description)), __LINE__);
        }
        if (is_null($prd_short_description) || (is_array($prd_short_description) && empty($prd_short_description))) {
            unset($this->prd_short_description);
        } else {
            $this->prd_short_description = $prd_short_description;
        }
        
        return $this;
    }
    /**
     * Get prd_thumbnail_doc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_thumbnail_doc_key(): ?string
    {
        return $this->prd_thumbnail_doc_key ?? null;
    }
    /**
     * Set prd_thumbnail_doc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_thumbnail_doc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_thumbnail_doc_key(?string $prd_thumbnail_doc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_thumbnail_doc_key) && !is_string($prd_thumbnail_doc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_thumbnail_doc_key, true), gettype($prd_thumbnail_doc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prd_thumbnail_doc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prd_thumbnail_doc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prd_thumbnail_doc_key, true)), __LINE__);
        }
        if (is_null($prd_thumbnail_doc_key) || (is_array($prd_thumbnail_doc_key) && empty($prd_thumbnail_doc_key))) {
            unset($this->prd_thumbnail_doc_key);
        } else {
            $this->prd_thumbnail_doc_key = $prd_thumbnail_doc_key;
        }
        
        return $this;
    }
    /**
     * Get prd_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_entity_key(): ?string
    {
        return $this->prd_entity_key ?? null;
    }
    /**
     * Set prd_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_entity_key(?string $prd_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_entity_key) && !is_string($prd_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_entity_key, true), gettype($prd_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prd_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prd_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prd_entity_key, true)), __LINE__);
        }
        if (is_null($prd_entity_key) || (is_array($prd_entity_key) && empty($prd_entity_key))) {
            unset($this->prd_entity_key);
        } else {
            $this->prd_entity_key = $prd_entity_key;
        }
        
        return $this;
    }
    /**
     * Get prd_web value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_web(): ?string
    {
        return $this->prd_web ?? null;
    }
    /**
     * Set prd_web value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_web
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_web(?string $prd_web = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_web) && !is_string($prd_web)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_web, true), gettype($prd_web)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prd_web) && $prd_web > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prd_web, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prd_web) && $prd_web < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prd_web, true)), __LINE__);
        }
        if (is_null($prd_web) || (is_array($prd_web) && empty($prd_web))) {
            unset($this->prd_web);
        } else {
            $this->prd_web = $prd_web;
        }
        
        return $this;
    }
    /**
     * Get prd_microfiche value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_microfiche(): ?string
    {
        return $this->prd_microfiche ?? null;
    }
    /**
     * Set prd_microfiche value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_microfiche
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_microfiche(?string $prd_microfiche = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_microfiche) && !is_string($prd_microfiche)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_microfiche, true), gettype($prd_microfiche)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prd_microfiche) && $prd_microfiche > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prd_microfiche, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prd_microfiche) && $prd_microfiche < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prd_microfiche, true)), __LINE__);
        }
        if (is_null($prd_microfiche) || (is_array($prd_microfiche) && empty($prd_microfiche))) {
            unset($this->prd_microfiche);
        } else {
            $this->prd_microfiche = $prd_microfiche;
        }
        
        return $this;
    }
    /**
     * Get prd_post_to_web_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_post_to_web_date(): ?string
    {
        return $this->prd_post_to_web_date ?? null;
    }
    /**
     * Set prd_post_to_web_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_post_to_web_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_post_to_web_date(?string $prd_post_to_web_date = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_post_to_web_date) && !is_string($prd_post_to_web_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_post_to_web_date, true), gettype($prd_post_to_web_date)), __LINE__);
        }
        if (is_null($prd_post_to_web_date) || (is_array($prd_post_to_web_date) && empty($prd_post_to_web_date))) {
            unset($this->prd_post_to_web_date);
        } else {
            $this->prd_post_to_web_date = $prd_post_to_web_date;
        }
        
        return $this;
    }
    /**
     * Get prd_remove_from_web_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_remove_from_web_date(): ?string
    {
        return $this->prd_remove_from_web_date ?? null;
    }
    /**
     * Set prd_remove_from_web_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_remove_from_web_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_remove_from_web_date(?string $prd_remove_from_web_date = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_remove_from_web_date) && !is_string($prd_remove_from_web_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_remove_from_web_date, true), gettype($prd_remove_from_web_date)), __LINE__);
        }
        if (is_null($prd_remove_from_web_date) || (is_array($prd_remove_from_web_date) && empty($prd_remove_from_web_date))) {
            unset($this->prd_remove_from_web_date);
        } else {
            $this->prd_remove_from_web_date = $prd_remove_from_web_date;
        }
        
        return $this;
    }
    /**
     * Get prd_ptc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_ptc_key(): ?string
    {
        return $this->prd_ptc_key ?? null;
    }
    /**
     * Set prd_ptc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_ptc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_ptc_key(?string $prd_ptc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_ptc_key) && !is_string($prd_ptc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_ptc_key, true), gettype($prd_ptc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prd_ptc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prd_ptc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prd_ptc_key, true)), __LINE__);
        }
        if (is_null($prd_ptc_key) || (is_array($prd_ptc_key) && empty($prd_ptc_key))) {
            unset($this->prd_ptc_key);
        } else {
            $this->prd_ptc_key = $prd_ptc_key;
        }
        
        return $this;
    }
    /**
     * Get prd_format value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_format(): ?string
    {
        return $this->prd_format ?? null;
    }
    /**
     * Set prd_format value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_format
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_format(?string $prd_format = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_format) && !is_string($prd_format)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_format, true), gettype($prd_format)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($prd_format) && mb_strlen((string) $prd_format) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen((string) $prd_format)), __LINE__);
        }
        if (is_null($prd_format) || (is_array($prd_format) && empty($prd_format))) {
            unset($this->prd_format);
        } else {
            $this->prd_format = $prd_format;
        }
        
        return $this;
    }
    /**
     * Get prd_download_url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_download_url(): ?string
    {
        return $this->prd_download_url ?? null;
    }
    /**
     * Set prd_download_url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_download_url
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_download_url(?string $prd_download_url = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_download_url) && !is_string($prd_download_url)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_download_url, true), gettype($prd_download_url)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($prd_download_url) && mb_strlen((string) $prd_download_url) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $prd_download_url)), __LINE__);
        }
        if (is_null($prd_download_url) || (is_array($prd_download_url) && empty($prd_download_url))) {
            unset($this->prd_download_url);
        } else {
            $this->prd_download_url = $prd_download_url;
        }
        
        return $this;
    }
    /**
     * Get prd_show_as_new_until value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_show_as_new_until(): ?string
    {
        return $this->prd_show_as_new_until ?? null;
    }
    /**
     * Set prd_show_as_new_until value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_show_as_new_until
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_show_as_new_until(?string $prd_show_as_new_until = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_show_as_new_until) && !is_string($prd_show_as_new_until)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_show_as_new_until, true), gettype($prd_show_as_new_until)), __LINE__);
        }
        if (is_null($prd_show_as_new_until) || (is_array($prd_show_as_new_until) && empty($prd_show_as_new_until))) {
            unset($this->prd_show_as_new_until);
        } else {
            $this->prd_show_as_new_until = $prd_show_as_new_until;
        }
        
        return $this;
    }
    /**
     * Get prd_pjt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_pjt_key(): ?string
    {
        return $this->prd_pjt_key ?? null;
    }
    /**
     * Set prd_pjt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_pjt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_pjt_key(?string $prd_pjt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_pjt_key) && !is_string($prd_pjt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_pjt_key, true), gettype($prd_pjt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prd_pjt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prd_pjt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prd_pjt_key, true)), __LINE__);
        }
        if (is_null($prd_pjt_key) || (is_array($prd_pjt_key) && empty($prd_pjt_key))) {
            unset($this->prd_pjt_key);
        } else {
            $this->prd_pjt_key = $prd_pjt_key;
        }
        
        return $this;
    }
    /**
     * Get prd_gla_damaged_goods_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_gla_damaged_goods_key(): ?string
    {
        return $this->prd_gla_damaged_goods_key ?? null;
    }
    /**
     * Set prd_gla_damaged_goods_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_gla_damaged_goods_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_gla_damaged_goods_key(?string $prd_gla_damaged_goods_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_gla_damaged_goods_key) && !is_string($prd_gla_damaged_goods_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_gla_damaged_goods_key, true), gettype($prd_gla_damaged_goods_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prd_gla_damaged_goods_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prd_gla_damaged_goods_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prd_gla_damaged_goods_key, true)), __LINE__);
        }
        if (is_null($prd_gla_damaged_goods_key) || (is_array($prd_gla_damaged_goods_key) && empty($prd_gla_damaged_goods_key))) {
            unset($this->prd_gla_damaged_goods_key);
        } else {
            $this->prd_gla_damaged_goods_key = $prd_gla_damaged_goods_key;
        }
        
        return $this;
    }
    /**
     * Get prd_order value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrd_order(): ?int
    {
        return $this->prd_order ?? null;
    }
    /**
     * Set prd_order value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $prd_order
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_order(?int $prd_order = null): self
    {
        // validation for constraint: int
        if (!is_null($prd_order) && !(is_int($prd_order) || ctype_digit($prd_order))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prd_order, true), gettype($prd_order)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($prd_order) && $prd_order > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($prd_order, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($prd_order) && $prd_order < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($prd_order, true)), __LINE__);
        }
        if (is_null($prd_order) || (is_array($prd_order) && empty($prd_order))) {
            unset($this->prd_order);
        } else {
            $this->prd_order = $prd_order;
        }
        
        return $this;
    }
    /**
     * Get prd_download_available_days value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrd_download_available_days(): ?int
    {
        return $this->prd_download_available_days ?? null;
    }
    /**
     * Set prd_download_available_days value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $prd_download_available_days
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_download_available_days(?int $prd_download_available_days = null): self
    {
        // validation for constraint: int
        if (!is_null($prd_download_available_days) && !(is_int($prd_download_available_days) || ctype_digit($prd_download_available_days))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prd_download_available_days, true), gettype($prd_download_available_days)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($prd_download_available_days) && $prd_download_available_days > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($prd_download_available_days, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($prd_download_available_days) && $prd_download_available_days < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($prd_download_available_days, true)), __LINE__);
        }
        if (is_null($prd_download_available_days) || (is_array($prd_download_available_days) && empty($prd_download_available_days))) {
            unset($this->prd_download_available_days);
        } else {
            $this->prd_download_available_days = $prd_download_available_days;
        }
        
        return $this;
    }
    /**
     * Get prd_weighted_average_cost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrd_weighted_average_cost(): ?float
    {
        return $this->prd_weighted_average_cost ?? null;
    }
    /**
     * Set prd_weighted_average_cost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prd_weighted_average_cost
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_weighted_average_cost(?float $prd_weighted_average_cost = null): self
    {
        // validation for constraint: float
        if (!is_null($prd_weighted_average_cost) && !(is_float($prd_weighted_average_cost) || is_numeric($prd_weighted_average_cost))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prd_weighted_average_cost, true), gettype($prd_weighted_average_cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($prd_weighted_average_cost) && mb_strlen(mb_substr((string) $prd_weighted_average_cost, false !== mb_strpos((string) $prd_weighted_average_cost, '.') ? mb_strpos((string) $prd_weighted_average_cost, '.') + 1 : mb_strlen((string) $prd_weighted_average_cost))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($prd_weighted_average_cost, true), mb_strlen(mb_substr((string) $prd_weighted_average_cost, mb_strpos((string) $prd_weighted_average_cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($prd_weighted_average_cost) && mb_strlen(preg_replace('/(\D)/', '', (string) $prd_weighted_average_cost)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($prd_weighted_average_cost, true), mb_strlen(preg_replace('/(\D)/', '', (string) $prd_weighted_average_cost))), __LINE__);
        }
        if (is_null($prd_weighted_average_cost) || (is_array($prd_weighted_average_cost) && empty($prd_weighted_average_cost))) {
            unset($this->prd_weighted_average_cost);
        } else {
            $this->prd_weighted_average_cost = $prd_weighted_average_cost;
        }
        
        return $this;
    }
    /**
     * Get prd_featured_product_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_featured_product_flag(): ?string
    {
        return $this->prd_featured_product_flag ?? null;
    }
    /**
     * Set prd_featured_product_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_featured_product_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_featured_product_flag(?string $prd_featured_product_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_featured_product_flag) && !is_string($prd_featured_product_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_featured_product_flag, true), gettype($prd_featured_product_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prd_featured_product_flag) && $prd_featured_product_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prd_featured_product_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prd_featured_product_flag) && $prd_featured_product_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prd_featured_product_flag, true)), __LINE__);
        }
        if (is_null($prd_featured_product_flag) || (is_array($prd_featured_product_flag) && empty($prd_featured_product_flag))) {
            unset($this->prd_featured_product_flag);
        } else {
            $this->prd_featured_product_flag = $prd_featured_product_flag;
        }
        
        return $this;
    }
    /**
     * Get prd_download_available_count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrd_download_available_count(): ?int
    {
        return $this->prd_download_available_count ?? null;
    }
    /**
     * Set prd_download_available_count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $prd_download_available_count
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_download_available_count(?int $prd_download_available_count = null): self
    {
        // validation for constraint: int
        if (!is_null($prd_download_available_count) && !(is_int($prd_download_available_count) || ctype_digit($prd_download_available_count))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prd_download_available_count, true), gettype($prd_download_available_count)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($prd_download_available_count) && $prd_download_available_count > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($prd_download_available_count, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($prd_download_available_count) && $prd_download_available_count < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($prd_download_available_count, true)), __LINE__);
        }
        if (is_null($prd_download_available_count) || (is_array($prd_download_available_count) && empty($prd_download_available_count))) {
            unset($this->prd_download_available_count);
        } else {
            $this->prd_download_available_count = $prd_download_available_count;
        }
        
        return $this;
    }
    /**
     * Get prd_cct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_cct_key(): ?string
    {
        return $this->prd_cct_key ?? null;
    }
    /**
     * Set prd_cct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_cct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_cct_key(?string $prd_cct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_cct_key) && !is_string($prd_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_cct_key, true), gettype($prd_cct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prd_cct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prd_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prd_cct_key, true)), __LINE__);
        }
        if (is_null($prd_cct_key) || (is_array($prd_cct_key) && empty($prd_cct_key))) {
            unset($this->prd_cct_key);
        } else {
            $this->prd_cct_key = $prd_cct_key;
        }
        
        return $this;
    }
    /**
     * Get prd_pts_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_pts_key(): ?string
    {
        return $this->prd_pts_key ?? null;
    }
    /**
     * Set prd_pts_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_pts_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_pts_key(?string $prd_pts_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_pts_key) && !is_string($prd_pts_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_pts_key, true), gettype($prd_pts_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prd_pts_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prd_pts_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prd_pts_key, true)), __LINE__);
        }
        if (is_null($prd_pts_key) || (is_array($prd_pts_key) && empty($prd_pts_key))) {
            unset($this->prd_pts_key);
        } else {
            $this->prd_pts_key = $prd_pts_key;
        }
        
        return $this;
    }
    /**
     * Get prd_cmo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_cmo_key(): ?string
    {
        return $this->prd_cmo_key ?? null;
    }
    /**
     * Set prd_cmo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_cmo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_cmo_key(?string $prd_cmo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_cmo_key) && !is_string($prd_cmo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_cmo_key, true), gettype($prd_cmo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prd_cmo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prd_cmo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prd_cmo_key, true)), __LINE__);
        }
        if (is_null($prd_cmo_key) || (is_array($prd_cmo_key) && empty($prd_cmo_key))) {
            unset($this->prd_cmo_key);
        } else {
            $this->prd_cmo_key = $prd_cmo_key;
        }
        
        return $this;
    }
    /**
     * Get prd_out_of_stock_override_message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_out_of_stock_override_message(): ?string
    {
        return $this->prd_out_of_stock_override_message ?? null;
    }
    /**
     * Set prd_out_of_stock_override_message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_out_of_stock_override_message
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_out_of_stock_override_message(?string $prd_out_of_stock_override_message = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_out_of_stock_override_message) && !is_string($prd_out_of_stock_override_message)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_out_of_stock_override_message, true), gettype($prd_out_of_stock_override_message)), __LINE__);
        }
        if (is_null($prd_out_of_stock_override_message) || (is_array($prd_out_of_stock_override_message) && empty($prd_out_of_stock_override_message))) {
            unset($this->prd_out_of_stock_override_message);
        } else {
            $this->prd_out_of_stock_override_message = $prd_out_of_stock_override_message;
        }
        
        return $this;
    }
    /**
     * Get prd_pst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_pst_key(): ?string
    {
        return $this->prd_pst_key ?? null;
    }
    /**
     * Set prd_pst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_pst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_pst_key(?string $prd_pst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_pst_key) && !is_string($prd_pst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_pst_key, true), gettype($prd_pst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prd_pst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prd_pst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prd_pst_key, true)), __LINE__);
        }
        if (is_null($prd_pst_key) || (is_array($prd_pst_key) && empty($prd_pst_key))) {
            unset($this->prd_pst_key);
        } else {
            $this->prd_pst_key = $prd_pst_key;
        }
        
        return $this;
    }
    /**
     * Get prd_pcr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_pcr_key(): ?string
    {
        return $this->prd_pcr_key ?? null;
    }
    /**
     * Set prd_pcr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_pcr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_pcr_key(?string $prd_pcr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_pcr_key) && !is_string($prd_pcr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_pcr_key, true), gettype($prd_pcr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prd_pcr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prd_pcr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prd_pcr_key, true)), __LINE__);
        }
        if (is_null($prd_pcr_key) || (is_array($prd_pcr_key) && empty($prd_pcr_key))) {
            unset($this->prd_pcr_key);
        } else {
            $this->prd_pcr_key = $prd_pcr_key;
        }
        
        return $this;
    }
    /**
     * Get prd_display_product_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_display_product_name(): ?string
    {
        return $this->prd_display_product_name ?? null;
    }
    /**
     * Set prd_display_product_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_display_product_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_display_product_name(?string $prd_display_product_name = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_display_product_name) && !is_string($prd_display_product_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_display_product_name, true), gettype($prd_display_product_name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($prd_display_product_name) && mb_strlen((string) $prd_display_product_name) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $prd_display_product_name)), __LINE__);
        }
        if (is_null($prd_display_product_name) || (is_array($prd_display_product_name) && empty($prd_display_product_name))) {
            unset($this->prd_display_product_name);
        } else {
            $this->prd_display_product_name = $prd_display_product_name;
        }
        
        return $this;
    }
    /**
     * Get prd_display_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrd_display_prd_key(): ?string
    {
        return $this->prd_display_prd_key ?? null;
    }
    /**
     * Set prd_display_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prd_display_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Product_DataObjectType
     */
    public function setPrd_display_prd_key(?string $prd_display_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prd_display_prd_key) && !is_string($prd_display_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prd_display_prd_key, true), gettype($prd_display_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prd_display_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prd_display_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prd_display_prd_key, true)), __LINE__);
        }
        if (is_null($prd_display_prd_key) || (is_array($prd_display_prd_key) && empty($prd_display_prd_key))) {
            unset($this->prd_display_prd_key);
        } else {
            $this->prd_display_prd_key = $prd_display_prd_key;
        }
        
        return $this;
    }
}
