<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MembershipCollectionType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class MembershipCollectionType extends AbstractStructBase
{
    /**
     * The mb_membership
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType[]
     */
    protected ?array $mb_membership = null;
    /**
     * Constructor method for MembershipCollectionType
     * @uses MembershipCollectionType::setMb_membership()
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType[] $mb_membership
     */
    public function __construct(?array $mb_membership = null)
    {
        $this
            ->setMb_membership($mb_membership);
    }
    /**
     * Get mb_membership value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType[]
     */
    public function getMb_membership(): ?array
    {
        return $this->mb_membership;
    }
    /**
     * This method is responsible for validating the value(s) passed to the setMb_membership method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMb_membership method
     * This has to validate that each item contained by the array match the itemType constraint
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMb_membershipForArrayConstraintFromSetMb_membership(?array $values = []): string
    {
        if (!is_array($values)) {
            return '';
        }
        $message = '';
        $invalidValues = [];
        foreach ($values as $membershipCollectionTypeMb_membershipItem) {
            // validation for constraint: itemType
            if (!$membershipCollectionTypeMb_membershipItem instanceof \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType) {
                $invalidValues[] = is_object($membershipCollectionTypeMb_membershipItem) ? get_class($membershipCollectionTypeMb_membershipItem) : sprintf('%s(%s)', gettype($membershipCollectionTypeMb_membershipItem), var_export($membershipCollectionTypeMb_membershipItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The mb_membership property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        
        return $message;
    }
    /**
     * Set mb_membership value
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType[] $mb_membership
     * @return \Drupal\netforum\xWeb\Generated\StructType\MembershipCollectionType
     */
    public function setMb_membership(?array $mb_membership = null): self
    {
        // validation for constraint: array
        if ('' !== ($mb_membershipArrayErrorMessage = self::validateMb_membershipForArrayConstraintFromSetMb_membership($mb_membership))) {
            throw new InvalidArgumentException($mb_membershipArrayErrorMessage, __LINE__);
        }
        $this->mb_membership = $mb_membership;
        
        return $this;
    }
    /**
     * Add item to mb_membership value
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType $item
     * @return \Drupal\netforum\xWeb\Generated\StructType\MembershipCollectionType
     */
    public function addToMb_membership(\Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType $item): self
    {
        // validation for constraint: itemType
        if (!$item instanceof \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType) {
            throw new InvalidArgumentException(sprintf('The mb_membership property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\Mb_membershipType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->mb_membership[] = $item;
        
        return $this;
    }
}
