<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MetaDataGetFormControlForFacadeObject StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class MetaDataGetFormControlForFacadeObject extends AbstractStructBase
{
    /**
     * The FormKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $FormKey;
    /**
     * The controlName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $controlName = null;
    /**
     * The oNode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\StructType\ONode|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ONode $oNode = null;
    /**
     * Constructor method for MetaDataGetFormControlForFacadeObject
     * @uses MetaDataGetFormControlForFacadeObject::setFormKey()
     * @uses MetaDataGetFormControlForFacadeObject::setControlName()
     * @uses MetaDataGetFormControlForFacadeObject::setONode()
     * @param string $formKey
     * @param string $controlName
     * @param \Drupal\netforum\xWeb\Generated\StructType\ONode $oNode
     */
    public function __construct(string $formKey, ?string $controlName = null, ?\Drupal\netforum\xWeb\Generated\StructType\ONode $oNode = null)
    {
        $this
            ->setFormKey($formKey)
            ->setControlName($controlName)
            ->setONode($oNode);
    }
    /**
     * Get FormKey value
     * @return string
     */
    public function getFormKey(): string
    {
        return $this->FormKey;
    }
    /**
     * Set FormKey value
     * @param string $formKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\MetaDataGetFormControlForFacadeObject
     */
    public function setFormKey(string $formKey): self
    {
        // validation for constraint: string
        if (!is_null($formKey) && !is_string($formKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formKey, true), gettype($formKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($formKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $formKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($formKey, true)), __LINE__);
        }
        $this->FormKey = $formKey;
        
        return $this;
    }
    /**
     * Get controlName value
     * @return string|null
     */
    public function getControlName(): ?string
    {
        return $this->controlName;
    }
    /**
     * Set controlName value
     * @param string $controlName
     * @return \Drupal\netforum\xWeb\Generated\StructType\MetaDataGetFormControlForFacadeObject
     */
    public function setControlName(?string $controlName = null): self
    {
        // validation for constraint: string
        if (!is_null($controlName) && !is_string($controlName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($controlName, true), gettype($controlName)), __LINE__);
        }
        $this->controlName = $controlName;
        
        return $this;
    }
    /**
     * Get oNode value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ONode|null
     */
    public function getONode(): ?\Drupal\netforum\xWeb\Generated\StructType\ONode
    {
        return $this->oNode;
    }
    /**
     * Set oNode value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ONode $oNode
     * @return \Drupal\netforum\xWeb\Generated\StructType\MetaDataGetFormControlForFacadeObject
     */
    public function setONode(?\Drupal\netforum\xWeb\Generated\StructType\ONode $oNode = null): self
    {
        $this->oNode = $oNode;
        
        return $this;
    }
}
