<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MetaDataGetFormForIndividual StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class MetaDataGetFormForIndividual extends AbstractStructBase
{
    /**
     * The FormKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $FormKey;
    /**
     * The oFacadeObject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\StructType\IndividualType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\IndividualType $oFacadeObject = null;
    /**
     * Constructor method for MetaDataGetFormForIndividual
     * @uses MetaDataGetFormForIndividual::setFormKey()
     * @uses MetaDataGetFormForIndividual::setOFacadeObject()
     * @param string $formKey
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualType $oFacadeObject
     */
    public function __construct(string $formKey, ?\Drupal\netforum\xWeb\Generated\StructType\IndividualType $oFacadeObject = null)
    {
        $this
            ->setFormKey($formKey)
            ->setOFacadeObject($oFacadeObject);
    }
    /**
     * Get FormKey value
     * @return string
     */
    public function getFormKey(): string
    {
        return $this->FormKey;
    }
    /**
     * Set FormKey value
     * @param string $formKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\MetaDataGetFormForIndividual
     */
    public function setFormKey(string $formKey): self
    {
        // validation for constraint: string
        if (!is_null($formKey) && !is_string($formKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formKey, true), gettype($formKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($formKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $formKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($formKey, true)), __LINE__);
        }
        $this->FormKey = $formKey;
        
        return $this;
    }
    /**
     * Get oFacadeObject value
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType|null
     */
    public function getOFacadeObject(): ?\Drupal\netforum\xWeb\Generated\StructType\IndividualType
    {
        return $this->oFacadeObject;
    }
    /**
     * Set oFacadeObject value
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualType $oFacadeObject
     * @return \Drupal\netforum\xWeb\Generated\StructType\MetaDataGetFormForIndividual
     */
    public function setOFacadeObject(?\Drupal\netforum\xWeb\Generated\StructType\IndividualType $oFacadeObject = null): self
    {
        $this->oFacadeObject = $oFacadeObject;
        
        return $this;
    }
}
