<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MetaDataGetWizardForm StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class MetaDataGetWizardForm extends AbstractStructBase
{
    /**
     * The WizardFormKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $WizardFormKey;
    /**
     * The oNode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\StructType\ONode|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ONode $oNode = null;
    /**
     * The szObjectName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string|null
     */
    protected ?string $szObjectName;
    /**
     * Constructor method for MetaDataGetWizardForm
     * @uses MetaDataGetWizardForm::setWizardFormKey()
     * @uses MetaDataGetWizardForm::setONode()
     * @uses MetaDataGetWizardForm::setSzObjectName()
     * @param string $wizardFormKey
     * @param \Drupal\netforum\xWeb\Generated\StructType\ONode $oNode
     * @param string $szObjectName
     */
    public function __construct(string $wizardFormKey, ?\Drupal\netforum\xWeb\Generated\StructType\ONode $oNode = null, ?string $szObjectName)
    {
        $this
            ->setWizardFormKey($wizardFormKey)
            ->setONode($oNode)
            ->setSzObjectName($szObjectName);
    }
    /**
     * Get WizardFormKey value
     * @return string
     */
    public function getWizardFormKey(): string
    {
        return $this->WizardFormKey;
    }
    /**
     * Set WizardFormKey value
     * @param string $wizardFormKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\MetaDataGetWizardForm
     */
    public function setWizardFormKey(string $wizardFormKey): self
    {
        // validation for constraint: string
        if (!is_null($wizardFormKey) && !is_string($wizardFormKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wizardFormKey, true), gettype($wizardFormKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($wizardFormKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $wizardFormKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($wizardFormKey, true)), __LINE__);
        }
        $this->WizardFormKey = $wizardFormKey;
        
        return $this;
    }
    /**
     * Get oNode value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ONode|null
     */
    public function getONode(): ?\Drupal\netforum\xWeb\Generated\StructType\ONode
    {
        return $this->oNode;
    }
    /**
     * Set oNode value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ONode $oNode
     * @return \Drupal\netforum\xWeb\Generated\StructType\MetaDataGetWizardForm
     */
    public function setONode(?\Drupal\netforum\xWeb\Generated\StructType\ONode $oNode = null): self
    {
        $this->oNode = $oNode;
        
        return $this;
    }
    /**
     * Get szObjectName value
     * @return string|null
     */
    public function getSzObjectName(): ?string
    {
        return $this->szObjectName;
    }
    /**
     * Set szObjectName value
     * @param string $szObjectName
     * @return \Drupal\netforum\xWeb\Generated\StructType\MetaDataGetWizardForm
     */
    public function setSzObjectName(?string $szObjectName): self
    {
        // validation for constraint: string
        if (!is_null($szObjectName) && !is_string($szObjectName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($szObjectName, true), gettype($szObjectName)), __LINE__);
        }
        $this->szObjectName = $szObjectName;
        
        return $this;
    }
}
