<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModuleResult StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ModuleResult extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    protected string $Status;
    /**
     * The Module
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $Module = null;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $ErrorMessage = null;
    /**
     * Constructor method for ModuleResult
     * @uses ModuleResult::setStatus()
     * @uses ModuleResult::setModule()
     * @uses ModuleResult::setErrorMessage()
     * @param string $status
     * @param string $module
     * @param string $errorMessage
     */
    public function __construct(string $status, ?string $module = null, ?string $errorMessage = null)
    {
        $this
            ->setStatus($status)
            ->setModule($module)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus(): string
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \Drupal\netforum\xWeb\Generated\EnumType\MergeResult::valueIsValid()
     * @uses \Drupal\netforum\xWeb\Generated\EnumType\MergeResult::getValidValues()
     * @throws InvalidArgumentException
     * @param string $status
     * @return \Drupal\netforum\xWeb\Generated\StructType\ModuleResult
     */
    public function setStatus(string $status): self
    {
        // validation for constraint: enumeration
        if (!\Drupal\netforum\xWeb\Generated\EnumType\MergeResult::valueIsValid($status)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Drupal\netforum\xWeb\Generated\EnumType\MergeResult', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \Drupal\netforum\xWeb\Generated\EnumType\MergeResult::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        
        return $this;
    }
    /**
     * Get Module value
     * @return string|null
     */
    public function getModule(): ?string
    {
        return $this->Module;
    }
    /**
     * Set Module value
     * @param string $module
     * @return \Drupal\netforum\xWeb\Generated\StructType\ModuleResult
     */
    public function setModule(?string $module = null): self
    {
        // validation for constraint: string
        if (!is_null($module) && !is_string($module)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($module, true), gettype($module)), __LINE__);
        }
        $this->Module = $module;
        
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage(): ?string
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \Drupal\netforum\xWeb\Generated\StructType\ModuleResult
     */
    public function setErrorMessage(?string $errorMessage = null): self
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        
        return $this;
    }
}
