<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrganizationType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class OrganizationType extends AbstractStructBase
{
    /**
     * The Organization
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Organization_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Organization_DataObjectType $Organization = null;
    /**
     * The Customer
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Customer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Customer_DataObjectType $Customer = null;
    /**
     * The Parent_Customer
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Parent_Customer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Parent_Customer_DataObjectType $Parent_Customer = null;
    /**
     * The Email
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Email_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Email_DataObjectType $Email = null;
    /**
     * The Website
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Website_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Website_DataObjectType $Website = null;
    /**
     * The Messaging
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Messaging_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Messaging_DataObjectType $Messaging = null;
    /**
     * The Phone_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_XRef_DataObjectType $Phone_XRef = null;
    /**
     * The Phone
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_DataObjectType $Phone = null;
    /**
     * The Phone_Country
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_Country_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_Country_DataObjectType $Phone_Country = null;
    /**
     * The Fax_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_XRef_DataObjectType $Fax_XRef = null;
    /**
     * The Fax
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_DataObjectType $Fax = null;
    /**
     * The Fax_Country
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_Country_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_Country_DataObjectType $Fax_Country = null;
    /**
     * The Address_XRef_1
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Address_XRef_1_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Address_XRef_1_DataObjectType $Address_XRef_1 = null;
    /**
     * The Address_1
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Address_1_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Address_1_DataObjectType $Address_1 = null;
    /**
     * The Business_Address_State
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType $Business_Address_State = null;
    /**
     * The Address_1_Country
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Address_1_Country_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Address_1_Country_DataObjectType $Address_1_Country = null;
    /**
     * The Billing_Address_1
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType $Billing_Address_1 = null;
    /**
     * The Home_Address_State
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType $Home_Address_State = null;
    /**
     * The Billing_Address_1_Country
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_Country_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_Country_DataObjectType $Billing_Address_1_Country = null;
    /**
     * The Billing_Address_XRef_1
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_XRef_1_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_XRef_1_DataObjectType $Billing_Address_XRef_1 = null;
    /**
     * The Customer_X_Customer
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Customer_X_Customer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Customer_X_Customer_DataObjectType $Customer_X_Customer = null;
    /**
     * The Primary_Contact
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Primary_Contact_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Primary_Contact_DataObjectType $Primary_Contact = null;
    /**
     * The Address_Change_Log
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Address_Change_Log_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Address_Change_Log_DataObjectType $Address_Change_Log = null;
    /**
     * The Organization_Custom_Demographics
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Organization_Custom_Demographics_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Organization_Custom_Demographics_DataObjectType $Organization_Custom_Demographics = null;
    /**
     * The Social_Links
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType $Social_Links = null;
    /**
     * The source_code
     * @var \Drupal\netforum\xWeb\Generated\StructType\Organization_source_code_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Organization_source_code_DataObjectType $source_code = null;
    /**
     * The CurrentKey
     * Meta information extracted from the WSDL
     * - documentation: Organization Key.The current key is the record key for the object. This field must be set whenever updating an existing database record. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $CurrentKey = null;
    /**
     * Constructor method for OrganizationType
     * @uses OrganizationType::setOrganization()
     * @uses OrganizationType::setCustomer()
     * @uses OrganizationType::setParent_Customer()
     * @uses OrganizationType::setEmail()
     * @uses OrganizationType::setWebsite()
     * @uses OrganizationType::setMessaging()
     * @uses OrganizationType::setPhone_XRef()
     * @uses OrganizationType::setPhone()
     * @uses OrganizationType::setPhone_Country()
     * @uses OrganizationType::setFax_XRef()
     * @uses OrganizationType::setFax()
     * @uses OrganizationType::setFax_Country()
     * @uses OrganizationType::setAddress_XRef_1()
     * @uses OrganizationType::setAddress_1()
     * @uses OrganizationType::setBusiness_Address_State()
     * @uses OrganizationType::setAddress_1_Country()
     * @uses OrganizationType::setBilling_Address_1()
     * @uses OrganizationType::setHome_Address_State()
     * @uses OrganizationType::setBilling_Address_1_Country()
     * @uses OrganizationType::setBilling_Address_XRef_1()
     * @uses OrganizationType::setCustomer_X_Customer()
     * @uses OrganizationType::setPrimary_Contact()
     * @uses OrganizationType::setAddress_Change_Log()
     * @uses OrganizationType::setOrganization_Custom_Demographics()
     * @uses OrganizationType::setSocial_Links()
     * @uses OrganizationType::setSource_code()
     * @uses OrganizationType::setCurrentKey()
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Organization_DataObjectType $organization
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Customer_DataObjectType $customer
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Parent_Customer_DataObjectType $parent_Customer
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Email_DataObjectType $email
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Website_DataObjectType $website
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Messaging_DataObjectType $messaging
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_XRef_DataObjectType $phone_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_DataObjectType $phone
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_Country_DataObjectType $phone_Country
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_XRef_DataObjectType $fax_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_DataObjectType $fax
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_Country_DataObjectType $fax_Country
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Address_XRef_1_DataObjectType $address_XRef_1
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Address_1_DataObjectType $address_1
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType $business_Address_State
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Address_1_Country_DataObjectType $address_1_Country
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType $billing_Address_1
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType $home_Address_State
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_Country_DataObjectType $billing_Address_1_Country
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_XRef_1_DataObjectType $billing_Address_XRef_1
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Customer_X_Customer_DataObjectType $customer_X_Customer
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Primary_Contact_DataObjectType $primary_Contact
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Address_Change_Log_DataObjectType $address_Change_Log
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Organization_Custom_Demographics_DataObjectType $organization_Custom_Demographics
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType $social_Links
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_source_code_DataObjectType $source_code
     * @param string $currentKey
     */
    public function __construct(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Organization_DataObjectType $organization = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Customer_DataObjectType $customer = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Parent_Customer_DataObjectType $parent_Customer = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Email_DataObjectType $email = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Website_DataObjectType $website = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Messaging_DataObjectType $messaging = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_XRef_DataObjectType $phone_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_DataObjectType $phone = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_Country_DataObjectType $phone_Country = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_XRef_DataObjectType $fax_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_DataObjectType $fax = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_Country_DataObjectType $fax_Country = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Address_XRef_1_DataObjectType $address_XRef_1 = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Address_1_DataObjectType $address_1 = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType $business_Address_State = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Address_1_Country_DataObjectType $address_1_Country = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType $billing_Address_1 = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType $home_Address_State = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_Country_DataObjectType $billing_Address_1_Country = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_XRef_1_DataObjectType $billing_Address_XRef_1 = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Customer_X_Customer_DataObjectType $customer_X_Customer = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Primary_Contact_DataObjectType $primary_Contact = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Address_Change_Log_DataObjectType $address_Change_Log = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Organization_Custom_Demographics_DataObjectType $organization_Custom_Demographics = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType $social_Links = null, ?\Drupal\netforum\xWeb\Generated\StructType\Organization_source_code_DataObjectType $source_code = null, ?string $currentKey = null)
    {
        $this
            ->setOrganization($organization)
            ->setCustomer($customer)
            ->setParent_Customer($parent_Customer)
            ->setEmail($email)
            ->setWebsite($website)
            ->setMessaging($messaging)
            ->setPhone_XRef($phone_XRef)
            ->setPhone($phone)
            ->setPhone_Country($phone_Country)
            ->setFax_XRef($fax_XRef)
            ->setFax($fax)
            ->setFax_Country($fax_Country)
            ->setAddress_XRef_1($address_XRef_1)
            ->setAddress_1($address_1)
            ->setBusiness_Address_State($business_Address_State)
            ->setAddress_1_Country($address_1_Country)
            ->setBilling_Address_1($billing_Address_1)
            ->setHome_Address_State($home_Address_State)
            ->setBilling_Address_1_Country($billing_Address_1_Country)
            ->setBilling_Address_XRef_1($billing_Address_XRef_1)
            ->setCustomer_X_Customer($customer_X_Customer)
            ->setPrimary_Contact($primary_Contact)
            ->setAddress_Change_Log($address_Change_Log)
            ->setOrganization_Custom_Demographics($organization_Custom_Demographics)
            ->setSocial_Links($social_Links)
            ->setSource_code($source_code)
            ->setCurrentKey($currentKey);
    }
    /**
     * Get Organization value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Organization_DataObjectType|null
     */
    public function getOrganization(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Organization_DataObjectType
    {
        return $this->Organization;
    }
    /**
     * Set Organization value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Organization_DataObjectType $organization
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setOrganization(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Organization_DataObjectType $organization = null): self
    {
        $this->Organization = $organization;
        
        return $this;
    }
    /**
     * Get Customer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Customer_DataObjectType|null
     */
    public function getCustomer(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Customer_DataObjectType
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Customer_DataObjectType $customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setCustomer(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Customer_DataObjectType $customer = null): self
    {
        $this->Customer = $customer;
        
        return $this;
    }
    /**
     * Get Parent_Customer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Parent_Customer_DataObjectType|null
     */
    public function getParent_Customer(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Parent_Customer_DataObjectType
    {
        return $this->Parent_Customer;
    }
    /**
     * Set Parent_Customer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Parent_Customer_DataObjectType $parent_Customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setParent_Customer(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Parent_Customer_DataObjectType $parent_Customer = null): self
    {
        $this->Parent_Customer = $parent_Customer;
        
        return $this;
    }
    /**
     * Get Email value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Email_DataObjectType|null
     */
    public function getEmail(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Email_DataObjectType
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Email_DataObjectType $email
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setEmail(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Email_DataObjectType $email = null): self
    {
        $this->Email = $email;
        
        return $this;
    }
    /**
     * Get Website value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Website_DataObjectType|null
     */
    public function getWebsite(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Website_DataObjectType
    {
        return $this->Website;
    }
    /**
     * Set Website value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Website_DataObjectType $website
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setWebsite(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Website_DataObjectType $website = null): self
    {
        $this->Website = $website;
        
        return $this;
    }
    /**
     * Get Messaging value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Messaging_DataObjectType|null
     */
    public function getMessaging(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Messaging_DataObjectType
    {
        return $this->Messaging;
    }
    /**
     * Set Messaging value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Messaging_DataObjectType $messaging
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setMessaging(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Messaging_DataObjectType $messaging = null): self
    {
        $this->Messaging = $messaging;
        
        return $this;
    }
    /**
     * Get Phone_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_XRef_DataObjectType|null
     */
    public function getPhone_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_XRef_DataObjectType
    {
        return $this->Phone_XRef;
    }
    /**
     * Set Phone_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_XRef_DataObjectType $phone_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setPhone_XRef(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_XRef_DataObjectType $phone_XRef = null): self
    {
        $this->Phone_XRef = $phone_XRef;
        
        return $this;
    }
    /**
     * Get Phone value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_DataObjectType|null
     */
    public function getPhone(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_DataObjectType
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_DataObjectType $phone
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setPhone(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_DataObjectType $phone = null): self
    {
        $this->Phone = $phone;
        
        return $this;
    }
    /**
     * Get Phone_Country value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_Country_DataObjectType|null
     */
    public function getPhone_Country(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_Country_DataObjectType
    {
        return $this->Phone_Country;
    }
    /**
     * Set Phone_Country value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_Country_DataObjectType $phone_Country
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setPhone_Country(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Phone_Country_DataObjectType $phone_Country = null): self
    {
        $this->Phone_Country = $phone_Country;
        
        return $this;
    }
    /**
     * Get Fax_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_XRef_DataObjectType|null
     */
    public function getFax_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_XRef_DataObjectType
    {
        return $this->Fax_XRef;
    }
    /**
     * Set Fax_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_XRef_DataObjectType $fax_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setFax_XRef(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_XRef_DataObjectType $fax_XRef = null): self
    {
        $this->Fax_XRef = $fax_XRef;
        
        return $this;
    }
    /**
     * Get Fax value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_DataObjectType|null
     */
    public function getFax(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_DataObjectType
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_DataObjectType $fax
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setFax(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_DataObjectType $fax = null): self
    {
        $this->Fax = $fax;
        
        return $this;
    }
    /**
     * Get Fax_Country value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_Country_DataObjectType|null
     */
    public function getFax_Country(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_Country_DataObjectType
    {
        return $this->Fax_Country;
    }
    /**
     * Set Fax_Country value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_Country_DataObjectType $fax_Country
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setFax_Country(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Fax_Country_DataObjectType $fax_Country = null): self
    {
        $this->Fax_Country = $fax_Country;
        
        return $this;
    }
    /**
     * Get address_XRef value
     * @return address_XRef
     */
    public function getAddress_XRef_1(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Address_XRef_1_DataObjectType
    {
        return $this->Address_XRef_1;
    }
    /**
     * Set address_XRef value
     * @param address_XRef $address_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setAddress_XRef_1(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Address_XRef_1_DataObjectType $address_XRef_1 = null): self
    {
        $this->Address_XRef_1 = $address_XRef_1;
        
        return $this;
    }
    /**
     * Get address value
     * @return address
     */
    public function getAddress_1(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Address_1_DataObjectType
    {
        return $this->Address_1;
    }
    /**
     * Set address value
     * @param address $address
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setAddress_1(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Address_1_DataObjectType $address_1 = null): self
    {
        $this->Address_1 = $address_1;
        
        return $this;
    }
    /**
     * Get Business_Address_State value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType|null
     */
    public function getBusiness_Address_State(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType
    {
        return $this->Business_Address_State;
    }
    /**
     * Set Business_Address_State value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType $business_Address_State
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setBusiness_Address_State(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType $business_Address_State = null): self
    {
        $this->Business_Address_State = $business_Address_State;
        
        return $this;
    }
    /**
     * Get address_Country value
     * @return address_Country
     */
    public function getAddress_1_Country(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Address_1_Country_DataObjectType
    {
        return $this->Address_1_Country;
    }
    /**
     * Set address_Country value
     * @param address_Country $address_Country
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setAddress_1_Country(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Address_1_Country_DataObjectType $address_1_Country = null): self
    {
        $this->Address_1_Country = $address_1_Country;
        
        return $this;
    }
    /**
     * Get billing_Address value
     * @return billing_Address
     */
    public function getBilling_Address_1(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
    {
        return $this->Billing_Address_1;
    }
    /**
     * Set billing_Address value
     * @param billing_Address $billing_Address
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setBilling_Address_1(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType $billing_Address_1 = null): self
    {
        $this->Billing_Address_1 = $billing_Address_1;
        
        return $this;
    }
    /**
     * Get Home_Address_State value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType|null
     */
    public function getHome_Address_State(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType
    {
        return $this->Home_Address_State;
    }
    /**
     * Set Home_Address_State value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType $home_Address_State
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setHome_Address_State(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType $home_Address_State = null): self
    {
        $this->Home_Address_State = $home_Address_State;
        
        return $this;
    }
    /**
     * Get billing_Address_Country value
     * @return billing_Address_Country
     */
    public function getBilling_Address_1_Country(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_Country_DataObjectType
    {
        return $this->Billing_Address_1_Country;
    }
    /**
     * Set billing_Address_Country value
     * @param billing_Address_Country $billing_Address_Country
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setBilling_Address_1_Country(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_Country_DataObjectType $billing_Address_1_Country = null): self
    {
        $this->Billing_Address_1_Country = $billing_Address_1_Country;
        
        return $this;
    }
    /**
     * Get billing_Address_XRef value
     * @return billing_Address_XRef
     */
    public function getBilling_Address_XRef_1(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_XRef_1_DataObjectType
    {
        return $this->Billing_Address_XRef_1;
    }
    /**
     * Set billing_Address_XRef value
     * @param billing_Address_XRef $billing_Address_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setBilling_Address_XRef_1(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_XRef_1_DataObjectType $billing_Address_XRef_1 = null): self
    {
        $this->Billing_Address_XRef_1 = $billing_Address_XRef_1;
        
        return $this;
    }
    /**
     * Get Customer_X_Customer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Customer_X_Customer_DataObjectType|null
     */
    public function getCustomer_X_Customer(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Customer_X_Customer_DataObjectType
    {
        return $this->Customer_X_Customer;
    }
    /**
     * Set Customer_X_Customer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Customer_X_Customer_DataObjectType $customer_X_Customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setCustomer_X_Customer(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Customer_X_Customer_DataObjectType $customer_X_Customer = null): self
    {
        $this->Customer_X_Customer = $customer_X_Customer;
        
        return $this;
    }
    /**
     * Get Primary_Contact value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Primary_Contact_DataObjectType|null
     */
    public function getPrimary_Contact(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Primary_Contact_DataObjectType
    {
        return $this->Primary_Contact;
    }
    /**
     * Set Primary_Contact value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Primary_Contact_DataObjectType $primary_Contact
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setPrimary_Contact(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Primary_Contact_DataObjectType $primary_Contact = null): self
    {
        $this->Primary_Contact = $primary_Contact;
        
        return $this;
    }
    /**
     * Get Address_Change_Log value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Address_Change_Log_DataObjectType|null
     */
    public function getAddress_Change_Log(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Address_Change_Log_DataObjectType
    {
        return $this->Address_Change_Log;
    }
    /**
     * Set Address_Change_Log value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Address_Change_Log_DataObjectType $address_Change_Log
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setAddress_Change_Log(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Address_Change_Log_DataObjectType $address_Change_Log = null): self
    {
        $this->Address_Change_Log = $address_Change_Log;
        
        return $this;
    }
    /**
     * Get Organization_Custom_Demographics value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Organization_Custom_Demographics_DataObjectType|null
     */
    public function getOrganization_Custom_Demographics(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Organization_Custom_Demographics_DataObjectType
    {
        return $this->Organization_Custom_Demographics;
    }
    /**
     * Set Organization_Custom_Demographics value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Organization_Custom_Demographics_DataObjectType $organization_Custom_Demographics
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setOrganization_Custom_Demographics(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Organization_Custom_Demographics_DataObjectType $organization_Custom_Demographics = null): self
    {
        $this->Organization_Custom_Demographics = $organization_Custom_Demographics;
        
        return $this;
    }
    /**
     * Get Social_Links value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType|null
     */
    public function getSocial_Links(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
    {
        return $this->Social_Links;
    }
    /**
     * Set Social_Links value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType $social_Links
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setSocial_Links(?\Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType $social_Links = null): self
    {
        $this->Social_Links = $social_Links;
        
        return $this;
    }
    /**
     * Get source_code value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_source_code_DataObjectType|null
     */
    public function getSource_code(): ?\Drupal\netforum\xWeb\Generated\StructType\Organization_source_code_DataObjectType
    {
        return $this->source_code;
    }
    /**
     * Set source_code value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Organization_source_code_DataObjectType $source_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setSource_code(?\Drupal\netforum\xWeb\Generated\StructType\Organization_source_code_DataObjectType $source_code = null): self
    {
        $this->source_code = $source_code;
        
        return $this;
    }
    /**
     * Get CurrentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentKey(): ?string
    {
        return $this->CurrentKey ?? null;
    }
    /**
     * Set CurrentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\OrganizationType
     */
    public function setCurrentKey(?string $currentKey = null): self
    {
        // validation for constraint: string
        if (!is_null($currentKey) && !is_string($currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentKey, true), gettype($currentKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($currentKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($currentKey, true)), __LINE__);
        }
        if (is_null($currentKey) || (is_array($currentKey) && empty($currentKey))) {
            unset($this->CurrentKey);
        } else {
            $this->CurrentKey = $currentKey;
        }
        
        return $this;
    }
}
