<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Organization_Billing_Address_1_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Organization_Billing_Address_1_DataObjectType extends AbstractStructBase
{
    /**
     * The ad2__adr_key
     * Meta information extracted from the WSDL
     * - documentation: Address Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ad2__adr_key = null;
    /**
     * The ad2__adr_cst_key_owner
     * Meta information extracted from the WSDL
     * - documentation: Address Owner. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ad2__adr_cst_key_owner = null;
    /**
     * The ad2__adr_line1
     * Meta information extracted from the WSDL
     * - documentation: Address Line 1. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_line1 = null;
    /**
     * The ad2__adr_line2
     * Meta information extracted from the WSDL
     * - documentation: Address Line 2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_line2 = null;
    /**
     * The ad2__adr_line3
     * Meta information extracted from the WSDL
     * - documentation: Address Line 3. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_line3 = null;
    /**
     * The ad2__adr_city
     * Meta information extracted from the WSDL
     * - documentation: City. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_city = null;
    /**
     * The ad2__adr_state
     * Meta information extracted from the WSDL
     * - documentation: State/Territory.This element has a default value of 'NULL'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_state = null;
    /**
     * The ad2__adr_post_code
     * Meta information extracted from the WSDL
     * - documentation: Postal Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_post_code = null;
    /**
     * The ad2__adr_city_state_code
     * Meta information extracted from the WSDL
     * - documentation: City, State, Post Code. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 104
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_city_state_code = null;
    /**
     * The ad2__adr_country
     * Meta information extracted from the WSDL
     * - documentation: Country.This element has a default value of 'UNITED STATES'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_country = null;
    /**
     * The ad2__adr_intl_province
     * Meta information extracted from the WSDL
     * - documentation: International Province. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_intl_province = null;
    /**
     * The ad2__adr_county
     * Meta information extracted from the WSDL
     * - documentation: County. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_county = null;
    /**
     * The ad2__adr_cong_dist
     * Meta information extracted from the WSDL
     * - documentation: Congressional District. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_cong_dist = null;
    /**
     * The ad2__adr_state_house
     * Meta information extracted from the WSDL
     * - documentation: State House. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_state_house = null;
    /**
     * The ad2__adr_state_senate
     * Meta information extracted from the WSDL
     * - documentation: State Senate. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_state_senate = null;
    /**
     * The ad2__adr_latitude
     * Meta information extracted from the WSDL
     * - documentation: Latitude. | Avectra netForum defined simpleType.
     * - base: s:double
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float|null
     */
    protected ?float $ad2__adr_latitude = null;
    /**
     * The ad2__adr_longitude
     * Meta information extracted from the WSDL
     * - documentation: Longitude. | Avectra netForum defined simpleType.
     * - base: s:double
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float|null
     */
    protected ?float $ad2__adr_longitude = null;
    /**
     * The ad2__adr_mailing_label
     * Meta information extracted from the WSDL
     * - documentation: Mailing Label. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 450
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_mailing_label = null;
    /**
     * The ad2__adr_mailing_label_html
     * Meta information extracted from the WSDL
     * - documentation: Mailing Label HTML. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 450
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_mailing_label_html = null;
    /**
     * The ad2__adr_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_add_date = null;
    /**
     * The ad2__adr_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_add_user = null;
    /**
     * The ad2__adr_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_change_date = null;
    /**
     * The ad2__adr_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_change_user = null;
    /**
     * The ad2__adr_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_delete_flag = null;
    /**
     * The ad2__adr_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ad2__adr_key_ext = null;
    /**
     * The ad2__adr_bad_address_flag
     * Meta information extracted from the WSDL
     * - documentation: Bad Address Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_bad_address_flag = null;
    /**
     * The ad2__adr_adb_key
     * Meta information extracted from the WSDL
     * - documentation: Bad Address Type Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ad2__adr_adb_key = null;
    /**
     * The ad2__adr_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ad2__adr_entity_key = null;
    /**
     * The ad2__adr_metro_stat_area
     * Meta information extracted from the WSDL
     * - documentation: Metropolitan Statistical Area. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_metro_stat_area = null;
    /**
     * The ad2__adr_carrier_route
     * Meta information extracted from the WSDL
     * - documentation: Carrier Route. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_carrier_route = null;
    /**
     * The ad2__adr_delivery_point_code
     * Meta information extracted from the WSDL
     * - documentation: Delivery Point Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_delivery_point_code = null;
    /**
     * The ad2__adr_lacs
     * Meta information extracted from the WSDL
     * - documentation: LACS. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_lacs = null;
    /**
     * The ad2__adr_time_zone
     * Meta information extracted from the WSDL
     * - documentation: TimeZone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_time_zone = null;
    /**
     * The ad2__adr_urbanization
     * Meta information extracted from the WSDL
     * - documentation: Urbanization. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_urbanization = null;
    /**
     * The ad2__adr_bar_code
     * Meta information extracted from the WSDL
     * - documentation: BarCode. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_bar_code = null;
    /**
     * The ad2__adr_fips
     * Meta information extracted from the WSDL
     * - documentation: County FIPS Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 5
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_fips = null;
    /**
     * The ad2__adr_no_validation_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Validate. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_no_validation_flag = null;
    /**
     * The ad2__adr_attn
     * Meta information extracted from the WSDL
     * - documentation: Attention. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_attn = null;
    /**
     * The ad2__adr_record_type_code
     * Meta information extracted from the WSDL
     * - documentation: Record Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_record_type_code = null;
    /**
     * The ad2__adr_geography
     * Meta information extracted from the WSDL
     * - documentation: geography datatype. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ad2__adr_geography = null;
    /**
     * Constructor method for Organization_Billing_Address_1_DataObjectType
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_key()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_cst_key_owner()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_line1()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_line2()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_line3()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_city()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_state()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_post_code()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_city_state_code()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_country()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_intl_province()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_county()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_cong_dist()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_state_house()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_state_senate()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_latitude()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_longitude()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_mailing_label()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_mailing_label_html()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_add_date()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_add_user()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_change_date()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_change_user()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_delete_flag()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_key_ext()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_bad_address_flag()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_adb_key()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_entity_key()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_metro_stat_area()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_carrier_route()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_delivery_point_code()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_lacs()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_time_zone()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_urbanization()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_bar_code()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_fips()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_no_validation_flag()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_attn()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_record_type_code()
     * @uses Organization_Billing_Address_1_DataObjectType::setAd2__adr_geography()
     * @param string $ad2__adr_key
     * @param string $ad2__adr_cst_key_owner
     * @param string $ad2__adr_line1
     * @param string $ad2__adr_line2
     * @param string $ad2__adr_line3
     * @param string $ad2__adr_city
     * @param string $ad2__adr_state
     * @param string $ad2__adr_post_code
     * @param string $ad2__adr_city_state_code
     * @param string $ad2__adr_country
     * @param string $ad2__adr_intl_province
     * @param string $ad2__adr_county
     * @param string $ad2__adr_cong_dist
     * @param string $ad2__adr_state_house
     * @param string $ad2__adr_state_senate
     * @param float $ad2__adr_latitude
     * @param float $ad2__adr_longitude
     * @param string $ad2__adr_mailing_label
     * @param string $ad2__adr_mailing_label_html
     * @param string $ad2__adr_add_date
     * @param string $ad2__adr_add_user
     * @param string $ad2__adr_change_date
     * @param string $ad2__adr_change_user
     * @param string $ad2__adr_delete_flag
     * @param string $ad2__adr_key_ext
     * @param string $ad2__adr_bad_address_flag
     * @param string $ad2__adr_adb_key
     * @param string $ad2__adr_entity_key
     * @param string $ad2__adr_metro_stat_area
     * @param string $ad2__adr_carrier_route
     * @param string $ad2__adr_delivery_point_code
     * @param string $ad2__adr_lacs
     * @param string $ad2__adr_time_zone
     * @param string $ad2__adr_urbanization
     * @param string $ad2__adr_bar_code
     * @param string $ad2__adr_fips
     * @param string $ad2__adr_no_validation_flag
     * @param string $ad2__adr_attn
     * @param string $ad2__adr_record_type_code
     * @param string $ad2__adr_geography
     */
    public function __construct(?string $ad2__adr_key = null, ?string $ad2__adr_cst_key_owner = null, ?string $ad2__adr_line1 = null, ?string $ad2__adr_line2 = null, ?string $ad2__adr_line3 = null, ?string $ad2__adr_city = null, ?string $ad2__adr_state = null, ?string $ad2__adr_post_code = null, ?string $ad2__adr_city_state_code = null, ?string $ad2__adr_country = null, ?string $ad2__adr_intl_province = null, ?string $ad2__adr_county = null, ?string $ad2__adr_cong_dist = null, ?string $ad2__adr_state_house = null, ?string $ad2__adr_state_senate = null, ?float $ad2__adr_latitude = null, ?float $ad2__adr_longitude = null, ?string $ad2__adr_mailing_label = null, ?string $ad2__adr_mailing_label_html = null, ?string $ad2__adr_add_date = null, ?string $ad2__adr_add_user = null, ?string $ad2__adr_change_date = null, ?string $ad2__adr_change_user = null, ?string $ad2__adr_delete_flag = null, ?string $ad2__adr_key_ext = null, ?string $ad2__adr_bad_address_flag = null, ?string $ad2__adr_adb_key = null, ?string $ad2__adr_entity_key = null, ?string $ad2__adr_metro_stat_area = null, ?string $ad2__adr_carrier_route = null, ?string $ad2__adr_delivery_point_code = null, ?string $ad2__adr_lacs = null, ?string $ad2__adr_time_zone = null, ?string $ad2__adr_urbanization = null, ?string $ad2__adr_bar_code = null, ?string $ad2__adr_fips = null, ?string $ad2__adr_no_validation_flag = null, ?string $ad2__adr_attn = null, ?string $ad2__adr_record_type_code = null, ?string $ad2__adr_geography = null)
    {
        $this
            ->setAd2__adr_key($ad2__adr_key)
            ->setAd2__adr_cst_key_owner($ad2__adr_cst_key_owner)
            ->setAd2__adr_line1($ad2__adr_line1)
            ->setAd2__adr_line2($ad2__adr_line2)
            ->setAd2__adr_line3($ad2__adr_line3)
            ->setAd2__adr_city($ad2__adr_city)
            ->setAd2__adr_state($ad2__adr_state)
            ->setAd2__adr_post_code($ad2__adr_post_code)
            ->setAd2__adr_city_state_code($ad2__adr_city_state_code)
            ->setAd2__adr_country($ad2__adr_country)
            ->setAd2__adr_intl_province($ad2__adr_intl_province)
            ->setAd2__adr_county($ad2__adr_county)
            ->setAd2__adr_cong_dist($ad2__adr_cong_dist)
            ->setAd2__adr_state_house($ad2__adr_state_house)
            ->setAd2__adr_state_senate($ad2__adr_state_senate)
            ->setAd2__adr_latitude($ad2__adr_latitude)
            ->setAd2__adr_longitude($ad2__adr_longitude)
            ->setAd2__adr_mailing_label($ad2__adr_mailing_label)
            ->setAd2__adr_mailing_label_html($ad2__adr_mailing_label_html)
            ->setAd2__adr_add_date($ad2__adr_add_date)
            ->setAd2__adr_add_user($ad2__adr_add_user)
            ->setAd2__adr_change_date($ad2__adr_change_date)
            ->setAd2__adr_change_user($ad2__adr_change_user)
            ->setAd2__adr_delete_flag($ad2__adr_delete_flag)
            ->setAd2__adr_key_ext($ad2__adr_key_ext)
            ->setAd2__adr_bad_address_flag($ad2__adr_bad_address_flag)
            ->setAd2__adr_adb_key($ad2__adr_adb_key)
            ->setAd2__adr_entity_key($ad2__adr_entity_key)
            ->setAd2__adr_metro_stat_area($ad2__adr_metro_stat_area)
            ->setAd2__adr_carrier_route($ad2__adr_carrier_route)
            ->setAd2__adr_delivery_point_code($ad2__adr_delivery_point_code)
            ->setAd2__adr_lacs($ad2__adr_lacs)
            ->setAd2__adr_time_zone($ad2__adr_time_zone)
            ->setAd2__adr_urbanization($ad2__adr_urbanization)
            ->setAd2__adr_bar_code($ad2__adr_bar_code)
            ->setAd2__adr_fips($ad2__adr_fips)
            ->setAd2__adr_no_validation_flag($ad2__adr_no_validation_flag)
            ->setAd2__adr_attn($ad2__adr_attn)
            ->setAd2__adr_record_type_code($ad2__adr_record_type_code)
            ->setAd2__adr_geography($ad2__adr_geography);
    }
    /**
     * Get ad2__adr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_key(): ?string
    {
        return $this->ad2__adr_key ?? null;
    }
    /**
     * Set ad2__adr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_key(?string $ad2__adr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_key) && !is_string($ad2__adr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_key, true), gettype($ad2__adr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ad2__adr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ad2__adr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ad2__adr_key, true)), __LINE__);
        }
        if (is_null($ad2__adr_key) || (is_array($ad2__adr_key) && empty($ad2__adr_key))) {
            unset($this->ad2__adr_key);
        } else {
            $this->ad2__adr_key = $ad2__adr_key;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_cst_key_owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_cst_key_owner(): ?string
    {
        return $this->ad2__adr_cst_key_owner ?? null;
    }
    /**
     * Set ad2__adr_cst_key_owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_cst_key_owner
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_cst_key_owner(?string $ad2__adr_cst_key_owner = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_cst_key_owner) && !is_string($ad2__adr_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_cst_key_owner, true), gettype($ad2__adr_cst_key_owner)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ad2__adr_cst_key_owner) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ad2__adr_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ad2__adr_cst_key_owner, true)), __LINE__);
        }
        if (is_null($ad2__adr_cst_key_owner) || (is_array($ad2__adr_cst_key_owner) && empty($ad2__adr_cst_key_owner))) {
            unset($this->ad2__adr_cst_key_owner);
        } else {
            $this->ad2__adr_cst_key_owner = $ad2__adr_cst_key_owner;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_line1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_line1(): ?string
    {
        return $this->ad2__adr_line1 ?? null;
    }
    /**
     * Set ad2__adr_line1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_line1
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_line1(?string $ad2__adr_line1 = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_line1) && !is_string($ad2__adr_line1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_line1, true), gettype($ad2__adr_line1)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($ad2__adr_line1) && mb_strlen((string) $ad2__adr_line1) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $ad2__adr_line1)), __LINE__);
        }
        if (is_null($ad2__adr_line1) || (is_array($ad2__adr_line1) && empty($ad2__adr_line1))) {
            unset($this->ad2__adr_line1);
        } else {
            $this->ad2__adr_line1 = $ad2__adr_line1;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_line2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_line2(): ?string
    {
        return $this->ad2__adr_line2 ?? null;
    }
    /**
     * Set ad2__adr_line2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_line2
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_line2(?string $ad2__adr_line2 = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_line2) && !is_string($ad2__adr_line2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_line2, true), gettype($ad2__adr_line2)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($ad2__adr_line2) && mb_strlen((string) $ad2__adr_line2) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $ad2__adr_line2)), __LINE__);
        }
        if (is_null($ad2__adr_line2) || (is_array($ad2__adr_line2) && empty($ad2__adr_line2))) {
            unset($this->ad2__adr_line2);
        } else {
            $this->ad2__adr_line2 = $ad2__adr_line2;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_line3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_line3(): ?string
    {
        return $this->ad2__adr_line3 ?? null;
    }
    /**
     * Set ad2__adr_line3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_line3
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_line3(?string $ad2__adr_line3 = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_line3) && !is_string($ad2__adr_line3)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_line3, true), gettype($ad2__adr_line3)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($ad2__adr_line3) && mb_strlen((string) $ad2__adr_line3) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $ad2__adr_line3)), __LINE__);
        }
        if (is_null($ad2__adr_line3) || (is_array($ad2__adr_line3) && empty($ad2__adr_line3))) {
            unset($this->ad2__adr_line3);
        } else {
            $this->ad2__adr_line3 = $ad2__adr_line3;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_city value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_city(): ?string
    {
        return $this->ad2__adr_city ?? null;
    }
    /**
     * Set ad2__adr_city value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_city
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_city(?string $ad2__adr_city = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_city) && !is_string($ad2__adr_city)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_city, true), gettype($ad2__adr_city)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($ad2__adr_city) && mb_strlen((string) $ad2__adr_city) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $ad2__adr_city)), __LINE__);
        }
        if (is_null($ad2__adr_city) || (is_array($ad2__adr_city) && empty($ad2__adr_city))) {
            unset($this->ad2__adr_city);
        } else {
            $this->ad2__adr_city = $ad2__adr_city;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_state value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_state(): ?string
    {
        return $this->ad2__adr_state ?? null;
    }
    /**
     * Set ad2__adr_state value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_state
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_state(?string $ad2__adr_state = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_state) && !is_string($ad2__adr_state)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_state, true), gettype($ad2__adr_state)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($ad2__adr_state) && mb_strlen((string) $ad2__adr_state) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $ad2__adr_state)), __LINE__);
        }
        if (is_null($ad2__adr_state) || (is_array($ad2__adr_state) && empty($ad2__adr_state))) {
            unset($this->ad2__adr_state);
        } else {
            $this->ad2__adr_state = $ad2__adr_state;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_post_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_post_code(): ?string
    {
        return $this->ad2__adr_post_code ?? null;
    }
    /**
     * Set ad2__adr_post_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_post_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_post_code(?string $ad2__adr_post_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_post_code) && !is_string($ad2__adr_post_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_post_code, true), gettype($ad2__adr_post_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ad2__adr_post_code) && mb_strlen((string) $ad2__adr_post_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $ad2__adr_post_code)), __LINE__);
        }
        if (is_null($ad2__adr_post_code) || (is_array($ad2__adr_post_code) && empty($ad2__adr_post_code))) {
            unset($this->ad2__adr_post_code);
        } else {
            $this->ad2__adr_post_code = $ad2__adr_post_code;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_city_state_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_city_state_code(): ?string
    {
        return $this->ad2__adr_city_state_code ?? null;
    }
    /**
     * Set ad2__adr_city_state_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_city_state_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_city_state_code(?string $ad2__adr_city_state_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_city_state_code) && !is_string($ad2__adr_city_state_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_city_state_code, true), gettype($ad2__adr_city_state_code)), __LINE__);
        }
        // validation for constraint: maxLength(104)
        if (!is_null($ad2__adr_city_state_code) && mb_strlen((string) $ad2__adr_city_state_code) > 104) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 104', mb_strlen((string) $ad2__adr_city_state_code)), __LINE__);
        }
        if (is_null($ad2__adr_city_state_code) || (is_array($ad2__adr_city_state_code) && empty($ad2__adr_city_state_code))) {
            unset($this->ad2__adr_city_state_code);
        } else {
            $this->ad2__adr_city_state_code = $ad2__adr_city_state_code;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_country(): ?string
    {
        return $this->ad2__adr_country ?? null;
    }
    /**
     * Set ad2__adr_country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_country
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_country(?string $ad2__adr_country = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_country) && !is_string($ad2__adr_country)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_country, true), gettype($ad2__adr_country)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($ad2__adr_country) && mb_strlen((string) $ad2__adr_country) > 60) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen((string) $ad2__adr_country)), __LINE__);
        }
        if (is_null($ad2__adr_country) || (is_array($ad2__adr_country) && empty($ad2__adr_country))) {
            unset($this->ad2__adr_country);
        } else {
            $this->ad2__adr_country = $ad2__adr_country;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_intl_province value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_intl_province(): ?string
    {
        return $this->ad2__adr_intl_province ?? null;
    }
    /**
     * Set ad2__adr_intl_province value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_intl_province
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_intl_province(?string $ad2__adr_intl_province = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_intl_province) && !is_string($ad2__adr_intl_province)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_intl_province, true), gettype($ad2__adr_intl_province)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($ad2__adr_intl_province) && mb_strlen((string) $ad2__adr_intl_province) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $ad2__adr_intl_province)), __LINE__);
        }
        if (is_null($ad2__adr_intl_province) || (is_array($ad2__adr_intl_province) && empty($ad2__adr_intl_province))) {
            unset($this->ad2__adr_intl_province);
        } else {
            $this->ad2__adr_intl_province = $ad2__adr_intl_province;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_county value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_county(): ?string
    {
        return $this->ad2__adr_county ?? null;
    }
    /**
     * Set ad2__adr_county value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_county
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_county(?string $ad2__adr_county = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_county) && !is_string($ad2__adr_county)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_county, true), gettype($ad2__adr_county)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($ad2__adr_county) && mb_strlen((string) $ad2__adr_county) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $ad2__adr_county)), __LINE__);
        }
        if (is_null($ad2__adr_county) || (is_array($ad2__adr_county) && empty($ad2__adr_county))) {
            unset($this->ad2__adr_county);
        } else {
            $this->ad2__adr_county = $ad2__adr_county;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_cong_dist value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_cong_dist(): ?string
    {
        return $this->ad2__adr_cong_dist ?? null;
    }
    /**
     * Set ad2__adr_cong_dist value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_cong_dist
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_cong_dist(?string $ad2__adr_cong_dist = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_cong_dist) && !is_string($ad2__adr_cong_dist)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_cong_dist, true), gettype($ad2__adr_cong_dist)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($ad2__adr_cong_dist) && mb_strlen((string) $ad2__adr_cong_dist) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen((string) $ad2__adr_cong_dist)), __LINE__);
        }
        if (is_null($ad2__adr_cong_dist) || (is_array($ad2__adr_cong_dist) && empty($ad2__adr_cong_dist))) {
            unset($this->ad2__adr_cong_dist);
        } else {
            $this->ad2__adr_cong_dist = $ad2__adr_cong_dist;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_state_house value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_state_house(): ?string
    {
        return $this->ad2__adr_state_house ?? null;
    }
    /**
     * Set ad2__adr_state_house value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_state_house
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_state_house(?string $ad2__adr_state_house = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_state_house) && !is_string($ad2__adr_state_house)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_state_house, true), gettype($ad2__adr_state_house)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($ad2__adr_state_house) && mb_strlen((string) $ad2__adr_state_house) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen((string) $ad2__adr_state_house)), __LINE__);
        }
        if (is_null($ad2__adr_state_house) || (is_array($ad2__adr_state_house) && empty($ad2__adr_state_house))) {
            unset($this->ad2__adr_state_house);
        } else {
            $this->ad2__adr_state_house = $ad2__adr_state_house;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_state_senate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_state_senate(): ?string
    {
        return $this->ad2__adr_state_senate ?? null;
    }
    /**
     * Set ad2__adr_state_senate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_state_senate
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_state_senate(?string $ad2__adr_state_senate = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_state_senate) && !is_string($ad2__adr_state_senate)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_state_senate, true), gettype($ad2__adr_state_senate)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($ad2__adr_state_senate) && mb_strlen((string) $ad2__adr_state_senate) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen((string) $ad2__adr_state_senate)), __LINE__);
        }
        if (is_null($ad2__adr_state_senate) || (is_array($ad2__adr_state_senate) && empty($ad2__adr_state_senate))) {
            unset($this->ad2__adr_state_senate);
        } else {
            $this->ad2__adr_state_senate = $ad2__adr_state_senate;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_latitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAd2__adr_latitude(): ?float
    {
        return $this->ad2__adr_latitude ?? null;
    }
    /**
     * Set ad2__adr_latitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ad2__adr_latitude
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_latitude(?float $ad2__adr_latitude = null): self
    {
        // validation for constraint: float
        if (!is_null($ad2__adr_latitude) && !(is_float($ad2__adr_latitude) || is_numeric($ad2__adr_latitude))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ad2__adr_latitude, true), gettype($ad2__adr_latitude)), __LINE__);
        }
        if (is_null($ad2__adr_latitude) || (is_array($ad2__adr_latitude) && empty($ad2__adr_latitude))) {
            unset($this->ad2__adr_latitude);
        } else {
            $this->ad2__adr_latitude = $ad2__adr_latitude;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_longitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAd2__adr_longitude(): ?float
    {
        return $this->ad2__adr_longitude ?? null;
    }
    /**
     * Set ad2__adr_longitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ad2__adr_longitude
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_longitude(?float $ad2__adr_longitude = null): self
    {
        // validation for constraint: float
        if (!is_null($ad2__adr_longitude) && !(is_float($ad2__adr_longitude) || is_numeric($ad2__adr_longitude))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ad2__adr_longitude, true), gettype($ad2__adr_longitude)), __LINE__);
        }
        if (is_null($ad2__adr_longitude) || (is_array($ad2__adr_longitude) && empty($ad2__adr_longitude))) {
            unset($this->ad2__adr_longitude);
        } else {
            $this->ad2__adr_longitude = $ad2__adr_longitude;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_mailing_label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_mailing_label(): ?string
    {
        return $this->ad2__adr_mailing_label ?? null;
    }
    /**
     * Set ad2__adr_mailing_label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_mailing_label
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_mailing_label(?string $ad2__adr_mailing_label = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_mailing_label) && !is_string($ad2__adr_mailing_label)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_mailing_label, true), gettype($ad2__adr_mailing_label)), __LINE__);
        }
        // validation for constraint: maxLength(450)
        if (!is_null($ad2__adr_mailing_label) && mb_strlen((string) $ad2__adr_mailing_label) > 450) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 450', mb_strlen((string) $ad2__adr_mailing_label)), __LINE__);
        }
        if (is_null($ad2__adr_mailing_label) || (is_array($ad2__adr_mailing_label) && empty($ad2__adr_mailing_label))) {
            unset($this->ad2__adr_mailing_label);
        } else {
            $this->ad2__adr_mailing_label = $ad2__adr_mailing_label;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_mailing_label_html value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_mailing_label_html(): ?string
    {
        return $this->ad2__adr_mailing_label_html ?? null;
    }
    /**
     * Set ad2__adr_mailing_label_html value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_mailing_label_html
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_mailing_label_html(?string $ad2__adr_mailing_label_html = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_mailing_label_html) && !is_string($ad2__adr_mailing_label_html)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_mailing_label_html, true), gettype($ad2__adr_mailing_label_html)), __LINE__);
        }
        // validation for constraint: maxLength(450)
        if (!is_null($ad2__adr_mailing_label_html) && mb_strlen((string) $ad2__adr_mailing_label_html) > 450) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 450', mb_strlen((string) $ad2__adr_mailing_label_html)), __LINE__);
        }
        if (is_null($ad2__adr_mailing_label_html) || (is_array($ad2__adr_mailing_label_html) && empty($ad2__adr_mailing_label_html))) {
            unset($this->ad2__adr_mailing_label_html);
        } else {
            $this->ad2__adr_mailing_label_html = $ad2__adr_mailing_label_html;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_add_date(): ?string
    {
        return $this->ad2__adr_add_date ?? null;
    }
    /**
     * Set ad2__adr_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_add_date(?string $ad2__adr_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_add_date) && !is_string($ad2__adr_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_add_date, true), gettype($ad2__adr_add_date)), __LINE__);
        }
        if (is_null($ad2__adr_add_date) || (is_array($ad2__adr_add_date) && empty($ad2__adr_add_date))) {
            unset($this->ad2__adr_add_date);
        } else {
            $this->ad2__adr_add_date = $ad2__adr_add_date;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_add_user(): ?string
    {
        return $this->ad2__adr_add_user ?? null;
    }
    /**
     * Set ad2__adr_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_add_user(?string $ad2__adr_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_add_user) && !is_string($ad2__adr_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_add_user, true), gettype($ad2__adr_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ad2__adr_add_user) && mb_strlen((string) $ad2__adr_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ad2__adr_add_user)), __LINE__);
        }
        if (is_null($ad2__adr_add_user) || (is_array($ad2__adr_add_user) && empty($ad2__adr_add_user))) {
            unset($this->ad2__adr_add_user);
        } else {
            $this->ad2__adr_add_user = $ad2__adr_add_user;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_change_date(): ?string
    {
        return $this->ad2__adr_change_date ?? null;
    }
    /**
     * Set ad2__adr_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_change_date(?string $ad2__adr_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_change_date) && !is_string($ad2__adr_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_change_date, true), gettype($ad2__adr_change_date)), __LINE__);
        }
        if (is_null($ad2__adr_change_date) || (is_array($ad2__adr_change_date) && empty($ad2__adr_change_date))) {
            unset($this->ad2__adr_change_date);
        } else {
            $this->ad2__adr_change_date = $ad2__adr_change_date;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_change_user(): ?string
    {
        return $this->ad2__adr_change_user ?? null;
    }
    /**
     * Set ad2__adr_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_change_user(?string $ad2__adr_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_change_user) && !is_string($ad2__adr_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_change_user, true), gettype($ad2__adr_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ad2__adr_change_user) && mb_strlen((string) $ad2__adr_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ad2__adr_change_user)), __LINE__);
        }
        if (is_null($ad2__adr_change_user) || (is_array($ad2__adr_change_user) && empty($ad2__adr_change_user))) {
            unset($this->ad2__adr_change_user);
        } else {
            $this->ad2__adr_change_user = $ad2__adr_change_user;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_delete_flag(): ?string
    {
        return $this->ad2__adr_delete_flag ?? null;
    }
    /**
     * Set ad2__adr_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_delete_flag(?string $ad2__adr_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_delete_flag) && !is_string($ad2__adr_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_delete_flag, true), gettype($ad2__adr_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ad2__adr_delete_flag) && $ad2__adr_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ad2__adr_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ad2__adr_delete_flag) && $ad2__adr_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ad2__adr_delete_flag, true)), __LINE__);
        }
        if (is_null($ad2__adr_delete_flag) || (is_array($ad2__adr_delete_flag) && empty($ad2__adr_delete_flag))) {
            unset($this->ad2__adr_delete_flag);
        } else {
            $this->ad2__adr_delete_flag = $ad2__adr_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_key_ext(): ?string
    {
        return $this->ad2__adr_key_ext ?? null;
    }
    /**
     * Set ad2__adr_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_key_ext(?string $ad2__adr_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_key_ext) && !is_string($ad2__adr_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_key_ext, true), gettype($ad2__adr_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ad2__adr_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ad2__adr_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ad2__adr_key_ext, true)), __LINE__);
        }
        if (is_null($ad2__adr_key_ext) || (is_array($ad2__adr_key_ext) && empty($ad2__adr_key_ext))) {
            unset($this->ad2__adr_key_ext);
        } else {
            $this->ad2__adr_key_ext = $ad2__adr_key_ext;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_bad_address_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_bad_address_flag(): ?string
    {
        return $this->ad2__adr_bad_address_flag ?? null;
    }
    /**
     * Set ad2__adr_bad_address_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_bad_address_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_bad_address_flag(?string $ad2__adr_bad_address_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_bad_address_flag) && !is_string($ad2__adr_bad_address_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_bad_address_flag, true), gettype($ad2__adr_bad_address_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ad2__adr_bad_address_flag) && $ad2__adr_bad_address_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ad2__adr_bad_address_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ad2__adr_bad_address_flag) && $ad2__adr_bad_address_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ad2__adr_bad_address_flag, true)), __LINE__);
        }
        if (is_null($ad2__adr_bad_address_flag) || (is_array($ad2__adr_bad_address_flag) && empty($ad2__adr_bad_address_flag))) {
            unset($this->ad2__adr_bad_address_flag);
        } else {
            $this->ad2__adr_bad_address_flag = $ad2__adr_bad_address_flag;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_adb_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_adb_key(): ?string
    {
        return $this->ad2__adr_adb_key ?? null;
    }
    /**
     * Set ad2__adr_adb_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_adb_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_adb_key(?string $ad2__adr_adb_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_adb_key) && !is_string($ad2__adr_adb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_adb_key, true), gettype($ad2__adr_adb_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ad2__adr_adb_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ad2__adr_adb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ad2__adr_adb_key, true)), __LINE__);
        }
        if (is_null($ad2__adr_adb_key) || (is_array($ad2__adr_adb_key) && empty($ad2__adr_adb_key))) {
            unset($this->ad2__adr_adb_key);
        } else {
            $this->ad2__adr_adb_key = $ad2__adr_adb_key;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_entity_key(): ?string
    {
        return $this->ad2__adr_entity_key ?? null;
    }
    /**
     * Set ad2__adr_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_entity_key(?string $ad2__adr_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_entity_key) && !is_string($ad2__adr_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_entity_key, true), gettype($ad2__adr_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ad2__adr_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ad2__adr_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ad2__adr_entity_key, true)), __LINE__);
        }
        if (is_null($ad2__adr_entity_key) || (is_array($ad2__adr_entity_key) && empty($ad2__adr_entity_key))) {
            unset($this->ad2__adr_entity_key);
        } else {
            $this->ad2__adr_entity_key = $ad2__adr_entity_key;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_metro_stat_area value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_metro_stat_area(): ?string
    {
        return $this->ad2__adr_metro_stat_area ?? null;
    }
    /**
     * Set ad2__adr_metro_stat_area value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_metro_stat_area
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_metro_stat_area(?string $ad2__adr_metro_stat_area = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_metro_stat_area) && !is_string($ad2__adr_metro_stat_area)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_metro_stat_area, true), gettype($ad2__adr_metro_stat_area)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($ad2__adr_metro_stat_area) && mb_strlen((string) $ad2__adr_metro_stat_area) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $ad2__adr_metro_stat_area)), __LINE__);
        }
        if (is_null($ad2__adr_metro_stat_area) || (is_array($ad2__adr_metro_stat_area) && empty($ad2__adr_metro_stat_area))) {
            unset($this->ad2__adr_metro_stat_area);
        } else {
            $this->ad2__adr_metro_stat_area = $ad2__adr_metro_stat_area;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_carrier_route value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_carrier_route(): ?string
    {
        return $this->ad2__adr_carrier_route ?? null;
    }
    /**
     * Set ad2__adr_carrier_route value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_carrier_route
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_carrier_route(?string $ad2__adr_carrier_route = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_carrier_route) && !is_string($ad2__adr_carrier_route)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_carrier_route, true), gettype($ad2__adr_carrier_route)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($ad2__adr_carrier_route) && mb_strlen((string) $ad2__adr_carrier_route) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $ad2__adr_carrier_route)), __LINE__);
        }
        if (is_null($ad2__adr_carrier_route) || (is_array($ad2__adr_carrier_route) && empty($ad2__adr_carrier_route))) {
            unset($this->ad2__adr_carrier_route);
        } else {
            $this->ad2__adr_carrier_route = $ad2__adr_carrier_route;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_delivery_point_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_delivery_point_code(): ?string
    {
        return $this->ad2__adr_delivery_point_code ?? null;
    }
    /**
     * Set ad2__adr_delivery_point_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_delivery_point_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_delivery_point_code(?string $ad2__adr_delivery_point_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_delivery_point_code) && !is_string($ad2__adr_delivery_point_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_delivery_point_code, true), gettype($ad2__adr_delivery_point_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($ad2__adr_delivery_point_code) && mb_strlen((string) $ad2__adr_delivery_point_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $ad2__adr_delivery_point_code)), __LINE__);
        }
        if (is_null($ad2__adr_delivery_point_code) || (is_array($ad2__adr_delivery_point_code) && empty($ad2__adr_delivery_point_code))) {
            unset($this->ad2__adr_delivery_point_code);
        } else {
            $this->ad2__adr_delivery_point_code = $ad2__adr_delivery_point_code;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_lacs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_lacs(): ?string
    {
        return $this->ad2__adr_lacs ?? null;
    }
    /**
     * Set ad2__adr_lacs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_lacs
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_lacs(?string $ad2__adr_lacs = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_lacs) && !is_string($ad2__adr_lacs)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_lacs, true), gettype($ad2__adr_lacs)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($ad2__adr_lacs) && mb_strlen((string) $ad2__adr_lacs) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen((string) $ad2__adr_lacs)), __LINE__);
        }
        if (is_null($ad2__adr_lacs) || (is_array($ad2__adr_lacs) && empty($ad2__adr_lacs))) {
            unset($this->ad2__adr_lacs);
        } else {
            $this->ad2__adr_lacs = $ad2__adr_lacs;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_time_zone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_time_zone(): ?string
    {
        return $this->ad2__adr_time_zone ?? null;
    }
    /**
     * Set ad2__adr_time_zone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_time_zone
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_time_zone(?string $ad2__adr_time_zone = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_time_zone) && !is_string($ad2__adr_time_zone)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_time_zone, true), gettype($ad2__adr_time_zone)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ad2__adr_time_zone) && mb_strlen((string) $ad2__adr_time_zone) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ad2__adr_time_zone)), __LINE__);
        }
        if (is_null($ad2__adr_time_zone) || (is_array($ad2__adr_time_zone) && empty($ad2__adr_time_zone))) {
            unset($this->ad2__adr_time_zone);
        } else {
            $this->ad2__adr_time_zone = $ad2__adr_time_zone;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_urbanization value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_urbanization(): ?string
    {
        return $this->ad2__adr_urbanization ?? null;
    }
    /**
     * Set ad2__adr_urbanization value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_urbanization
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_urbanization(?string $ad2__adr_urbanization = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_urbanization) && !is_string($ad2__adr_urbanization)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_urbanization, true), gettype($ad2__adr_urbanization)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($ad2__adr_urbanization) && mb_strlen((string) $ad2__adr_urbanization) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $ad2__adr_urbanization)), __LINE__);
        }
        if (is_null($ad2__adr_urbanization) || (is_array($ad2__adr_urbanization) && empty($ad2__adr_urbanization))) {
            unset($this->ad2__adr_urbanization);
        } else {
            $this->ad2__adr_urbanization = $ad2__adr_urbanization;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_bar_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_bar_code(): ?string
    {
        return $this->ad2__adr_bar_code ?? null;
    }
    /**
     * Set ad2__adr_bar_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_bar_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_bar_code(?string $ad2__adr_bar_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_bar_code) && !is_string($ad2__adr_bar_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_bar_code, true), gettype($ad2__adr_bar_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ad2__adr_bar_code) && mb_strlen((string) $ad2__adr_bar_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ad2__adr_bar_code)), __LINE__);
        }
        if (is_null($ad2__adr_bar_code) || (is_array($ad2__adr_bar_code) && empty($ad2__adr_bar_code))) {
            unset($this->ad2__adr_bar_code);
        } else {
            $this->ad2__adr_bar_code = $ad2__adr_bar_code;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_fips value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_fips(): ?string
    {
        return $this->ad2__adr_fips ?? null;
    }
    /**
     * Set ad2__adr_fips value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_fips
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_fips(?string $ad2__adr_fips = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_fips) && !is_string($ad2__adr_fips)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_fips, true), gettype($ad2__adr_fips)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($ad2__adr_fips) && mb_strlen((string) $ad2__adr_fips) > 5) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen((string) $ad2__adr_fips)), __LINE__);
        }
        if (is_null($ad2__adr_fips) || (is_array($ad2__adr_fips) && empty($ad2__adr_fips))) {
            unset($this->ad2__adr_fips);
        } else {
            $this->ad2__adr_fips = $ad2__adr_fips;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_no_validation_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_no_validation_flag(): ?string
    {
        return $this->ad2__adr_no_validation_flag ?? null;
    }
    /**
     * Set ad2__adr_no_validation_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_no_validation_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_no_validation_flag(?string $ad2__adr_no_validation_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_no_validation_flag) && !is_string($ad2__adr_no_validation_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_no_validation_flag, true), gettype($ad2__adr_no_validation_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ad2__adr_no_validation_flag) && $ad2__adr_no_validation_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ad2__adr_no_validation_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ad2__adr_no_validation_flag) && $ad2__adr_no_validation_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ad2__adr_no_validation_flag, true)), __LINE__);
        }
        if (is_null($ad2__adr_no_validation_flag) || (is_array($ad2__adr_no_validation_flag) && empty($ad2__adr_no_validation_flag))) {
            unset($this->ad2__adr_no_validation_flag);
        } else {
            $this->ad2__adr_no_validation_flag = $ad2__adr_no_validation_flag;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_attn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_attn(): ?string
    {
        return $this->ad2__adr_attn ?? null;
    }
    /**
     * Set ad2__adr_attn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_attn
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_attn(?string $ad2__adr_attn = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_attn) && !is_string($ad2__adr_attn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_attn, true), gettype($ad2__adr_attn)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($ad2__adr_attn) && mb_strlen((string) $ad2__adr_attn) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $ad2__adr_attn)), __LINE__);
        }
        if (is_null($ad2__adr_attn) || (is_array($ad2__adr_attn) && empty($ad2__adr_attn))) {
            unset($this->ad2__adr_attn);
        } else {
            $this->ad2__adr_attn = $ad2__adr_attn;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_record_type_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_record_type_code(): ?string
    {
        return $this->ad2__adr_record_type_code ?? null;
    }
    /**
     * Set ad2__adr_record_type_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_record_type_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_record_type_code(?string $ad2__adr_record_type_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_record_type_code) && !is_string($ad2__adr_record_type_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_record_type_code, true), gettype($ad2__adr_record_type_code)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($ad2__adr_record_type_code) && mb_strlen((string) $ad2__adr_record_type_code) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen((string) $ad2__adr_record_type_code)), __LINE__);
        }
        if (is_null($ad2__adr_record_type_code) || (is_array($ad2__adr_record_type_code) && empty($ad2__adr_record_type_code))) {
            unset($this->ad2__adr_record_type_code);
        } else {
            $this->ad2__adr_record_type_code = $ad2__adr_record_type_code;
        }
        
        return $this;
    }
    /**
     * Get ad2__adr_geography value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2__adr_geography(): ?string
    {
        return $this->ad2__adr_geography ?? null;
    }
    /**
     * Set ad2__adr_geography value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2__adr_geography
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Billing_Address_1_DataObjectType
     */
    public function setAd2__adr_geography(?string $ad2__adr_geography = null): self
    {
        // validation for constraint: string
        if (!is_null($ad2__adr_geography) && !is_string($ad2__adr_geography)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2__adr_geography, true), gettype($ad2__adr_geography)), __LINE__);
        }
        if (is_null($ad2__adr_geography) || (is_array($ad2__adr_geography) && empty($ad2__adr_geography))) {
            unset($this->ad2__adr_geography);
        } else {
            $this->ad2__adr_geography = $ad2__adr_geography;
        }
        
        return $this;
    }
}
