<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Organization_Social_Links_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Organization_Social_Links_DataObjectType extends AbstractStructBase
{
    /**
     * The cel_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cel_cst_key = null;
    /**
     * The cel_facebook_name
     * Meta information extracted from the WSDL
     * - documentation: Facebook Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cel_facebook_name = null;
    /**
     * The cel_linkedin_name
     * Meta information extracted from the WSDL
     * - documentation: LinkedIn Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cel_linkedin_name = null;
    /**
     * The cel_twitter_name
     * Meta information extracted from the WSDL
     * - documentation: Twitter Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cel_twitter_name = null;
    /**
     * The cel_foursquare_name
     * Meta information extracted from the WSDL
     * - documentation: Foursquare Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cel_foursquare_name = null;
    /**
     * The cel_facebook_key
     * Meta information extracted from the WSDL
     * - documentation: Facebook Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 250
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cel_facebook_key = null;
    /**
     * The cel_facebook_secret
     * Meta information extracted from the WSDL
     * - documentation: Facebook Secret. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 250
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cel_facebook_secret = null;
    /**
     * The cel_facebook_id
     * Meta information extracted from the WSDL
     * - documentation: Facebook ID. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cel_facebook_id = null;
    /**
     * The cel_twitter_key
     * Meta information extracted from the WSDL
     * - documentation: Twitter Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 250
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cel_twitter_key = null;
    /**
     * The cel_twitter_secret
     * Meta information extracted from the WSDL
     * - documentation: Twitter Secret. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 250
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cel_twitter_secret = null;
    /**
     * The cel_linkedin_key
     * Meta information extracted from the WSDL
     * - documentation: Linkedin Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 250
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cel_linkedin_key = null;
    /**
     * The cel_linkedin_secret
     * Meta information extracted from the WSDL
     * - documentation: Linkedin Secret. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 250
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cel_linkedin_secret = null;
    /**
     * The cel_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cel_add_user = null;
    /**
     * The cel_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cel_add_date = null;
    /**
     * The cel_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cel_change_user = null;
    /**
     * The cel_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cel_change_date = null;
    /**
     * The cel_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cel_delete_flag = null;
    /**
     * The cel_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cel_entity_key = null;
    /**
     * The cel_profiling_date
     * Meta information extracted from the WSDL
     * - documentation: Profiling Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cel_profiling_date = null;
    /**
     * The cel_flickr_name
     * Meta information extracted from the WSDL
     * - documentation: Flickr Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cel_flickr_name = null;
    /**
     * The cel_cst_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cel_cst_key_ext = null;
    /**
     * The cel_youtube_name
     * Meta information extracted from the WSDL
     * - documentation: YouTube Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cel_youtube_name = null;
    /**
     * The cel_slideshare_name
     * Meta information extracted from the WSDL
     * - documentation: SlideShare Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cel_slideshare_name = null;
    /**
     * Constructor method for Organization_Social_Links_DataObjectType
     * @uses Organization_Social_Links_DataObjectType::setCel_cst_key()
     * @uses Organization_Social_Links_DataObjectType::setCel_facebook_name()
     * @uses Organization_Social_Links_DataObjectType::setCel_linkedin_name()
     * @uses Organization_Social_Links_DataObjectType::setCel_twitter_name()
     * @uses Organization_Social_Links_DataObjectType::setCel_foursquare_name()
     * @uses Organization_Social_Links_DataObjectType::setCel_facebook_key()
     * @uses Organization_Social_Links_DataObjectType::setCel_facebook_secret()
     * @uses Organization_Social_Links_DataObjectType::setCel_facebook_id()
     * @uses Organization_Social_Links_DataObjectType::setCel_twitter_key()
     * @uses Organization_Social_Links_DataObjectType::setCel_twitter_secret()
     * @uses Organization_Social_Links_DataObjectType::setCel_linkedin_key()
     * @uses Organization_Social_Links_DataObjectType::setCel_linkedin_secret()
     * @uses Organization_Social_Links_DataObjectType::setCel_add_user()
     * @uses Organization_Social_Links_DataObjectType::setCel_add_date()
     * @uses Organization_Social_Links_DataObjectType::setCel_change_user()
     * @uses Organization_Social_Links_DataObjectType::setCel_change_date()
     * @uses Organization_Social_Links_DataObjectType::setCel_delete_flag()
     * @uses Organization_Social_Links_DataObjectType::setCel_entity_key()
     * @uses Organization_Social_Links_DataObjectType::setCel_profiling_date()
     * @uses Organization_Social_Links_DataObjectType::setCel_flickr_name()
     * @uses Organization_Social_Links_DataObjectType::setCel_cst_key_ext()
     * @uses Organization_Social_Links_DataObjectType::setCel_youtube_name()
     * @uses Organization_Social_Links_DataObjectType::setCel_slideshare_name()
     * @param string $cel_cst_key
     * @param string $cel_facebook_name
     * @param string $cel_linkedin_name
     * @param string $cel_twitter_name
     * @param string $cel_foursquare_name
     * @param string $cel_facebook_key
     * @param string $cel_facebook_secret
     * @param string $cel_facebook_id
     * @param string $cel_twitter_key
     * @param string $cel_twitter_secret
     * @param string $cel_linkedin_key
     * @param string $cel_linkedin_secret
     * @param string $cel_add_user
     * @param string $cel_add_date
     * @param string $cel_change_user
     * @param string $cel_change_date
     * @param string $cel_delete_flag
     * @param string $cel_entity_key
     * @param string $cel_profiling_date
     * @param string $cel_flickr_name
     * @param string $cel_cst_key_ext
     * @param string $cel_youtube_name
     * @param string $cel_slideshare_name
     */
    public function __construct(?string $cel_cst_key = null, ?string $cel_facebook_name = null, ?string $cel_linkedin_name = null, ?string $cel_twitter_name = null, ?string $cel_foursquare_name = null, ?string $cel_facebook_key = null, ?string $cel_facebook_secret = null, ?string $cel_facebook_id = null, ?string $cel_twitter_key = null, ?string $cel_twitter_secret = null, ?string $cel_linkedin_key = null, ?string $cel_linkedin_secret = null, ?string $cel_add_user = null, ?string $cel_add_date = null, ?string $cel_change_user = null, ?string $cel_change_date = null, ?string $cel_delete_flag = null, ?string $cel_entity_key = null, ?string $cel_profiling_date = null, ?string $cel_flickr_name = null, ?string $cel_cst_key_ext = null, ?string $cel_youtube_name = null, ?string $cel_slideshare_name = null)
    {
        $this
            ->setCel_cst_key($cel_cst_key)
            ->setCel_facebook_name($cel_facebook_name)
            ->setCel_linkedin_name($cel_linkedin_name)
            ->setCel_twitter_name($cel_twitter_name)
            ->setCel_foursquare_name($cel_foursquare_name)
            ->setCel_facebook_key($cel_facebook_key)
            ->setCel_facebook_secret($cel_facebook_secret)
            ->setCel_facebook_id($cel_facebook_id)
            ->setCel_twitter_key($cel_twitter_key)
            ->setCel_twitter_secret($cel_twitter_secret)
            ->setCel_linkedin_key($cel_linkedin_key)
            ->setCel_linkedin_secret($cel_linkedin_secret)
            ->setCel_add_user($cel_add_user)
            ->setCel_add_date($cel_add_date)
            ->setCel_change_user($cel_change_user)
            ->setCel_change_date($cel_change_date)
            ->setCel_delete_flag($cel_delete_flag)
            ->setCel_entity_key($cel_entity_key)
            ->setCel_profiling_date($cel_profiling_date)
            ->setCel_flickr_name($cel_flickr_name)
            ->setCel_cst_key_ext($cel_cst_key_ext)
            ->setCel_youtube_name($cel_youtube_name)
            ->setCel_slideshare_name($cel_slideshare_name);
    }
    /**
     * Get cel_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_cst_key(): ?string
    {
        return $this->cel_cst_key ?? null;
    }
    /**
     * Set cel_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_cst_key(?string $cel_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_cst_key) && !is_string($cel_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_cst_key, true), gettype($cel_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cel_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cel_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cel_cst_key, true)), __LINE__);
        }
        if (is_null($cel_cst_key) || (is_array($cel_cst_key) && empty($cel_cst_key))) {
            unset($this->cel_cst_key);
        } else {
            $this->cel_cst_key = $cel_cst_key;
        }
        
        return $this;
    }
    /**
     * Get cel_facebook_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_facebook_name(): ?string
    {
        return $this->cel_facebook_name ?? null;
    }
    /**
     * Set cel_facebook_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_facebook_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_facebook_name(?string $cel_facebook_name = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_facebook_name) && !is_string($cel_facebook_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_facebook_name, true), gettype($cel_facebook_name)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($cel_facebook_name) && mb_strlen((string) $cel_facebook_name) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $cel_facebook_name)), __LINE__);
        }
        if (is_null($cel_facebook_name) || (is_array($cel_facebook_name) && empty($cel_facebook_name))) {
            unset($this->cel_facebook_name);
        } else {
            $this->cel_facebook_name = $cel_facebook_name;
        }
        
        return $this;
    }
    /**
     * Get cel_linkedin_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_linkedin_name(): ?string
    {
        return $this->cel_linkedin_name ?? null;
    }
    /**
     * Set cel_linkedin_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_linkedin_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_linkedin_name(?string $cel_linkedin_name = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_linkedin_name) && !is_string($cel_linkedin_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_linkedin_name, true), gettype($cel_linkedin_name)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($cel_linkedin_name) && mb_strlen((string) $cel_linkedin_name) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $cel_linkedin_name)), __LINE__);
        }
        if (is_null($cel_linkedin_name) || (is_array($cel_linkedin_name) && empty($cel_linkedin_name))) {
            unset($this->cel_linkedin_name);
        } else {
            $this->cel_linkedin_name = $cel_linkedin_name;
        }
        
        return $this;
    }
    /**
     * Get cel_twitter_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_twitter_name(): ?string
    {
        return $this->cel_twitter_name ?? null;
    }
    /**
     * Set cel_twitter_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_twitter_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_twitter_name(?string $cel_twitter_name = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_twitter_name) && !is_string($cel_twitter_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_twitter_name, true), gettype($cel_twitter_name)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($cel_twitter_name) && mb_strlen((string) $cel_twitter_name) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $cel_twitter_name)), __LINE__);
        }
        if (is_null($cel_twitter_name) || (is_array($cel_twitter_name) && empty($cel_twitter_name))) {
            unset($this->cel_twitter_name);
        } else {
            $this->cel_twitter_name = $cel_twitter_name;
        }
        
        return $this;
    }
    /**
     * Get cel_foursquare_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_foursquare_name(): ?string
    {
        return $this->cel_foursquare_name ?? null;
    }
    /**
     * Set cel_foursquare_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_foursquare_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_foursquare_name(?string $cel_foursquare_name = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_foursquare_name) && !is_string($cel_foursquare_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_foursquare_name, true), gettype($cel_foursquare_name)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($cel_foursquare_name) && mb_strlen((string) $cel_foursquare_name) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $cel_foursquare_name)), __LINE__);
        }
        if (is_null($cel_foursquare_name) || (is_array($cel_foursquare_name) && empty($cel_foursquare_name))) {
            unset($this->cel_foursquare_name);
        } else {
            $this->cel_foursquare_name = $cel_foursquare_name;
        }
        
        return $this;
    }
    /**
     * Get cel_facebook_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_facebook_key(): ?string
    {
        return $this->cel_facebook_key ?? null;
    }
    /**
     * Set cel_facebook_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_facebook_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_facebook_key(?string $cel_facebook_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_facebook_key) && !is_string($cel_facebook_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_facebook_key, true), gettype($cel_facebook_key)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($cel_facebook_key) && mb_strlen((string) $cel_facebook_key) > 250) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen((string) $cel_facebook_key)), __LINE__);
        }
        if (is_null($cel_facebook_key) || (is_array($cel_facebook_key) && empty($cel_facebook_key))) {
            unset($this->cel_facebook_key);
        } else {
            $this->cel_facebook_key = $cel_facebook_key;
        }
        
        return $this;
    }
    /**
     * Get cel_facebook_secret value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_facebook_secret(): ?string
    {
        return $this->cel_facebook_secret ?? null;
    }
    /**
     * Set cel_facebook_secret value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_facebook_secret
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_facebook_secret(?string $cel_facebook_secret = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_facebook_secret) && !is_string($cel_facebook_secret)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_facebook_secret, true), gettype($cel_facebook_secret)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($cel_facebook_secret) && mb_strlen((string) $cel_facebook_secret) > 250) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen((string) $cel_facebook_secret)), __LINE__);
        }
        if (is_null($cel_facebook_secret) || (is_array($cel_facebook_secret) && empty($cel_facebook_secret))) {
            unset($this->cel_facebook_secret);
        } else {
            $this->cel_facebook_secret = $cel_facebook_secret;
        }
        
        return $this;
    }
    /**
     * Get cel_facebook_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_facebook_id(): ?string
    {
        return $this->cel_facebook_id ?? null;
    }
    /**
     * Set cel_facebook_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_facebook_id
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_facebook_id(?string $cel_facebook_id = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_facebook_id) && !is_string($cel_facebook_id)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_facebook_id, true), gettype($cel_facebook_id)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cel_facebook_id) && mb_strlen((string) $cel_facebook_id) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cel_facebook_id)), __LINE__);
        }
        if (is_null($cel_facebook_id) || (is_array($cel_facebook_id) && empty($cel_facebook_id))) {
            unset($this->cel_facebook_id);
        } else {
            $this->cel_facebook_id = $cel_facebook_id;
        }
        
        return $this;
    }
    /**
     * Get cel_twitter_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_twitter_key(): ?string
    {
        return $this->cel_twitter_key ?? null;
    }
    /**
     * Set cel_twitter_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_twitter_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_twitter_key(?string $cel_twitter_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_twitter_key) && !is_string($cel_twitter_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_twitter_key, true), gettype($cel_twitter_key)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($cel_twitter_key) && mb_strlen((string) $cel_twitter_key) > 250) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen((string) $cel_twitter_key)), __LINE__);
        }
        if (is_null($cel_twitter_key) || (is_array($cel_twitter_key) && empty($cel_twitter_key))) {
            unset($this->cel_twitter_key);
        } else {
            $this->cel_twitter_key = $cel_twitter_key;
        }
        
        return $this;
    }
    /**
     * Get cel_twitter_secret value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_twitter_secret(): ?string
    {
        return $this->cel_twitter_secret ?? null;
    }
    /**
     * Set cel_twitter_secret value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_twitter_secret
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_twitter_secret(?string $cel_twitter_secret = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_twitter_secret) && !is_string($cel_twitter_secret)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_twitter_secret, true), gettype($cel_twitter_secret)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($cel_twitter_secret) && mb_strlen((string) $cel_twitter_secret) > 250) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen((string) $cel_twitter_secret)), __LINE__);
        }
        if (is_null($cel_twitter_secret) || (is_array($cel_twitter_secret) && empty($cel_twitter_secret))) {
            unset($this->cel_twitter_secret);
        } else {
            $this->cel_twitter_secret = $cel_twitter_secret;
        }
        
        return $this;
    }
    /**
     * Get cel_linkedin_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_linkedin_key(): ?string
    {
        return $this->cel_linkedin_key ?? null;
    }
    /**
     * Set cel_linkedin_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_linkedin_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_linkedin_key(?string $cel_linkedin_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_linkedin_key) && !is_string($cel_linkedin_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_linkedin_key, true), gettype($cel_linkedin_key)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($cel_linkedin_key) && mb_strlen((string) $cel_linkedin_key) > 250) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen((string) $cel_linkedin_key)), __LINE__);
        }
        if (is_null($cel_linkedin_key) || (is_array($cel_linkedin_key) && empty($cel_linkedin_key))) {
            unset($this->cel_linkedin_key);
        } else {
            $this->cel_linkedin_key = $cel_linkedin_key;
        }
        
        return $this;
    }
    /**
     * Get cel_linkedin_secret value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_linkedin_secret(): ?string
    {
        return $this->cel_linkedin_secret ?? null;
    }
    /**
     * Set cel_linkedin_secret value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_linkedin_secret
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_linkedin_secret(?string $cel_linkedin_secret = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_linkedin_secret) && !is_string($cel_linkedin_secret)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_linkedin_secret, true), gettype($cel_linkedin_secret)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($cel_linkedin_secret) && mb_strlen((string) $cel_linkedin_secret) > 250) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen((string) $cel_linkedin_secret)), __LINE__);
        }
        if (is_null($cel_linkedin_secret) || (is_array($cel_linkedin_secret) && empty($cel_linkedin_secret))) {
            unset($this->cel_linkedin_secret);
        } else {
            $this->cel_linkedin_secret = $cel_linkedin_secret;
        }
        
        return $this;
    }
    /**
     * Get cel_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_add_user(): ?string
    {
        return $this->cel_add_user ?? null;
    }
    /**
     * Set cel_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_add_user(?string $cel_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_add_user) && !is_string($cel_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_add_user, true), gettype($cel_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cel_add_user) && mb_strlen((string) $cel_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cel_add_user)), __LINE__);
        }
        if (is_null($cel_add_user) || (is_array($cel_add_user) && empty($cel_add_user))) {
            unset($this->cel_add_user);
        } else {
            $this->cel_add_user = $cel_add_user;
        }
        
        return $this;
    }
    /**
     * Get cel_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_add_date(): ?string
    {
        return $this->cel_add_date ?? null;
    }
    /**
     * Set cel_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_add_date(?string $cel_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_add_date) && !is_string($cel_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_add_date, true), gettype($cel_add_date)), __LINE__);
        }
        if (is_null($cel_add_date) || (is_array($cel_add_date) && empty($cel_add_date))) {
            unset($this->cel_add_date);
        } else {
            $this->cel_add_date = $cel_add_date;
        }
        
        return $this;
    }
    /**
     * Get cel_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_change_user(): ?string
    {
        return $this->cel_change_user ?? null;
    }
    /**
     * Set cel_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_change_user(?string $cel_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_change_user) && !is_string($cel_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_change_user, true), gettype($cel_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cel_change_user) && mb_strlen((string) $cel_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cel_change_user)), __LINE__);
        }
        if (is_null($cel_change_user) || (is_array($cel_change_user) && empty($cel_change_user))) {
            unset($this->cel_change_user);
        } else {
            $this->cel_change_user = $cel_change_user;
        }
        
        return $this;
    }
    /**
     * Get cel_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_change_date(): ?string
    {
        return $this->cel_change_date ?? null;
    }
    /**
     * Set cel_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_change_date(?string $cel_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_change_date) && !is_string($cel_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_change_date, true), gettype($cel_change_date)), __LINE__);
        }
        if (is_null($cel_change_date) || (is_array($cel_change_date) && empty($cel_change_date))) {
            unset($this->cel_change_date);
        } else {
            $this->cel_change_date = $cel_change_date;
        }
        
        return $this;
    }
    /**
     * Get cel_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_delete_flag(): ?string
    {
        return $this->cel_delete_flag ?? null;
    }
    /**
     * Set cel_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_delete_flag(?string $cel_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_delete_flag) && !is_string($cel_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_delete_flag, true), gettype($cel_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cel_delete_flag) && $cel_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cel_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cel_delete_flag) && $cel_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cel_delete_flag, true)), __LINE__);
        }
        if (is_null($cel_delete_flag) || (is_array($cel_delete_flag) && empty($cel_delete_flag))) {
            unset($this->cel_delete_flag);
        } else {
            $this->cel_delete_flag = $cel_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cel_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_entity_key(): ?string
    {
        return $this->cel_entity_key ?? null;
    }
    /**
     * Set cel_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_entity_key(?string $cel_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_entity_key) && !is_string($cel_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_entity_key, true), gettype($cel_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cel_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cel_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cel_entity_key, true)), __LINE__);
        }
        if (is_null($cel_entity_key) || (is_array($cel_entity_key) && empty($cel_entity_key))) {
            unset($this->cel_entity_key);
        } else {
            $this->cel_entity_key = $cel_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cel_profiling_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_profiling_date(): ?string
    {
        return $this->cel_profiling_date ?? null;
    }
    /**
     * Set cel_profiling_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_profiling_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_profiling_date(?string $cel_profiling_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_profiling_date) && !is_string($cel_profiling_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_profiling_date, true), gettype($cel_profiling_date)), __LINE__);
        }
        if (is_null($cel_profiling_date) || (is_array($cel_profiling_date) && empty($cel_profiling_date))) {
            unset($this->cel_profiling_date);
        } else {
            $this->cel_profiling_date = $cel_profiling_date;
        }
        
        return $this;
    }
    /**
     * Get cel_flickr_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_flickr_name(): ?string
    {
        return $this->cel_flickr_name ?? null;
    }
    /**
     * Set cel_flickr_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_flickr_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_flickr_name(?string $cel_flickr_name = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_flickr_name) && !is_string($cel_flickr_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_flickr_name, true), gettype($cel_flickr_name)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($cel_flickr_name) && mb_strlen((string) $cel_flickr_name) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $cel_flickr_name)), __LINE__);
        }
        if (is_null($cel_flickr_name) || (is_array($cel_flickr_name) && empty($cel_flickr_name))) {
            unset($this->cel_flickr_name);
        } else {
            $this->cel_flickr_name = $cel_flickr_name;
        }
        
        return $this;
    }
    /**
     * Get cel_cst_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_cst_key_ext(): ?string
    {
        return $this->cel_cst_key_ext ?? null;
    }
    /**
     * Set cel_cst_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_cst_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_cst_key_ext(?string $cel_cst_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_cst_key_ext) && !is_string($cel_cst_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_cst_key_ext, true), gettype($cel_cst_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cel_cst_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cel_cst_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cel_cst_key_ext, true)), __LINE__);
        }
        if (is_null($cel_cst_key_ext) || (is_array($cel_cst_key_ext) && empty($cel_cst_key_ext))) {
            unset($this->cel_cst_key_ext);
        } else {
            $this->cel_cst_key_ext = $cel_cst_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cel_youtube_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_youtube_name(): ?string
    {
        return $this->cel_youtube_name ?? null;
    }
    /**
     * Set cel_youtube_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_youtube_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_youtube_name(?string $cel_youtube_name = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_youtube_name) && !is_string($cel_youtube_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_youtube_name, true), gettype($cel_youtube_name)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($cel_youtube_name) && mb_strlen((string) $cel_youtube_name) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $cel_youtube_name)), __LINE__);
        }
        if (is_null($cel_youtube_name) || (is_array($cel_youtube_name) && empty($cel_youtube_name))) {
            unset($this->cel_youtube_name);
        } else {
            $this->cel_youtube_name = $cel_youtube_name;
        }
        
        return $this;
    }
    /**
     * Get cel_slideshare_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCel_slideshare_name(): ?string
    {
        return $this->cel_slideshare_name ?? null;
    }
    /**
     * Set cel_slideshare_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cel_slideshare_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Social_Links_DataObjectType
     */
    public function setCel_slideshare_name(?string $cel_slideshare_name = null): self
    {
        // validation for constraint: string
        if (!is_null($cel_slideshare_name) && !is_string($cel_slideshare_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cel_slideshare_name, true), gettype($cel_slideshare_name)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($cel_slideshare_name) && mb_strlen((string) $cel_slideshare_name) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $cel_slideshare_name)), __LINE__);
        }
        if (is_null($cel_slideshare_name) || (is_array($cel_slideshare_name) && empty($cel_slideshare_name))) {
            unset($this->cel_slideshare_name);
        } else {
            $this->cel_slideshare_name = $cel_slideshare_name;
        }
        
        return $this;
    }
}
