<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetCustomerCommunicationPreferences StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class SetCustomerCommunicationPreferences extends AbstractStructBase
{
    /**
     * The customerKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $customerKey = null;
    /**
     * The preferences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMailingListSetting|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMailingListSetting $preferences = null;
    /**
     * Constructor method for SetCustomerCommunicationPreferences
     * @uses SetCustomerCommunicationPreferences::setCustomerKey()
     * @uses SetCustomerCommunicationPreferences::setPreferences()
     * @param string $customerKey
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMailingListSetting $preferences
     */
    public function __construct(?string $customerKey = null, ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMailingListSetting $preferences = null)
    {
        $this
            ->setCustomerKey($customerKey)
            ->setPreferences($preferences);
    }
    /**
     * Get customerKey value
     * @return string|null
     */
    public function getCustomerKey(): ?string
    {
        return $this->customerKey;
    }
    /**
     * Set customerKey value
     * @param string $customerKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\SetCustomerCommunicationPreferences
     */
    public function setCustomerKey(?string $customerKey = null): self
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerKey, true), gettype($customerKey)), __LINE__);
        }
        $this->customerKey = $customerKey;
        
        return $this;
    }
    /**
     * Get preferences value
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMailingListSetting|null
     */
    public function getPreferences(): ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMailingListSetting
    {
        return $this->preferences;
    }
    /**
     * Set preferences value
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMailingListSetting $preferences
     * @return \Drupal\netforum\xWeb\Generated\StructType\SetCustomerCommunicationPreferences
     */
    public function setPreferences(?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMailingListSetting $preferences = null): self
    {
        $this->preferences = $preferences;
        
        return $this;
    }
}
