<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VersionClass StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class VersionClass extends AbstractStructBase
{
    /**
     * The MajorVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $MajorVersion = null;
    /**
     * The MinorVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $MinorVersion = null;
    /**
     * Constructor method for VersionClass
     * @uses VersionClass::setMajorVersion()
     * @uses VersionClass::setMinorVersion()
     * @param string $majorVersion
     * @param string $minorVersion
     */
    public function __construct(?string $majorVersion = null, ?string $minorVersion = null)
    {
        $this
            ->setMajorVersion($majorVersion)
            ->setMinorVersion($minorVersion);
    }
    /**
     * Get MajorVersion value
     * @return string|null
     */
    public function getMajorVersion(): ?string
    {
        return $this->MajorVersion;
    }
    /**
     * Set MajorVersion value
     * @param string $majorVersion
     * @return \Drupal\netforum\xWeb\Generated\StructType\VersionClass
     */
    public function setMajorVersion(?string $majorVersion = null): self
    {
        // validation for constraint: string
        if (!is_null($majorVersion) && !is_string($majorVersion)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($majorVersion, true), gettype($majorVersion)), __LINE__);
        }
        $this->MajorVersion = $majorVersion;
        
        return $this;
    }
    /**
     * Get MinorVersion value
     * @return string|null
     */
    public function getMinorVersion(): ?string
    {
        return $this->MinorVersion;
    }
    /**
     * Set MinorVersion value
     * @param string $minorVersion
     * @return \Drupal\netforum\xWeb\Generated\StructType\VersionClass
     */
    public function setMinorVersion(?string $minorVersion = null): self
    {
        // validation for constraint: string
        if (!is_null($minorVersion) && !is_string($minorVersion)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minorVersion, true), gettype($minorVersion)), __LINE__);
        }
        $this->MinorVersion = $minorVersion;
        
        return $this;
    }
}
