<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBActivityGetRegistrantGuests StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBActivityGetRegistrantGuests extends AbstractStructBase
{
    /**
     * The RegKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $RegKey;
    /**
     * Constructor method for WEBActivityGetRegistrantGuests
     * @uses WEBActivityGetRegistrantGuests::setRegKey()
     * @param string $regKey
     */
    public function __construct(string $regKey)
    {
        $this
            ->setRegKey($regKey);
    }
    /**
     * Get RegKey value
     * @return string
     */
    public function getRegKey(): string
    {
        return $this->RegKey;
    }
    /**
     * Set RegKey value
     * @param string $regKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetRegistrantGuests
     */
    public function setRegKey(string $regKey): self
    {
        // validation for constraint: string
        if (!is_null($regKey) && !is_string($regKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regKey, true), gettype($regKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($regKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $regKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($regKey, true)), __LINE__);
        }
        $this->RegKey = $regKey;
        
        return $this;
    }
}
