<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCentralizedShoppingCartExhibitorGet StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBCentralizedShoppingCartExhibitorGet extends AbstractStructBase
{
    /**
     * The ExhibitorKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $ExhibitorKey;
    /**
     * Constructor method for WEBCentralizedShoppingCartExhibitorGet
     * @uses WEBCentralizedShoppingCartExhibitorGet::setExhibitorKey()
     * @param string $exhibitorKey
     */
    public function __construct(string $exhibitorKey)
    {
        $this
            ->setExhibitorKey($exhibitorKey);
    }
    /**
     * Get ExhibitorKey value
     * @return string
     */
    public function getExhibitorKey(): string
    {
        return $this->ExhibitorKey;
    }
    /**
     * Set ExhibitorKey value
     * @param string $exhibitorKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGet
     */
    public function setExhibitorKey(string $exhibitorKey): self
    {
        // validation for constraint: string
        if (!is_null($exhibitorKey) && !is_string($exhibitorKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exhibitorKey, true), gettype($exhibitorKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($exhibitorKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $exhibitorKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($exhibitorKey, true)), __LINE__);
        }
        $this->ExhibitorKey = $exhibitorKey;
        
        return $this;
    }
}
