<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCentralizedShoppingCartGetFacultyListBySessionKey
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBCentralizedShoppingCartGetFacultyListBySessionKey extends AbstractStructBase
{
    /**
     * The SessionKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $SessionKey;
    /**
     * Constructor method for WEBCentralizedShoppingCartGetFacultyListBySessionKey
     * @uses WEBCentralizedShoppingCartGetFacultyListBySessionKey::setSessionKey()
     * @param string $sessionKey
     */
    public function __construct(string $sessionKey)
    {
        $this
            ->setSessionKey($sessionKey);
    }
    /**
     * Get SessionKey value
     * @return string
     */
    public function getSessionKey(): string
    {
        return $this->SessionKey;
    }
    /**
     * Set SessionKey value
     * @param string $sessionKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetFacultyListBySessionKey
     */
    public function setSessionKey(string $sessionKey): self
    {
        // validation for constraint: string
        if (!is_null($sessionKey) && !is_string($sessionKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionKey, true), gettype($sessionKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($sessionKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $sessionKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($sessionKey, true)), __LINE__);
        }
        $this->SessionKey = $sessionKey;
        
        return $this;
    }
}
