<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCentralizedShoppingCartGiftGetPremiumProductsListByGift
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBCentralizedShoppingCartGiftGetPremiumProductsListByGift extends AbstractStructBase
{
    /**
     * The GiftKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $GiftKey;
    /**
     * The GiftAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    protected float $GiftAmount;
    /**
     * Constructor method for
     * WEBCentralizedShoppingCartGiftGetPremiumProductsListByGift
     * @uses WEBCentralizedShoppingCartGiftGetPremiumProductsListByGift::setGiftKey()
     * @uses WEBCentralizedShoppingCartGiftGetPremiumProductsListByGift::setGiftAmount()
     * @param string $giftKey
     * @param float $giftAmount
     */
    public function __construct(string $giftKey, float $giftAmount)
    {
        $this
            ->setGiftKey($giftKey)
            ->setGiftAmount($giftAmount);
    }
    /**
     * Get GiftKey value
     * @return string
     */
    public function getGiftKey(): string
    {
        return $this->GiftKey;
    }
    /**
     * Set GiftKey value
     * @param string $giftKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetPremiumProductsListByGift
     */
    public function setGiftKey(string $giftKey): self
    {
        // validation for constraint: string
        if (!is_null($giftKey) && !is_string($giftKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftKey, true), gettype($giftKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($giftKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $giftKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($giftKey, true)), __LINE__);
        }
        $this->GiftKey = $giftKey;
        
        return $this;
    }
    /**
     * Get GiftAmount value
     * @return float
     */
    public function getGiftAmount(): float
    {
        return $this->GiftAmount;
    }
    /**
     * Set GiftAmount value
     * @param float $giftAmount
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetPremiumProductsListByGift
     */
    public function setGiftAmount(float $giftAmount): self
    {
        // validation for constraint: float
        if (!is_null($giftAmount) && !(is_float($giftAmount) || is_numeric($giftAmount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($giftAmount, true), gettype($giftAmount)), __LINE__);
        }
        $this->GiftAmount = $giftAmount;
        
        return $this;
    }
}
