<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCentralizedShoppingCartGiftRemoveFundraisingGift
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBCentralizedShoppingCartGiftRemoveFundraisingGift extends AbstractStructBase
{
    /**
     * The FundraisingGiftKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $FundraisingGiftKey;
    /**
     * The oCentralizedOrderEntry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType $oCentralizedOrderEntry = null;
    /**
     * Constructor method for WEBCentralizedShoppingCartGiftRemoveFundraisingGift
     * @uses WEBCentralizedShoppingCartGiftRemoveFundraisingGift::setFundraisingGiftKey()
     * @uses WEBCentralizedShoppingCartGiftRemoveFundraisingGift::setOCentralizedOrderEntry()
     * @param string $fundraisingGiftKey
     * @param \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType $oCentralizedOrderEntry
     */
    public function __construct(string $fundraisingGiftKey, ?\Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType $oCentralizedOrderEntry = null)
    {
        $this
            ->setFundraisingGiftKey($fundraisingGiftKey)
            ->setOCentralizedOrderEntry($oCentralizedOrderEntry);
    }
    /**
     * Get FundraisingGiftKey value
     * @return string
     */
    public function getFundraisingGiftKey(): string
    {
        return $this->FundraisingGiftKey;
    }
    /**
     * Set FundraisingGiftKey value
     * @param string $fundraisingGiftKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftRemoveFundraisingGift
     */
    public function setFundraisingGiftKey(string $fundraisingGiftKey): self
    {
        // validation for constraint: string
        if (!is_null($fundraisingGiftKey) && !is_string($fundraisingGiftKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fundraisingGiftKey, true), gettype($fundraisingGiftKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($fundraisingGiftKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $fundraisingGiftKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($fundraisingGiftKey, true)), __LINE__);
        }
        $this->FundraisingGiftKey = $fundraisingGiftKey;
        
        return $this;
    }
    /**
     * Get oCentralizedOrderEntry value
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType|null
     */
    public function getOCentralizedOrderEntry(): ?\Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType
    {
        return $this->oCentralizedOrderEntry;
    }
    /**
     * Set oCentralizedOrderEntry value
     * @param \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType $oCentralizedOrderEntry
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftRemoveFundraisingGift
     */
    public function setOCentralizedOrderEntry(?\Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType $oCentralizedOrderEntry = null): self
    {
        $this->oCentralizedOrderEntry = $oCentralizedOrderEntry;
        
        return $this;
    }
}
