<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * WEBCentralizedShoppingCartMembershipGetPackageComponentList StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBCentralizedShoppingCartMembershipGetPackageComponentList extends AbstractStructBase
{
    /**
     * The PackageKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $PackageKey;
    /**
     * Constructor method for
     * WEBCentralizedShoppingCartMembershipGetPackageComponentList
     * @uses WEBCentralizedShoppingCartMembershipGetPackageComponentList::setPackageKey()
     * @param string $packageKey
     */
    public function __construct(string $packageKey)
    {
        $this
            ->setPackageKey($packageKey);
    }
    /**
     * Get PackageKey value
     * @return string
     */
    public function getPackageKey(): string
    {
        return $this->PackageKey;
    }
    /**
     * Set PackageKey value
     * @param string $packageKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageComponentList
     */
    public function setPackageKey(string $packageKey): self
    {
        // validation for constraint: string
        if (!is_null($packageKey) && !is_string($packageKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageKey, true), gettype($packageKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($packageKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $packageKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($packageKey, true)), __LINE__);
        }
        $this->PackageKey = $packageKey;
        
        return $this;
    }
}
