<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * WEBCentralizedShoppingCartMembershipGetPackageListByMembershipTypeKey StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBCentralizedShoppingCartMembershipGetPackageListByMembershipTypeKey extends AbstractStructBase
{
    /**
     * The MembershipTypeKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $MembershipTypeKey;
    /**
     * Constructor method for
     * WEBCentralizedShoppingCartMembershipGetPackageListByMembershipTypeKey
     * @uses WEBCentralizedShoppingCartMembershipGetPackageListByMembershipTypeKey::setMembershipTypeKey()
     * @param string $membershipTypeKey
     */
    public function __construct(string $membershipTypeKey)
    {
        $this
            ->setMembershipTypeKey($membershipTypeKey);
    }
    /**
     * Get MembershipTypeKey value
     * @return string
     */
    public function getMembershipTypeKey(): string
    {
        return $this->MembershipTypeKey;
    }
    /**
     * Set MembershipTypeKey value
     * @param string $membershipTypeKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageListByMembershipTypeKey
     */
    public function setMembershipTypeKey(string $membershipTypeKey): self
    {
        // validation for constraint: string
        if (!is_null($membershipTypeKey) && !is_string($membershipTypeKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipTypeKey, true), gettype($membershipTypeKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($membershipTypeKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $membershipTypeKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($membershipTypeKey, true)), __LINE__);
        }
        $this->MembershipTypeKey = $membershipTypeKey;
        
        return $this;
    }
}
