<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBWebUserValidateToken_Custom StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBWebUserValidateToken_Custom extends AbstractStructBase
{
    /**
     * The authenticationToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string|null
     */
    protected ?string $authenticationToken;
    /**
     * Constructor method for WEBWebUserValidateToken_Custom
     * @uses WEBWebUserValidateToken_Custom::setAuthenticationToken()
     * @param string $authenticationToken
     */
    public function __construct(?string $authenticationToken)
    {
        $this
            ->setAuthenticationToken($authenticationToken);
    }
    /**
     * Get authenticationToken value
     * @return string|null
     */
    public function getAuthenticationToken(): ?string
    {
        return $this->authenticationToken;
    }
    /**
     * Set authenticationToken value
     * @param string $authenticationToken
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserValidateToken_Custom
     */
    public function setAuthenticationToken(?string $authenticationToken): self
    {
        // validation for constraint: string
        if (!is_null($authenticationToken) && !is_string($authenticationToken)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticationToken, true), gettype($authenticationToken)), __LINE__);
        }
        $this->authenticationToken = $authenticationToken;
        
        return $this;
    }
}
