<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebUser_Business_Address_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WebUser_Business_Address_DataObjectType extends AbstractStructBase
{
    /**
     * The adr_city
     * Meta information extracted from the WSDL
     * - documentation: City. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_city = null;
    /**
     * The adr_state
     * Meta information extracted from the WSDL
     * - documentation: State/Territory.This element has a default value of 'NULL'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_state = null;
    /**
     * The adr_post_code
     * Meta information extracted from the WSDL
     * - documentation: Postal Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_post_code = null;
    /**
     * The adr_country
     * Meta information extracted from the WSDL
     * - documentation: Country.This element has a default value of 'UNITED STATES'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_country = null;
    /**
     * Constructor method for WebUser_Business_Address_DataObjectType
     * @uses WebUser_Business_Address_DataObjectType::setAdr_city()
     * @uses WebUser_Business_Address_DataObjectType::setAdr_state()
     * @uses WebUser_Business_Address_DataObjectType::setAdr_post_code()
     * @uses WebUser_Business_Address_DataObjectType::setAdr_country()
     * @param string $adr_city
     * @param string $adr_state
     * @param string $adr_post_code
     * @param string $adr_country
     */
    public function __construct(?string $adr_city = null, ?string $adr_state = null, ?string $adr_post_code = null, ?string $adr_country = null)
    {
        $this
            ->setAdr_city($adr_city)
            ->setAdr_state($adr_state)
            ->setAdr_post_code($adr_post_code)
            ->setAdr_country($adr_country);
    }
    /**
     * Get adr_city value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_city(): ?string
    {
        return $this->adr_city ?? null;
    }
    /**
     * Set adr_city value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_city
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Address_DataObjectType
     */
    public function setAdr_city(?string $adr_city = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_city) && !is_string($adr_city)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_city, true), gettype($adr_city)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($adr_city) && mb_strlen((string) $adr_city) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $adr_city)), __LINE__);
        }
        if (is_null($adr_city) || (is_array($adr_city) && empty($adr_city))) {
            unset($this->adr_city);
        } else {
            $this->adr_city = $adr_city;
        }
        
        return $this;
    }
    /**
     * Get adr_state value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_state(): ?string
    {
        return $this->adr_state ?? null;
    }
    /**
     * Set adr_state value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_state
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Address_DataObjectType
     */
    public function setAdr_state(?string $adr_state = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_state) && !is_string($adr_state)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_state, true), gettype($adr_state)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($adr_state) && mb_strlen((string) $adr_state) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $adr_state)), __LINE__);
        }
        if (is_null($adr_state) || (is_array($adr_state) && empty($adr_state))) {
            unset($this->adr_state);
        } else {
            $this->adr_state = $adr_state;
        }
        
        return $this;
    }
    /**
     * Get adr_post_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_post_code(): ?string
    {
        return $this->adr_post_code ?? null;
    }
    /**
     * Set adr_post_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_post_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Address_DataObjectType
     */
    public function setAdr_post_code(?string $adr_post_code = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_post_code) && !is_string($adr_post_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_post_code, true), gettype($adr_post_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($adr_post_code) && mb_strlen((string) $adr_post_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $adr_post_code)), __LINE__);
        }
        if (is_null($adr_post_code) || (is_array($adr_post_code) && empty($adr_post_code))) {
            unset($this->adr_post_code);
        } else {
            $this->adr_post_code = $adr_post_code;
        }
        
        return $this;
    }
    /**
     * Get adr_country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_country(): ?string
    {
        return $this->adr_country ?? null;
    }
    /**
     * Set adr_country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_country
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Address_DataObjectType
     */
    public function setAdr_country(?string $adr_country = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_country) && !is_string($adr_country)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_country, true), gettype($adr_country)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($adr_country) && mb_strlen((string) $adr_country) > 60) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen((string) $adr_country)), __LINE__);
        }
        if (is_null($adr_country) || (is_array($adr_country) && empty($adr_country))) {
            unset($this->adr_country);
        } else {
            $this->adr_country = $adr_country;
        }
        
        return $this;
    }
}
