<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebUser_Business_Phone_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WebUser_Business_Phone_DataObjectType extends AbstractStructBase
{
    /**
     * The phn_number
     * Meta information extracted from the WSDL
     * - documentation: Phone Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $phn_number = null;
    /**
     * Constructor method for WebUser_Business_Phone_DataObjectType
     * @uses WebUser_Business_Phone_DataObjectType::setPhn_number()
     * @param string $phn_number
     */
    public function __construct(?string $phn_number = null)
    {
        $this
            ->setPhn_number($phn_number);
    }
    /**
     * Get phn_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhn_number(): ?string
    {
        return $this->phn_number ?? null;
    }
    /**
     * Set phn_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phn_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Phone_DataObjectType
     */
    public function setPhn_number(?string $phn_number = null): self
    {
        // validation for constraint: string
        if (!is_null($phn_number) && !is_string($phn_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phn_number, true), gettype($phn_number)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($phn_number) && mb_strlen((string) $phn_number) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $phn_number)), __LINE__);
        }
        if (is_null($phn_number) || (is_array($phn_number) && empty($phn_number))) {
            unset($this->phn_number);
        } else {
            $this->phn_number = $phn_number;
        }
        
        return $this;
    }
}
