<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebUser_Business_Phone_XRef_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WebUser_Business_Phone_XRef_DataObjectType extends AbstractStructBase
{
    /**
     * The cph_extension
     * Meta information extracted from the WSDL
     * - documentation: ph. ext.. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cph_extension = null;
    /**
     * Constructor method for WebUser_Business_Phone_XRef_DataObjectType
     * @uses WebUser_Business_Phone_XRef_DataObjectType::setCph_extension()
     * @param string $cph_extension
     */
    public function __construct(?string $cph_extension = null)
    {
        $this
            ->setCph_extension($cph_extension);
    }
    /**
     * Get cph_extension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCph_extension(): ?string
    {
        return $this->cph_extension ?? null;
    }
    /**
     * Set cph_extension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cph_extension
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Phone_XRef_DataObjectType
     */
    public function setCph_extension(?string $cph_extension = null): self
    {
        // validation for constraint: string
        if (!is_null($cph_extension) && !is_string($cph_extension)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cph_extension, true), gettype($cph_extension)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($cph_extension) && mb_strlen((string) $cph_extension) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $cph_extension)), __LINE__);
        }
        if (is_null($cph_extension) || (is_array($cph_extension) && empty($cph_extension))) {
            unset($this->cph_extension);
        } else {
            $this->cph_extension = $cph_extension;
        }
        
        return $this;
    }
}
