<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebUser_Customer_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WebUser_Customer_DataObjectType extends AbstractStructBase
{
    /**
     * The cst_recno
     * Meta information extracted from the WSDL
     * - documentation: Record Number. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 9223372036854775807
     * - maxOccurs: 1
     * - minInclusive: -9223372036854775808
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $cst_recno = null;
    /**
     * The cst_web_login
     * Meta information extracted from the WSDL
     * - documentation: Web Login. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_web_login = null;
    /**
     * The cst_new_password
     * Meta information extracted from the WSDL
     * - documentation: New Password. This field has this Input Mask: regex:^(?=.*[0-9]+.*)(?=.*[a-z]+.*)(?=.*[A-Z]+.*)[A-Za-z0-9!@#$%^&*()_]NULL$: (EDU Special) 8-50 characters, digit, lowercase, and uppercase required.This field is NOT a Data Field and is
     * Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_new_password = null;
    /**
     * The cst_new_password_confirm
     * Meta information extracted from the WSDL
     * - documentation: Confirm New Password.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_new_password_confirm = null;
    /**
     * Constructor method for WebUser_Customer_DataObjectType
     * @uses WebUser_Customer_DataObjectType::setCst_recno()
     * @uses WebUser_Customer_DataObjectType::setCst_web_login()
     * @uses WebUser_Customer_DataObjectType::setCst_new_password()
     * @uses WebUser_Customer_DataObjectType::setCst_new_password_confirm()
     * @param int $cst_recno
     * @param string $cst_web_login
     * @param string $cst_new_password
     * @param string $cst_new_password_confirm
     */
    public function __construct(?int $cst_recno = null, ?string $cst_web_login = null, ?string $cst_new_password = null, ?string $cst_new_password_confirm = null)
    {
        $this
            ->setCst_recno($cst_recno)
            ->setCst_web_login($cst_web_login)
            ->setCst_new_password($cst_new_password)
            ->setCst_new_password_confirm($cst_new_password_confirm);
    }
    /**
     * Get cst_recno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCst_recno(): ?int
    {
        return $this->cst_recno ?? null;
    }
    /**
     * Set cst_recno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cst_recno
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Customer_DataObjectType
     */
    public function setCst_recno(?int $cst_recno = null): self
    {
        // validation for constraint: int
        if (!is_null($cst_recno) && !(is_int($cst_recno) || ctype_digit($cst_recno))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cst_recno, true), gettype($cst_recno)), __LINE__);
        }
        // validation for constraint: maxInclusive(9223372036854775807)
        if (!is_null($cst_recno) && $cst_recno > 9223372036854775807) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9223372036854775807', var_export($cst_recno, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-9223372036854775808)
        if (!is_null($cst_recno) && $cst_recno < -9223372036854775808) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -9223372036854775808', var_export($cst_recno, true)), __LINE__);
        }
        if (is_null($cst_recno) || (is_array($cst_recno) && empty($cst_recno))) {
            unset($this->cst_recno);
        } else {
            $this->cst_recno = $cst_recno;
        }
        
        return $this;
    }
    /**
     * Get cst_web_login value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_web_login(): ?string
    {
        return $this->cst_web_login ?? null;
    }
    /**
     * Set cst_web_login value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_web_login
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Customer_DataObjectType
     */
    public function setCst_web_login(?string $cst_web_login = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_web_login) && !is_string($cst_web_login)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_web_login, true), gettype($cst_web_login)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($cst_web_login) && mb_strlen((string) $cst_web_login) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $cst_web_login)), __LINE__);
        }
        if (is_null($cst_web_login) || (is_array($cst_web_login) && empty($cst_web_login))) {
            unset($this->cst_web_login);
        } else {
            $this->cst_web_login = $cst_web_login;
        }
        
        return $this;
    }
    /**
     * Get cst_new_password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_new_password(): ?string
    {
        return $this->cst_new_password ?? null;
    }
    /**
     * Set cst_new_password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_new_password
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Customer_DataObjectType
     */
    public function setCst_new_password(?string $cst_new_password = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_new_password) && !is_string($cst_new_password)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_new_password, true), gettype($cst_new_password)), __LINE__);
        }
        if (is_null($cst_new_password) || (is_array($cst_new_password) && empty($cst_new_password))) {
            unset($this->cst_new_password);
        } else {
            $this->cst_new_password = $cst_new_password;
        }
        
        return $this;
    }
    /**
     * Get cst_new_password_confirm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_new_password_confirm(): ?string
    {
        return $this->cst_new_password_confirm ?? null;
    }
    /**
     * Set cst_new_password_confirm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_new_password_confirm
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Customer_DataObjectType
     */
    public function setCst_new_password_confirm(?string $cst_new_password_confirm = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_new_password_confirm) && !is_string($cst_new_password_confirm)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_new_password_confirm, true), gettype($cst_new_password_confirm)), __LINE__);
        }
        if (is_null($cst_new_password_confirm) || (is_array($cst_new_password_confirm) && empty($cst_new_password_confirm))) {
            unset($this->cst_new_password_confirm);
        } else {
            $this->cst_new_password_confirm = $cst_new_password_confirm;
        }
        
        return $this;
    }
}
