<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebUser_Email_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WebUser_Email_DataObjectType extends AbstractStructBase
{
    /**
     * The eml_address
     * Meta information extracted from the WSDL
     * - documentation: E-Mail Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $eml_address = null;
    /**
     * Constructor method for WebUser_Email_DataObjectType
     * @uses WebUser_Email_DataObjectType::setEml_address()
     * @param string $eml_address
     */
    public function __construct(?string $eml_address = null)
    {
        $this
            ->setEml_address($eml_address);
    }
    /**
     * Get eml_address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEml_address(): ?string
    {
        return $this->eml_address ?? null;
    }
    /**
     * Set eml_address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eml_address
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Email_DataObjectType
     */
    public function setEml_address(?string $eml_address = null): self
    {
        // validation for constraint: string
        if (!is_null($eml_address) && !is_string($eml_address)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eml_address, true), gettype($eml_address)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($eml_address) && mb_strlen((string) $eml_address) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $eml_address)), __LINE__);
        }
        if (is_null($eml_address) || (is_array($eml_address) && empty($eml_address))) {
            unset($this->eml_address);
        } else {
            $this->eml_address = $eml_address;
        }
        
        return $this;
    }
}
