<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebUser_Individual_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WebUser_Individual_DataObjectType extends AbstractStructBase
{
    /**
     * The ind_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ind_cst_key = null;
    /**
     * The ind_first_name
     * Meta information extracted from the WSDL
     * - documentation: First Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_first_name = null;
    /**
     * The ind_mid_name
     * Meta information extracted from the WSDL
     * - documentation: Middle Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_mid_name = null;
    /**
     * The ind_last_name
     * Meta information extracted from the WSDL
     * - documentation: Last Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_last_name = null;
    /**
     * The ind_full_name_cp
     * Meta information extracted from the WSDL
     * - documentation: Full Name. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 187
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_full_name_cp = null;
    /**
     * The ind_token
     * Meta information extracted from the WSDL
     * - documentation: User Token. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ind_token = null;
    /**
     * Constructor method for WebUser_Individual_DataObjectType
     * @uses WebUser_Individual_DataObjectType::setInd_cst_key()
     * @uses WebUser_Individual_DataObjectType::setInd_first_name()
     * @uses WebUser_Individual_DataObjectType::setInd_mid_name()
     * @uses WebUser_Individual_DataObjectType::setInd_last_name()
     * @uses WebUser_Individual_DataObjectType::setInd_full_name_cp()
     * @uses WebUser_Individual_DataObjectType::setInd_token()
     * @param string $ind_cst_key
     * @param string $ind_first_name
     * @param string $ind_mid_name
     * @param string $ind_last_name
     * @param string $ind_full_name_cp
     * @param string $ind_token
     */
    public function __construct(?string $ind_cst_key = null, ?string $ind_first_name = null, ?string $ind_mid_name = null, ?string $ind_last_name = null, ?string $ind_full_name_cp = null, ?string $ind_token = null)
    {
        $this
            ->setInd_cst_key($ind_cst_key)
            ->setInd_first_name($ind_first_name)
            ->setInd_mid_name($ind_mid_name)
            ->setInd_last_name($ind_last_name)
            ->setInd_full_name_cp($ind_full_name_cp)
            ->setInd_token($ind_token);
    }
    /**
     * Get ind_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_cst_key(): ?string
    {
        return $this->ind_cst_key ?? null;
    }
    /**
     * Set ind_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Individual_DataObjectType
     */
    public function setInd_cst_key(?string $ind_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_cst_key) && !is_string($ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_cst_key, true), gettype($ind_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ind_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ind_cst_key, true)), __LINE__);
        }
        if (is_null($ind_cst_key) || (is_array($ind_cst_key) && empty($ind_cst_key))) {
            unset($this->ind_cst_key);
        } else {
            $this->ind_cst_key = $ind_cst_key;
        }
        
        return $this;
    }
    /**
     * Get ind_first_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_first_name(): ?string
    {
        return $this->ind_first_name ?? null;
    }
    /**
     * Set ind_first_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_first_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Individual_DataObjectType
     */
    public function setInd_first_name(?string $ind_first_name = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_first_name) && !is_string($ind_first_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_first_name, true), gettype($ind_first_name)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($ind_first_name) && mb_strlen((string) $ind_first_name) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $ind_first_name)), __LINE__);
        }
        if (is_null($ind_first_name) || (is_array($ind_first_name) && empty($ind_first_name))) {
            unset($this->ind_first_name);
        } else {
            $this->ind_first_name = $ind_first_name;
        }
        
        return $this;
    }
    /**
     * Get ind_mid_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_mid_name(): ?string
    {
        return $this->ind_mid_name ?? null;
    }
    /**
     * Set ind_mid_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_mid_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Individual_DataObjectType
     */
    public function setInd_mid_name(?string $ind_mid_name = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_mid_name) && !is_string($ind_mid_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_mid_name, true), gettype($ind_mid_name)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($ind_mid_name) && mb_strlen((string) $ind_mid_name) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $ind_mid_name)), __LINE__);
        }
        if (is_null($ind_mid_name) || (is_array($ind_mid_name) && empty($ind_mid_name))) {
            unset($this->ind_mid_name);
        } else {
            $this->ind_mid_name = $ind_mid_name;
        }
        
        return $this;
    }
    /**
     * Get ind_last_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_last_name(): ?string
    {
        return $this->ind_last_name ?? null;
    }
    /**
     * Set ind_last_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_last_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Individual_DataObjectType
     */
    public function setInd_last_name(?string $ind_last_name = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_last_name) && !is_string($ind_last_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_last_name, true), gettype($ind_last_name)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($ind_last_name) && mb_strlen((string) $ind_last_name) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $ind_last_name)), __LINE__);
        }
        if (is_null($ind_last_name) || (is_array($ind_last_name) && empty($ind_last_name))) {
            unset($this->ind_last_name);
        } else {
            $this->ind_last_name = $ind_last_name;
        }
        
        return $this;
    }
    /**
     * Get ind_full_name_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_full_name_cp(): ?string
    {
        return $this->ind_full_name_cp ?? null;
    }
    /**
     * Set ind_full_name_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_full_name_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Individual_DataObjectType
     */
    public function setInd_full_name_cp(?string $ind_full_name_cp = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_full_name_cp) && !is_string($ind_full_name_cp)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_full_name_cp, true), gettype($ind_full_name_cp)), __LINE__);
        }
        // validation for constraint: maxLength(187)
        if (!is_null($ind_full_name_cp) && mb_strlen((string) $ind_full_name_cp) > 187) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 187', mb_strlen((string) $ind_full_name_cp)), __LINE__);
        }
        if (is_null($ind_full_name_cp) || (is_array($ind_full_name_cp) && empty($ind_full_name_cp))) {
            unset($this->ind_full_name_cp);
        } else {
            $this->ind_full_name_cp = $ind_full_name_cp;
        }
        
        return $this;
    }
    /**
     * Get ind_token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_token(): ?string
    {
        return $this->ind_token ?? null;
    }
    /**
     * Set ind_token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_token
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Individual_DataObjectType
     */
    public function setInd_token(?string $ind_token = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_token) && !is_string($ind_token)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_token, true), gettype($ind_token)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ind_token) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ind_token)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ind_token, true)), __LINE__);
        }
        if (is_null($ind_token) || (is_array($ind_token) && empty($ind_token))) {
            unset($this->ind_token);
        } else {
            $this->ind_token = $ind_token;
        }
        
        return $this;
    }
}
