<?php

/**
 * @file
 * A NetForum xWeb SOAP server using PHP's built-in webserver.
 */

declare(strict_types=1);

namespace Drupal\Tests\netforum\xWeb;

require_once __DIR__ . '/ClassLoader.php';

use Drupal\netforum\xWeb\Generated\ClassMap;

if (PHP_SAPI !== 'cli-server') {
  // This is meant to be used from the php built-in web server.
  return;
}

define("WSDL_FILE", dirname(__DIR__, 3) . DIRECTORY_SEPARATOR . 'netForumXML.wsdl');

$nfSettingsFile = getenv('settings');
if (!is_string($nfSettingsFile)) {
  throw new \Exception('settings environment variable not set.');
}

if (!file_exists($nfSettingsFile)) {
  throw new \Exception('settings file not found.');
}

$nfState = getenv('state');
if (!is_string($nfState)) {
  throw new \Exception('state environment variable not set.');
}

if (!file_exists($nfState)) {
  throw new \Exception('state file not found.');
}

new ClassLoader('Drupal\\netforum', dirname(__DIR__, 3) . '/src');
new ClassLoader('Drupal\\Tests\\netforum', dirname(__DIR__, 2) . '/src');
new ClassLoader('WsdlToPhp\\PackageBase', dirname(__DIR__, 7) . '/vendor/wsdltophp/packagebase/src');

$server = new \SoapServer(WSDL_FILE, [
  'classmap' => ClassMap::get(),
  'trace' => TRUE,
  'cache_wsdl' => WSDL_CACHE_BOTH,
  'soap_version' => SOAP_1_1,
]);
$server->setObject(new NetForumXmlHandler($server, NetForumXmlSettings::fromJsonFile($nfSettingsFile), new JsonStateStore($nfState)));
$server->handle();
