<?php

namespace Drupal\neuraflow\EventSubscriber;

use Drupal\csp\CspEvents;
use Drupal\csp\Event\PolicyAlterEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * The CSP event subscriber to alter csp policies.
 *
 * @package Drupal\neuraflow\EventSubscriber
 */
class CspSubscriber implements EventSubscriberInterface {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    if (!class_exists(CspEvents::class)) {
      return [];
    }

    return [
      CspEvents::POLICY_ALTER => 'onCspPolicyAlter',
    ];
  }

  /**
   * Alter CSP policy for tracking requests.
   */
  public function onCspPolicyAlter(PolicyAlterEvent $alterEvent): void {
    $policy = $alterEvent->getPolicy();
    $additionalUrls = ['https://chat-app.neurabot.de'];

    $policy->fallbackAwareAppendIfEnabled('style-src', $additionalUrls);
    $policy->fallbackAwareAppendIfEnabled('style-src-elem', $additionalUrls);
  }

}
