/**
 * @file
 * Defines Javascript behaviors for the cookies module.
 */
(function (Drupal) {
  /**
   * Define defaults.
   */
  Drupal.behaviors.cookiesNeurabot = {
    consentGiven() {
      const scripts = document.querySelectorAll(
        'script[id^=cookies-neurabot--]',
      );
      scripts.forEach((script) => {
        if (script && script.nodeName === 'SCRIPT') {
          const content = script.innerHTML;
          const newScript = document.createElement('script');
          const attributes = Array.from(script.attributes);
          const excludeAttributes = ['type', 'id'];
          attributes.forEach((attr) => {
            if (!excludeAttributes.includes(attr.nodeName)) {
              newScript.setAttribute(attr.nodeName, attr.nodeValue);
            }
          });
          newScript.setAttribute('type', 'module');
          newScript.innerHTML = content;
          script.parentNode.replaceChild(newScript, script);
        }
      });
    },

    attach(context) {
      const self = this;
      document.addEventListener('cookiesjsrUserConsent', function (event) {
        const service =
          typeof event.detail.services === 'object'
            ? event.detail.services
            : {};
        if (typeof service.neurabot !== 'undefined' && service.neurabot) {
          self.consentGiven(context);
        }
      });
    },
  };
})(Drupal);
