<?php

namespace Drupal\Tests\cookies_neuraflow\FunctionalJavascript;

use Drupal\cookies\Constants\CookiesConstants;
use Drupal\FunctionalJavascriptTests\WebDriverTestBase;
use Drupal\Tests\cookies\Traits\CookiesCacheClearTrait;

/**
 * Tests cookies_neuraflow Javascript related functionalities.
 *
 * @group cookies_neuraflow
 */
class CookiesNeuraflowFunctionalJavascriptTest extends WebDriverTestBase {
  use CookiesCacheClearTrait;

  /**
   * An admin user with all permissions.
   *
   * @var \Drupal\user\Entity\User
   */
  protected $adminUser;

  /**
   * The user.
   *
   * @var \Drupal\user\Entity\User
   */
  protected $user;

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = [
    'test_page_test',
    'filter_test',
    'block',
    'neuraflow',
    'cookies',
    'cookies_neuraflow',
  ];

  /**
   * {@inheritDoc}
   */
  public function setUp(): void {
    parent::setUp();

    $this->config('system.site')->set('page.front', '/test-page')->save();
    $this->user = $this->drupalCreateUser([]);
    $this->adminUser = $this->drupalCreateUser([]);
    $this->adminUser->addRole($this->createAdminRole('admin', 'admin'));
    $this->adminUser->save();
    $this->drupalLogin($this->adminUser);
    $this->drupalPlaceBlock('cookies_ui_block');
    // Set neuraflow settings:
    $this->config('neuraflow.settings')->set('neurabot.neurabotConfig.neurabotConfigId', '1')->save();

    $this->clearBackendCaches();
  }

  /**
   * Tests if the neuraflow javascript files are correctly knocked in / out.
   */
  public function testNeuraflowJsCorrectlyKnocked() {
    $session = $this->assertSession();
    $driver = $this->getSession()->getDriver();

    $this->drupalGet('<front>');

    $session->elementsCount('css', 'script[src*="js/neurabot.js"]', 1);
    $session->elementAttributeContains('css', 'script[src*="js/neurabot.js"]', 'type', CookiesConstants::COOKIES_SCRIPT_KO_TYPE);
    $session->elementAttributeContains('css', 'script[src*="js/neurabot.js"]', 'data-cookieconsent', 'neurabot');

    $session->elementsCount('css', 'script[src="https://prod-chat-app.neurabot.neuraflow.de/embed-loader.js"]', 1);
    $session->elementAttributeContains('css', 'script[src="https://prod-chat-app.neurabot.neuraflow.de/embed-loader.js"]', 'type', CookiesConstants::COOKIES_SCRIPT_KO_TYPE);
    $session->elementAttributeContains('css', 'script[src="https://prod-chat-app.neurabot.neuraflow.de/embed-loader.js"]', 'data-cookieconsent', 'neurabot');

    // Check if window.neurabot is undefined:
    $windowNeurabotUndefined = $driver->evaluateScript('window.neurabot');
    $this->assertNull($windowNeurabotUndefined);

    // Fire consent script, accept all cookies:
    $script = "var options = { all: true };
        document.dispatchEvent(new CustomEvent('cookiesjsrSetService', { detail: options }));";
    $driver->executeScript($script);

    $this->clearBackendCaches();
    $this->drupalGet('<front>');

    $session->elementsCount('css', 'script[src*="js/neurabot.js"]', 1);
    $session->elementAttributeContains('css', 'script[src*="js/neurabot.js"]', 'type', 'module');
    $session->elementAttributeContains('css', 'script[src*="js/neurabot.js"]', 'data-cookieconsent', 'neurabot');

    $session->elementsCount('css', 'script[src="https://prod-chat-app.neurabot.neuraflow.de/embed-loader.js"]', 1);
    $session->elementAttributeContains('css', 'script[src="https://prod-chat-app.neurabot.neuraflow.de/embed-loader.js"]', 'type', 'module');
    $session->elementAttributeContains('css', 'script[src="https://prod-chat-app.neurabot.neuraflow.de/embed-loader.js"]', 'data-cookieconsent', 'neurabot');
  }

}
