# NexaGuard CMP — Drupal Module

Integrates the [NexaGuard Consent Management Platform (CMP)](https://www.nexaguard.com) with Drupal to simplify GDPR and Google Consent Mode v2 compliance.

This module automatically injects the NexaGuard CMP loader `<script>` into your site’s `<head>` section, enabling a fully managed consent banner and data control experience.

---

## Features
- Automatically adds the NexaGuard CMP loader to all public pages.
- Lightweight, cache-safe, and requires no theme modifications.
- Configuration interface at `/admin/config/system/nexaguard-cmp`.
- Full support for Google Consent Mode v2 (via NexaGuard loader).
- Optionally injects only for anonymous visitors or excludes admin routes.

---

## Requirements
- Drupal 9, 10, or 11  
- PHP ≥ 8.1

---

## Installation
1. Copy the module to:  
   `/modules/custom/nexaguard_cmp/`
2. Clear Drupal caches (`drush cr` or via the admin UI).
3. Enable the module under **Extend → NexaGuard CMP**.
4. Configure at **Configuration → System → NexaGuard CMP**.

---

## Verification
After enabling, view your page source and confirm the following snippet appears in the `<head>`:

```html
<script id="nexaguard-cmp"
        data-settings-id="YOUR_ID"
        data-api-url="https://api.nexaguard.io"
        data-assets-url="https://cmp.nexaguard.com"
        src="https://cmp.nexaguard.com/loader.js"
        defer></script>


You can also verify CMP initialization using Chrome Tag Assistant or the browser’s Network tab.
License
GPL-2.0-or-later
© NexaGuard Inc. All rights reserved.