(function () {
  const cvs = document.querySelector('canvas.nxg-confetti');
  if (!cvs) { return;
  }
  const ctx = cvs.getContext('2d');
  function size() {
 cvs.width = window.innerWidth; cvs.height = window.innerHeight; }
  size();

  function randColor() {
    const p = ['var(--celebrate)','var(--celebrate2)','var(--celebrate3)','var(--celebrate4)','var(--celebrate5)','var(--accent)','var(--link)'];
    return p[Math.floor(Math.random() * p.length)];
  }

  function make(n) {
    const a = [];
    for(let i = 0; i < n; i++){
      a.push({x:Math.random() * cvs.width,y:Math.random() * cvs.height,r:5 + Math.random() * 10,
        c:randColor(),s:1.2 + Math.random() * 2.5,ang:Math.random() * Math.PI * 2,dr:(Math.random() - 0.5) * 0.15,
        rot:Math.random() * Math.PI * 2,spin:(Math.random() - 0.5) * 0.12});
    }
    return a;
  }

  let pieces = make(38 + Math.floor(Math.random() * 9));

  function draw() {
    ctx.clearRect(0,0,cvs.width,cvs.height);
    for (const p of pieces){
      p.y += p.s; p.x += Math.sin(p.ang += p.dr) * 1.5; p.rot += p.spin;
      if (p.y > cvs.height + 20){ p.y = -12; p.x = Math.random() * cvs.width; }
      ctx.save(); ctx.translate(p.x,p.y); ctx.rotate(p.rot);
      ctx.beginPath(); ctx.arc(0,0,p.r,0,Math.PI * 2);
      ctx.fillStyle = getComputedStyle(document.documentElement).getPropertyValue(p.c.replace('var(','').replace(')','')).trim() || p.c;
      ctx.globalAlpha = 0.85; ctx.fill(); ctx.restore();
    }
    requestAnimationFrame(draw);
  }
  draw();
  window.addEventListener('resize', () => { size(); pieces = make(pieces.length); });
})();
