<?php

namespace Drupal\nexaguard_cmp\Controller;

use Drupal\Core\Controller\ControllerBase;

/**
 * Provides the staging view for NexaGuard CMP.
 *
 * This page mirrors the standalone HTML version and includes
 * confetti animations, branding, and validation visuals for CMP testing.
 */
final class StagingController extends ControllerBase {

  /**
   * Renders the NexaGuard CMP staging page with confetti and visuals.
   *
   * @return array
   *   A renderable array containing the staging markup.
   */
  public function staging(): array {
    // Attach staging assets (CSS + JS).
    $build['#attached']['library'][] = 'nexaguard_cmp/staging_ui';

    // Body markup only (Drupal provides <html> and <head>).
    $build['content'] = [
      '#type' => 'markup',
      '#markup' => '
        <div class="nxg-stage">
          <canvas class="nxg-confetti"></canvas>
          <div class="nxg-inner">
            <img src="https://nexaguard.com/cmplogo.svg" alt="NexaGuard Logo" class="logo" />
            <img src="https://cdn.nexaguard.com/IABTCF.svg" alt="TCF Registered CMP" style="width:200px; margin:0 auto 22px; display:block;" />
            <div class="nxg-celebrate">
              <span class="nxg-emoji">🎉</span>
              We did it! NexaGuard CMP is now <b>IAB TCF v2.2 Validated</b>!
              <span class="nxg-cmpid">CMP&nbsp;ID&nbsp;471</span>
              <small>All those late nights finally paid off. Thank you to everyone who believed!</small>
            </div>
            <h1>Welcome to NexaGuard™ CMP!</h1>
            <p>Powered by caffeine, code, and a relentless chase of GDPR specs, our CMP stands guard 24/7.</p>
            <p>We wrestled with obscure vendor lists at 3 AM, survived infinite test loops, and bribed our servers with extra RAM, all to deliver enterprise-grade peace of mind.</p>
            <p>Got feedback? <a href="https://nexaguard.com/" target="_blank" rel="noopener">Drop us a line</a>, we’ll only reboot if you’re really, really sure.</p>
            <div class="nxg-footer">
              Disclaimer: No cookies were harmed in the making of this CMP.<br/>
              404 errors are merely tech’s way of saying “plot twist.”
            </div>
            <div class="nxg-reload">Reload for more confetti! 🎊</div>
          </div>
        </div>',
    ];

    return $build;
  }

}
