#!/bin/zsh
# --------------------------------------------------------------------
# NexaGuard CMP → Drupal sync + cache clear + server restart script
# --------------------------------------------------------------------

# Paths
SRC=~/Desktop/nexaguard_cmp/nexaguard_cmp/
DEST=~/Desktop/drusite/web/modules/custom/nexaguard_cmp/
DRUPAL=~/Desktop/drusite

echo "🔄 Syncing module files..."
rsync -av --delete "$SRC" "$DEST"

echo "🧹 Clearing Drupal caches..."
cd "$DRUPAL" || exit 1
./vendor/bin/drush cr

# Kill any existing php -S server (optional)
echo "⚙️  Stopping any previous PHP server on port 8888..."
kill -9 $(lsof -ti:8888 2>/dev/null) >/dev/null 2>&1

echo "🚀 Starting PHP built-in server on http://127.0.0.1:8888 ..."
php -S 127.0.0.1:8888 -t web

