<?php

declare(strict_types=1);

namespace Drupal\nexi_xpay\Service;

use Drupal\Component\Plugin\Exception\PluginException;
use Drupal\nexi_xpay\Entity\NexiXpayTransactionInterface;
use Drupal\nexi_xpay\Plugin\XpayMode\NexiXpayModeManager;
use Drupal\nexi_xpay\Value\ModeHandleResult;
use Drupal\nexi_xpay\Value\ModeStartResult;
use Psr\Log\LoggerInterface;
use Symfony\Component\HttpFoundation\Request;

final readonly class NexiXpayManager implements NexiXpayManagerInterface {

  public function __construct(
    private NexiXpayClientInterface $client,
    private NexiXpayModeManager     $modeManager,
    private LoggerInterface         $logger, // TODO: non viene usato, se non si ha intenzione di scrive log si può rimuovere?
  ) {}

  /**
   * @throws PluginException
   */
  private function mode(NexiXpayTransactionInterface $transaction): object {
    $pluginId = $transaction->getMode();
    return $this->modeManager->createInstance($pluginId, [
      'client' => $this->client,
    ]);
  }

  /**
   * @throws PluginException
   */
  public function startPayment(NexiXpayTransactionInterface $transaction, Request $request): ModeStartResult {
    return $this->mode($transaction)->startPayment($transaction, $request);
  }

  /**
   * @throws PluginException
   */
  public function handleReturn(NexiXpayTransactionInterface $transaction, Request $request): ModeHandleResult {
    return $this->mode($transaction)->handleReturn($transaction, $request);
  }

  /**
   * @throws PluginException
   */
  public function handleNotify(NexiXpayTransactionInterface $transaction, Request $request): ModeHandleResult {
    return $this->mode($transaction)->handleNotify($transaction, $request);
  }

  /**
   * @throws PluginException
   */
  public function buildPayPage(NexiXpayTransactionInterface $transaction, Request $request): array {
    return $this->mode($transaction)->buildPayPage($transaction, $request);
  }

  /**
   * @throws PluginException
   */
  public function buildReturnPage(NexiXpayTransactionInterface $transaction, Request $request, ModeHandleResult $handle): array {
    return $this->mode($transaction)->buildReturnPage($transaction, $request, $handle);
  }

}
