<?php

declare(strict_types=1);

namespace Drupal\nexi_xpay\Value;

final readonly class ModeHandleResult {

  private function __construct(
    public ?string $newStatus,
    public string  $message,
    public array   $context = [],
  ) {}

  public static function status(string $newStatus, string $message = '', array $context = []): self {
    return new self($newStatus, $message, $context);
  }

  public static function noop(string $message = '', array $context = []): self {
    return new self(NULL, $message, $context);
  }

}
