<?php

declare(strict_types=1);

namespace Drupal\nexi_xpay\Plugin\XpayMode;

use Drupal\Component\Plugin\PluginBase;
use Drupal\nexi_xpay\Entity\NexiXpayTransactionInterface;
use Drupal\nexi_xpay\Value\ModeHandleResult;
use Drupal\nexi_xpay\Value\ModeStartResult;
use Symfony\Component\HttpFoundation\Request;

abstract class NexiXpayModeBase extends PluginBase implements NexiXpayModeInterface {

  public function startPayment(NexiXpayTransactionInterface $transaction, Request $request): ModeStartResult {
    return ModeStartResult::render([
      '#markup' => 'Start payment not implemented for this mode.',
      '#cache' => ['max-age' => 0],
    ]);
  }


  public function handleReturn(NexiXpayTransactionInterface $transaction, Request $request): ModeHandleResult {
    return ModeHandleResult::noop('Return not implemented.');
  }

  public function handleNotify(NexiXpayTransactionInterface $transaction, Request $request): ModeHandleResult {
    return ModeHandleResult::noop('Notify not implemented.');
  }

  public function buildPayPage(NexiXpayTransactionInterface $transaction, Request $request): array {
    return [
      '#markup' => 'Pay page not implemented for this mode.',
    ];
  }

  public function buildReturnPage(NexiXpayTransactionInterface $transaction, Request $request, ModeHandleResult $handleResult): array {
    return [
      '#markup' => $handleResult->message ?: 'Return handled.',
    ];
  }

}
