<?php

declare(strict_types=1);

namespace Drupal\nexi_xpay\Plugin\XpayMode;

use AllowDynamicProperties;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\nexi_xpay\Plugin\XpayMode\Attribute\XpayMode;

#[AllowDynamicProperties]
final class NexiXpayModeManager extends DefaultPluginManager {

  public function __construct(\Traversable $namespaces, $cache_backend, $module_handler) {
    parent::__construct(
      'Plugin/XpayMode',
      $namespaces,
      $module_handler,
      NexiXpayModeInterface::class,
      XpayMode::class
    );
    $this->alterInfo('nexi_xpay_mode_info');
    $this->setCacheBackend($cache_backend, 'nexi_xpay_mode_plugins');
  }

}
