<?php

declare(strict_types=1);

namespace Drupal\nexi_xpay\Service;

interface NexiXpayClientInterface {

  /**
   * Generic request helper. Mode plugins decide endpoints/payload.
   *
   * @return array{status:int, headers:array, body:string}
   */
  public function request(string $method, string $path, array $options = []): array;

  /**
   * Nexi: GET /orders/{orderId}.
   *
   * @return array{status:int, headers:array, body:string, json:array}
   */
  public function getOrder(string $orderId, array $options = []): array;

  public function getEnvironment(): string;

  /**
   * Like request(), but JSON-decodes the body.
   *
   * @return array{status:int, headers:array, body:string, json:array}
   */
  public function requestJson(string $method, string $path, array $options = []): array;

  public function shouldLogPayloads(): bool;

}
