<?php

declare(strict_types=1);

namespace Drupal\nexi_xpay\Event;

use Drupal\nexi_xpay\Entity\NexiXpayTransactionInterface;
use Symfony\Contracts\EventDispatcher\Event;

final class TransactionStatusChangeEvent extends Event {

  public function __construct(
    public readonly NexiXpayTransactionInterface $transaction,
    public readonly string $oldStatus,
    public readonly string $newStatus,
    public readonly array $context = [],
  ) {}

}
