<?php

declare(strict_types=1);

namespace Drupal\nexi_xpay\Plugin\XpayMode;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\nexi_xpay\Entity\NexiXpayTransactionInterface;
use Drupal\nexi_xpay\Value\ModeHandleResult;
use Drupal\nexi_xpay\Value\ModeStartResult;
use Symfony\Component\HttpFoundation\Request;

interface NexiXpayModeInterface extends PluginInspectionInterface {

  public function startPayment(NexiXpayTransactionInterface $transaction, Request $request): ModeStartResult;

  public function handleReturn(NexiXpayTransactionInterface $transaction, Request $request): ModeHandleResult;

  public function handleNotify(NexiXpayTransactionInterface $transaction, Request $request): ModeHandleResult;

  /**
   * Builds the public pay page (order summary + CTA).
   */
  public function buildPayPage(NexiXpayTransactionInterface $transaction, Request $request): array;

  /**
   * Builds the public return page after handling return logic.
   */
  public function buildReturnPage(NexiXpayTransactionInterface $transaction, Request $request, ModeHandleResult $handleResult): array;


}
