<?php

declare(strict_types=1);

namespace Drupal\nexi_xpay\Service;

use Drupal\nexi_xpay\Entity\NexiXpayTransactionInterface;
use Drupal\nexi_xpay\Value\ModeHandleResult;
use Drupal\nexi_xpay\Value\ModeStartResult;
use Symfony\Component\HttpFoundation\Request;

interface NexiXpayManagerInterface {

  public function startPayment(NexiXpayTransactionInterface $transaction, Request $request): ModeStartResult;

  public function handleReturn(NexiXpayTransactionInterface $transaction, Request $request): ModeHandleResult;

  public function handleNotify(NexiXpayTransactionInterface $transaction, Request $request): ModeHandleResult;

  public function buildPayPage(NexiXpayTransactionInterface $transaction, Request $request): array;

  public function buildReturnPage(NexiXpayTransactionInterface $transaction, Request $request, ModeHandleResult $handle): array;

}
