<?php

declare(strict_types=1);

namespace Drupal\nexi_xpay\Value;

use Symfony\Component\HttpFoundation\Response;

final readonly class ModeStartResult {

  private function __construct(
    public ?Response $response,
    public ?array    $renderArray,
  ) {}

  public static function response(Response $response): self {
    return new self($response, NULL);
  }

  public static function render(array $build): self {
    return new self(NULL, $build);
  }

}
